/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.exoplayerextensions;

import android.media.MediaCodec;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import com.google.android.exoplayer.CodecCounters;
import com.google.android.exoplayer.DummyTrackRenderer;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.TimeRange;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioTrack;
import com.google.android.exoplayer.chunk.ChunkSampleSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.dash.DashChunkSource;
import com.google.android.exoplayer.drm.StreamingDrmSessionManager;
import com.google.android.exoplayer.hls.HlsSampleSource;
import com.google.android.exoplayer.metadata.MetadataTrackRenderer;
import com.google.android.exoplayer.metadata.id3.Id3Frame;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.libraries.mediaframework.exoplayerextensions.ObservablePlayerControl;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ExoplayerWrapper
implements ExoPlayer.Listener,
MediaCodecAudioTrackRenderer.EventListener,
MediaCodecVideoTrackRenderer.EventListener,
ChunkSampleSource.EventListener,
DashChunkSource.EventListener,
StreamingDrmSessionManager.EventListener,
HlsSampleSource.EventListener,
MetadataTrackRenderer.MetadataRenderer<List<Id3Frame>>,
TextRenderer,
BandwidthMeter.EventListener {
    public static final int RENDERER_COUNT = 5;
    public static final int TYPE_VIDEO = 0;
    public static final int TYPE_AUDIO = 1;
    public static final int TYPE_TEXT = 2;
    public static final int TYPE_METADATA = 3;
    public static final int TRACK_DISABLED = -1;
    public static final int TYPE_TIMED_METADATA = 3;
    public static final int TYPE_DEBUG = 4;
    private static final int RENDERER_BUILDING_STATE_IDLE = 1;
    private static final int RENDERER_BUILDING_STATE_BUILDING = 2;
    private static final int RENDERER_BUILDING_STATE_BUILT = 3;
    public static final int DISABLED_TRACK = -1;
    public static final int PRIMARY_TRACK = 0;
    private final RendererBuilder rendererBuilder;
    private final ExoPlayer player;
    private final ObservablePlayerControl playerControl;
    private final Handler mainHandler;
    private final CopyOnWriteArrayList<PlaybackListener> playbackListeners;
    private int rendererBuildingState;
    private int lastReportedPlaybackState;
    private boolean lastReportedPlayWhenReady;
    private Surface surface;
    private TrackRenderer videoRenderer;
    private TrackRenderer audioRenderer;
    private CodecCounters codecCounters;
    private Format videoFormat;
    private int videoTrackToRestore;
    private BandwidthMeter bandwidthMeter;
    private boolean backgrounded;
    private String[][] trackNames;
    private int[] selectedTracks;
    private int[] trackStateForType;
    private TextListener textListener;
    private CaptionListener captionListener;
    private Id3MetadataListener id3MetadataListener;
    private InternalErrorListener internalErrorListener;
    private InfoListener infoListener;

    public ExoplayerWrapper(RendererBuilder rendererBuilder) {
        this.rendererBuilder = rendererBuilder;
        this.player = ExoPlayer.Factory.newInstance(5, 1000, 5000);
        this.player.addListener(this);
        this.playerControl = new ObservablePlayerControl(this.player);
        this.mainHandler = new Handler();
        this.playbackListeners = new CopyOnWriteArrayList();
        this.lastReportedPlaybackState = 1;
        this.rendererBuildingState = 1;
        this.trackStateForType = new int[5];
        this.trackStateForType[2] = -1;
        this.player.setSelectedTrack(2, -1);
    }

    public ObservablePlayerControl getPlayerControl() {
        return this.playerControl;
    }

    public void addListener(PlaybackListener playbackListener) {
        this.playbackListeners.add(playbackListener);
    }

    public void removeListener(PlaybackListener playbackListener) {
        this.playbackListeners.remove(playbackListener);
    }

    public void setInternalErrorListener(InternalErrorListener internalErrorListener) {
        this.internalErrorListener = internalErrorListener;
    }

    public void setInfoListener(InfoListener infoListener) {
        this.infoListener = infoListener;
    }

    public void setCaptionListener(CaptionListener captionListener) {
        this.captionListener = captionListener;
    }

    public void setTextListener(TextListener textListener) {
        this.textListener = textListener;
    }

    public void setMetadataListener(Id3MetadataListener id3MetadataListener) {
        this.id3MetadataListener = id3MetadataListener;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
        this.pushSurfaceAndVideoTrack(false);
    }

    public Surface getSurface() {
        return this.surface;
    }

    public void blockingClearSurface() {
        this.surface = null;
        this.pushSurfaceAndVideoTrack(true);
    }

    public String[] getTracks(int n) {
        return this.trackNames == null ? null : this.trackNames[n];
    }

    public int getStateForTrackType(int n) {
        return this.trackStateForType[n];
    }

    public int getSelectedTrack(int n) {
        return this.player.getSelectedTrack(n);
    }

    public void setSelectedTrack(int n, int n2) {
        this.player.setSelectedTrack(n, n2);
        if (n == 2 && n2 < 0 && this.captionListener != null) {
            this.captionListener.onCues(Collections.emptyList());
        }
    }

    public boolean getBackgrounded() {
        return this.backgrounded;
    }

    public void setBackgrounded(boolean bl) {
        if (this.backgrounded == bl) {
            return;
        }
        this.backgrounded = bl;
        if (bl) {
            this.videoTrackToRestore = this.getSelectedTrack(0);
            this.setSelectedTrack(0, -1);
            this.blockingClearSurface();
        } else {
            this.setSelectedTrack(0, this.videoTrackToRestore);
        }
    }

    public void prepare() {
        if (this.rendererBuildingState == 3) {
            this.player.stop();
        }
        this.rendererBuilder.cancel();
        this.videoFormat = null;
        this.videoRenderer = null;
        this.audioRenderer = null;
        this.rendererBuildingState = 2;
        this.maybeReportPlayerState();
        this.rendererBuilder.buildRenderers(this);
    }

    public void onRenderers(TrackRenderer[] trackRendererArray, BandwidthMeter bandwidthMeter) {
        if (this.trackNames == null) {
            this.trackNames = new String[5][];
        }
        for (int i = 0; i < 5; ++i) {
            if (trackRendererArray[i] != null) continue;
            trackRendererArray[i] = new DummyTrackRenderer();
        }
        this.videoRenderer = trackRendererArray[0];
        this.audioRenderer = trackRendererArray[1];
        this.codecCounters = this.videoRenderer instanceof MediaCodecTrackRenderer ? ((MediaCodecTrackRenderer)this.videoRenderer).codecCounters : (trackRendererArray[1] instanceof MediaCodecTrackRenderer ? ((MediaCodecTrackRenderer)trackRendererArray[1]).codecCounters : null);
        this.rendererBuildingState = 3;
        this.bandwidthMeter = bandwidthMeter;
        this.maybeReportPlayerState();
        this.pushSurfaceAndVideoTrack(false);
        this.player.prepare(trackRendererArray);
    }

    public void onRenderersError(Exception exception) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onRendererInitializationError(exception);
        }
        for (PlaybackListener playbackListener : this.playbackListeners) {
            playbackListener.onError(exception);
        }
        this.rendererBuildingState = 1;
        this.maybeReportPlayerState();
    }

    public void setPlayWhenReady(boolean bl) {
        this.player.setPlayWhenReady(bl);
    }

    public void seekTo(int n) {
        this.player.seekTo(n);
    }

    public void release() {
        this.rendererBuilder.cancel();
        this.rendererBuildingState = 1;
        this.surface = null;
        this.player.release();
    }

    public int getPlaybackState() {
        if (this.rendererBuildingState == 2) {
            return 2;
        }
        int n = this.player.getPlaybackState();
        if (this.rendererBuildingState == 3 && this.rendererBuildingState == 1) {
            return 2;
        }
        return n;
    }

    public Format getFormat() {
        return this.videoFormat;
    }

    public BandwidthMeter getBandwidthMeter() {
        return this.bandwidthMeter;
    }

    public CodecCounters getCodecCounters() {
        return this.codecCounters;
    }

    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    public long getDuration() {
        return this.player.getDuration();
    }

    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    Handler getMainHandler() {
        return this.mainHandler;
    }

    @Override
    public void onPlayerStateChanged(boolean bl, int n) {
        this.maybeReportPlayerState();
    }

    @Override
    public void onPlayerError(ExoPlaybackException exoPlaybackException) {
        this.rendererBuildingState = 1;
        for (PlaybackListener playbackListener : this.playbackListeners) {
            playbackListener.onError(exoPlaybackException);
        }
    }

    @Override
    public void onVideoSizeChanged(int n, int n2, int n3, float f2) {
        for (PlaybackListener playbackListener : this.playbackListeners) {
            playbackListener.onVideoSizeChanged(n, n2, n3, f2);
        }
    }

    @Override
    public void onDroppedFrames(int n, long l) {
        if (this.infoListener != null) {
            this.infoListener.onDroppedFrames(n, l);
        }
    }

    @Override
    public void onBandwidthSample(int n, long l, long l2) {
        if (this.infoListener != null) {
            this.infoListener.onBandwidthSample(n, l, l2);
        }
    }

    @Override
    public void onDownstreamFormatChanged(int n, Format format, int n2, long l) {
        if (this.infoListener == null) {
            return;
        }
        if (n == 0) {
            this.videoFormat = format;
            this.infoListener.onVideoFormatEnabled(format, n2, l);
        } else if (n == 1) {
            this.infoListener.onAudioFormatEnabled(format, n2, l);
        }
    }

    @Override
    public void onLoadStarted(int n, long l, int n2, int n3, Format format, long l2, long l3) {
        if (this.infoListener != null) {
            this.infoListener.onLoadStarted(n, l, n2, n3, format, l2, l3);
        }
    }

    @Override
    public void onLoadCompleted(int n, long l, int n2, int n3, Format format, long l2, long l3, long l4, long l5) {
        if (this.infoListener != null) {
            this.infoListener.onLoadCompleted(n, l, n2, n3, format, l2, l3, l4, l5);
        }
    }

    @Override
    public void onLoadCanceled(int n, long l) {
    }

    @Override
    public void onDrmSessionManagerError(Exception exception) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onDrmSessionManagerError(exception);
        }
    }

    @Override
    public void onDecoderInitializationError(MediaCodecTrackRenderer.DecoderInitializationException decoderInitializationException) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onDecoderInitializationError(decoderInitializationException);
        }
    }

    @Override
    public void onAudioTrackInitializationError(AudioTrack.InitializationException initializationException) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackInitializationError(initializationException);
        }
    }

    @Override
    public void onAudioTrackWriteError(AudioTrack.WriteException writeException) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackWriteError(writeException);
        }
    }

    @Override
    public void onAudioTrackUnderrun(int n, long l, long l2) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackUnderrun(n, l, l2);
        }
    }

    @Override
    public void onCryptoError(MediaCodec.CryptoException cryptoException) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onCryptoError(cryptoException);
        }
    }

    @Override
    public void onDrmKeysLoaded() {
    }

    MetadataTrackRenderer.MetadataRenderer<List<Id3Frame>> getId3MetadataRenderer() {
        return new MetadataTrackRenderer.MetadataRenderer<List<Id3Frame>>(){

            @Override
            public void onMetadata(List<Id3Frame> list) {
                if (ExoplayerWrapper.this.id3MetadataListener != null) {
                    ExoplayerWrapper.this.id3MetadataListener.onId3Metadata(list);
                }
            }
        };
    }

    @Override
    public void onDecoderInitialized(String string, long l, long l2) {
        if (this.infoListener != null) {
            this.infoListener.onDecoderInitialized(string, l, l2);
        }
    }

    @Override
    public void onLoadError(int n, IOException iOException) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onLoadError(n, iOException);
        }
    }

    @Override
    public void onCues(List<Cue> list) {
        if (this.captionListener != null && this.getSelectedTrack(2) != -1) {
            this.captionListener.onCues(list);
        }
    }

    @Override
    public void onMetadata(List<Id3Frame> list) {
        if (this.id3MetadataListener != null && this.getSelectedTrack(3) != -1) {
            this.id3MetadataListener.onId3Metadata(list);
        }
    }

    @Override
    public void onAvailableRangeChanged(int n, TimeRange timeRange) {
        if (this.infoListener != null) {
            this.infoListener.onAvailableRangeChanged(n, timeRange);
        }
    }

    @Override
    public void onPlayWhenReadyCommitted() {
    }

    @Override
    public void onDrawnToSurface(Surface surface) {
    }

    @Override
    public void onUpstreamDiscarded(int n, long l, long l2) {
    }

    private void maybeReportPlayerState() {
        if (this.player == null) {
            return;
        }
        boolean bl = this.player.getPlayWhenReady();
        int n = this.getPlaybackState();
        if (this.lastReportedPlayWhenReady != bl || this.lastReportedPlaybackState != n) {
            for (PlaybackListener playbackListener : this.playbackListeners) {
                if (playbackListener == null) continue;
                playbackListener.onStateChanged(bl, n);
            }
            this.lastReportedPlayWhenReady = bl;
            this.lastReportedPlaybackState = n;
        }
    }

    private void pushSurfaceAndVideoTrack(boolean bl) {
        if (this.rendererBuildingState != 3) {
            return;
        }
        if (bl) {
            this.player.blockingSendMessage(this.videoRenderer, 1, this.surface);
        } else {
            this.player.sendMessage(this.videoRenderer, 1, this.surface);
        }
    }

    void processText(String string) {
        if (this.textListener == null || this.selectedTracks[2] == -1) {
            return;
        }
        this.textListener.onText(string);
    }

    public boolean setMute(boolean bl) {
        this.player.sendMessage(this.audioRenderer, 0, bl);
        return this.audioRenderer instanceof MediaCodecAudioTrackRenderer && ((MediaCodecAudioTrackRenderer)this.audioRenderer).getCurrentVolume() == 0.0f;
    }

    public float getCurrentVolume() {
        if (this.audioRenderer != null && this.audioRenderer instanceof MediaCodecAudioTrackRenderer) {
            return ((MediaCodecAudioTrackRenderer)this.audioRenderer).getCurrentVolume();
        }
        return 0.0f;
    }

    public static interface Id3MetadataListener {
        public void onId3Metadata(List<Id3Frame> var1);
    }

    public static interface TextListener {
        public void onText(String var1);
    }

    public static interface CaptionListener {
        public void onCues(List<Cue> var1);
    }

    public static interface InfoListener {
        public void onVideoFormatEnabled(Format var1, int var2, long var3);

        public void onAudioFormatEnabled(Format var1, int var2, long var3);

        public void onDroppedFrames(int var1, long var2);

        public void onBandwidthSample(int var1, long var2, long var4);

        public void onLoadStarted(int var1, long var2, int var4, int var5, Format var6, long var7, long var9);

        public void onLoadCompleted(int var1, long var2, int var4, int var5, Format var6, long var7, long var9, long var11, long var13);

        public void onDecoderInitialized(String var1, long var2, long var4);

        public void onAvailableRangeChanged(int var1, TimeRange var2);
    }

    public static interface InternalErrorListener {
        public void onRendererInitializationError(Exception var1);

        public void onAudioTrackInitializationError(AudioTrack.InitializationException var1);

        public void onAudioTrackWriteError(AudioTrack.WriteException var1);

        public void onAudioTrackUnderrun(int var1, long var2, long var4);

        public void onDecoderInitializationError(MediaCodecTrackRenderer.DecoderInitializationException var1);

        public void onCryptoError(MediaCodec.CryptoException var1);

        public void onUpstreamError(int var1, IOException var2);

        public void onConsumptionError(int var1, IOException var2);

        public void onDrmSessionManagerError(Exception var1);

        public void onLoadError(int var1, IOException var2);
    }

    public static interface PlaybackListener {
        public void onStateChanged(boolean var1, int var2);

        public void onError(Exception var1);

        public void onVideoSizeChanged(int var1, int var2, int var3, float var4);
    }

    public static interface RendererBuilder {
        public void buildRenderers(ExoplayerWrapper var1);

        public void cancel();
    }
}

