/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableBitArray;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class ParsableByteArray {
    public byte[] data;
    private int position;
    private int limit;

    public ParsableByteArray() {
    }

    public ParsableByteArray(int n) {
        this.data = new byte[n];
        this.limit = this.data.length;
    }

    public ParsableByteArray(byte[] byArray) {
        this.data = byArray;
        this.limit = byArray.length;
    }

    public ParsableByteArray(byte[] byArray, int n) {
        this.data = byArray;
        this.limit = n;
    }

    public void reset(byte[] byArray, int n) {
        this.data = byArray;
        this.limit = n;
        this.position = 0;
    }

    public void reset() {
        this.position = 0;
        this.limit = 0;
    }

    public int bytesLeft() {
        return this.limit - this.position;
    }

    public int limit() {
        return this.limit;
    }

    public void setLimit(int n) {
        Assertions.checkArgument(n >= 0 && n <= this.data.length);
        this.limit = n;
    }

    public int getPosition() {
        return this.position;
    }

    public int capacity() {
        return this.data == null ? 0 : this.data.length;
    }

    public void setPosition(int n) {
        Assertions.checkArgument(n >= 0 && n <= this.limit);
        this.position = n;
    }

    public void skipBytes(int n) {
        this.setPosition(this.position + n);
    }

    public void readBytes(ParsableBitArray parsableBitArray, int n) {
        this.readBytes(parsableBitArray.data, 0, n);
        parsableBitArray.setPosition(0);
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.position, byArray, n, n2);
        this.position += n2;
    }

    public void readBytes(ByteBuffer byteBuffer, int n) {
        byteBuffer.put(this.data, this.position, n);
        this.position += n;
    }

    public int readUnsignedByte() {
        return this.data[this.position++] & 0xFF;
    }

    public int readUnsignedShort() {
        return (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public int readLittleEndianUnsignedShort() {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8;
    }

    public short readShort() {
        return (short)((this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF);
    }

    public short readLittleEndianShort() {
        return (short)(this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8);
    }

    public int readUnsignedInt24() {
        return (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public int readLittleEndianInt24() {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8 | (this.data[this.position++] & 0xFF) << 16;
    }

    public int readLittleEndianUnsignedInt24() {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8 | (this.data[this.position++] & 0xFF) << 16;
    }

    public long readUnsignedInt() {
        return ((long)this.data[this.position++] & 0xFFL) << 24 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 8 | (long)this.data[this.position++] & 0xFFL;
    }

    public long readLittleEndianUnsignedInt() {
        return (long)this.data[this.position++] & 0xFFL | ((long)this.data[this.position++] & 0xFFL) << 8 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 24;
    }

    public int readInt() {
        return (this.data[this.position++] & 0xFF) << 24 | (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public int readLittleEndianInt() {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8 | (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 24;
    }

    public long readLong() {
        return ((long)this.data[this.position++] & 0xFFL) << 56 | ((long)this.data[this.position++] & 0xFFL) << 48 | ((long)this.data[this.position++] & 0xFFL) << 40 | ((long)this.data[this.position++] & 0xFFL) << 32 | ((long)this.data[this.position++] & 0xFFL) << 24 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 8 | (long)this.data[this.position++] & 0xFFL;
    }

    public long readLittleEndianLong() {
        return (long)this.data[this.position++] & 0xFFL | ((long)this.data[this.position++] & 0xFFL) << 8 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 24 | ((long)this.data[this.position++] & 0xFFL) << 32 | ((long)this.data[this.position++] & 0xFFL) << 40 | ((long)this.data[this.position++] & 0xFFL) << 48 | ((long)this.data[this.position++] & 0xFFL) << 56;
    }

    public int readUnsignedFixedPoint1616() {
        int n = (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
        this.position += 2;
        return n;
    }

    public int readSynchSafeInt() {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        return n << 21 | n2 << 14 | n3 << 7 | n4;
    }

    public int readUnsignedIntToInt() {
        int n = this.readInt();
        if (n < 0) {
            throw new IllegalStateException("Top bit not zero: " + n);
        }
        return n;
    }

    public int readLittleEndianUnsignedIntToInt() {
        int n = this.readLittleEndianInt();
        if (n < 0) {
            throw new IllegalStateException("Top bit not zero: " + n);
        }
        return n;
    }

    public long readUnsignedLongToLong() {
        long l = this.readLong();
        if (l < 0L) {
            throw new IllegalStateException("Top bit not zero: " + l);
        }
        return l;
    }

    public String readString(int n) {
        return this.readString(n, Charset.defaultCharset());
    }

    public String readString(int n, Charset charset) {
        String string = new String(this.data, this.position, n, charset);
        this.position += n;
        return string;
    }

    public String readLine() {
        int n;
        if (this.bytesLeft() == 0) {
            return null;
        }
        for (n = this.position; n < this.limit && this.data[n] != 10 && this.data[n] != 13; ++n) {
        }
        if (n - this.position >= 3 && this.data[this.position] == -17 && this.data[this.position + 1] == -69 && this.data[this.position + 2] == -65) {
            this.position += 3;
        }
        String string = new String(this.data, this.position, n - this.position);
        this.position = n;
        if (this.position == this.limit) {
            return string;
        }
        if (this.data[this.position] == 13) {
            ++this.position;
            if (this.position == this.limit) {
                return string;
            }
        }
        if (this.data[this.position] == 10) {
            ++this.position;
        }
        return string;
    }
}

