/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSourceInputStream;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class Aes128DataSource
implements DataSource {
    private final DataSource upstream;
    private final byte[] encryptionKey;
    private final byte[] encryptionIv;
    private CipherInputStream cipherInputStream;

    public Aes128DataSource(DataSource dataSource, byte[] byArray, byte[] byArray2) {
        this.upstream = dataSource;
        this.encryptionKey = byArray;
        this.encryptionIv = byArray2;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException(noSuchPaddingException);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.encryptionKey, "AES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.encryptionIv);
        try {
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException);
        }
        this.cipherInputStream = new CipherInputStream(new DataSourceInputStream(this.upstream, dataSpec), cipher);
        return -1L;
    }

    @Override
    public void close() throws IOException {
        this.cipherInputStream = null;
        this.upstream.close();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Assertions.checkState(this.cipherInputStream != null);
        int n3 = this.cipherInputStream.read(byArray, n, n2);
        if (n3 < 0) {
            return -1;
        }
        return n3;
    }
}

