/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import com.google.android.exoplayer.util.Assertions;
import java.util.Arrays;

final class NalUnitTargetBuffer {
    private final int targetType;
    private boolean isFilling;
    private boolean isCompleted;
    public byte[] nalData;
    public int nalLength;

    public NalUnitTargetBuffer(int n, int n2) {
        this.targetType = n;
        this.nalData = new byte[3 + n2];
        this.nalData[2] = 1;
    }

    public void reset() {
        this.isFilling = false;
        this.isCompleted = false;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void startNalUnit(int n) {
        Assertions.checkState(!this.isFilling);
        boolean bl = this.isFilling = n == this.targetType;
        if (this.isFilling) {
            this.nalLength = 3;
            this.isCompleted = false;
        }
    }

    public void appendToNalUnit(byte[] byArray, int n, int n2) {
        if (!this.isFilling) {
            return;
        }
        int n3 = n2 - n;
        if (this.nalData.length < this.nalLength + n3) {
            this.nalData = Arrays.copyOf(this.nalData, (this.nalLength + n3) * 2);
        }
        System.arraycopy(byArray, n, this.nalData, this.nalLength, n3);
        this.nalLength += n3;
    }

    public boolean endNalUnit(int n) {
        if (!this.isFilling) {
            return false;
        }
        this.nalLength -= n;
        this.isFilling = false;
        this.isCompleted = true;
        return true;
    }
}

