/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.util.DtsUtil;
import com.google.android.exoplayer.util.ParsableByteArray;

final class DtsReader
extends ElementaryStreamReader {
    private static final int STATE_FINDING_SYNC = 0;
    private static final int STATE_READING_HEADER = 1;
    private static final int STATE_READING_SAMPLE = 2;
    private static final int HEADER_SIZE = 15;
    private static final int SYNC_VALUE = 2147385345;
    private static final int SYNC_VALUE_SIZE = 4;
    private final ParsableByteArray headerScratchBytes = new ParsableByteArray(new byte[15]);
    private int state;
    private int bytesRead;
    private int syncBytes;
    private long sampleDurationUs;
    private MediaFormat mediaFormat;
    private int sampleSize;
    private long timeUs;

    public DtsReader(TrackOutput trackOutput) {
        super(trackOutput);
        this.headerScratchBytes.data[0] = 127;
        this.headerScratchBytes.data[1] = -2;
        this.headerScratchBytes.data[2] = -128;
        this.headerScratchBytes.data[3] = 1;
        this.state = 0;
    }

    @Override
    public void seek() {
        this.state = 0;
        this.bytesRead = 0;
        this.syncBytes = 0;
    }

    @Override
    public void packetStarted(long l, boolean bl) {
        this.timeUs = l;
    }

    @Override
    public void consume(ParsableByteArray parsableByteArray) {
        while (parsableByteArray.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    if (!this.skipToNextSync(parsableByteArray)) break;
                    this.bytesRead = 4;
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (!this.continueRead(parsableByteArray, this.headerScratchBytes.data, 15)) break;
                    this.parseHeader();
                    this.headerScratchBytes.setPosition(0);
                    this.output.sampleData(this.headerScratchBytes, 15);
                    this.state = 2;
                    break;
                }
                case 2: {
                    int n = Math.min(parsableByteArray.bytesLeft(), this.sampleSize - this.bytesRead);
                    this.output.sampleData(parsableByteArray, n);
                    this.bytesRead += n;
                    if (this.bytesRead != this.sampleSize) break;
                    this.output.sampleMetadata(this.timeUs, 1, this.sampleSize, 0, null);
                    this.timeUs += this.sampleDurationUs;
                    this.state = 0;
                }
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private boolean continueRead(ParsableByteArray parsableByteArray, byte[] byArray, int n) {
        int n2 = Math.min(parsableByteArray.bytesLeft(), n - this.bytesRead);
        parsableByteArray.readBytes(byArray, this.bytesRead, n2);
        this.bytesRead += n2;
        return this.bytesRead == n;
    }

    private boolean skipToNextSync(ParsableByteArray parsableByteArray) {
        while (parsableByteArray.bytesLeft() > 0) {
            this.syncBytes <<= 8;
            this.syncBytes |= parsableByteArray.readUnsignedByte();
            if (this.syncBytes != 2147385345) continue;
            this.syncBytes = 0;
            return true;
        }
        return false;
    }

    private void parseHeader() {
        byte[] byArray = this.headerScratchBytes.data;
        if (this.mediaFormat == null) {
            this.mediaFormat = DtsUtil.parseDtsFormat(byArray, null, -1L, null);
            this.output.format(this.mediaFormat);
        }
        this.sampleSize = DtsUtil.getDtsFrameSize(byArray);
        this.sampleDurationUs = (int)(1000000L * (long)DtsUtil.parseDtsAudioSampleCount(byArray) / (long)this.mediaFormat.sampleRate);
    }
}

