/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.chunk.BaseMediaChunk;
import com.google.android.exoplayer.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.DefaultExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public class ContainerMediaChunk
extends BaseMediaChunk
implements ChunkExtractorWrapper.SingleTrackOutput {
    private final ChunkExtractorWrapper extractorWrapper;
    private final long sampleOffsetUs;
    private final int adaptiveMaxWidth;
    private final int adaptiveMaxHeight;
    private MediaFormat mediaFormat;
    private DrmInitData drmInitData;
    private volatile int bytesLoaded;
    private volatile boolean loadCanceled;

    public ContainerMediaChunk(DataSource dataSource, DataSpec dataSpec, int n, Format format, long l, long l2, int n2, long l3, ChunkExtractorWrapper chunkExtractorWrapper, MediaFormat mediaFormat, int n3, int n4, DrmInitData drmInitData, boolean bl, int n5) {
        super(dataSource, dataSpec, n, format, l, l2, n2, bl, n5);
        this.extractorWrapper = chunkExtractorWrapper;
        this.sampleOffsetUs = l3;
        this.adaptiveMaxWidth = n3;
        this.adaptiveMaxHeight = n4;
        this.mediaFormat = ContainerMediaChunk.getAdjustedMediaFormat(mediaFormat, l3, n3, n4);
        this.drmInitData = drmInitData;
    }

    @Override
    public final long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public final MediaFormat getMediaFormat() {
        return this.mediaFormat;
    }

    @Override
    public final DrmInitData getDrmInitData() {
        return this.drmInitData;
    }

    @Override
    public final void seekMap(SeekMap seekMap) {
    }

    @Override
    public final void drmInitData(DrmInitData drmInitData) {
        this.drmInitData = drmInitData;
    }

    @Override
    public final void format(MediaFormat mediaFormat) {
        this.mediaFormat = ContainerMediaChunk.getAdjustedMediaFormat(mediaFormat, this.sampleOffsetUs, this.adaptiveMaxWidth, this.adaptiveMaxHeight);
    }

    @Override
    public final int sampleData(ExtractorInput extractorInput, int n, boolean bl) throws IOException, InterruptedException {
        return this.getOutput().sampleData(extractorInput, n, bl);
    }

    @Override
    public final void sampleData(ParsableByteArray parsableByteArray, int n) {
        this.getOutput().sampleData(parsableByteArray, n);
    }

    @Override
    public final void sampleMetadata(long l, int n, int n2, int n3, byte[] byArray) {
        this.getOutput().sampleMetadata(l + this.sampleOffsetUs, n, n2, n3, byArray);
    }

    @Override
    public final void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public final boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void load() throws IOException, InterruptedException {
        DataSpec dataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
        try {
            DefaultExtractorInput defaultExtractorInput = new DefaultExtractorInput(this.dataSource, dataSpec.absoluteStreamPosition, this.dataSource.open(dataSpec));
            if (this.bytesLoaded == 0) {
                this.extractorWrapper.init(this);
            }
            try {
                int n = 0;
                while (n == 0 && !this.loadCanceled) {
                    n = this.extractorWrapper.read(defaultExtractorInput);
                }
            }
            finally {
                this.bytesLoaded = (int)(defaultExtractorInput.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            this.dataSource.close();
        }
    }

    private static MediaFormat getAdjustedMediaFormat(MediaFormat mediaFormat, long l, int n, int n2) {
        if (mediaFormat == null) {
            return null;
        }
        if (l != 0L && mediaFormat.subsampleOffsetUs != Long.MAX_VALUE) {
            mediaFormat = mediaFormat.copyWithSubsampleOffsetUs(mediaFormat.subsampleOffsetUs + l);
        }
        if (n != -1 || n2 != -1) {
            mediaFormat = mediaFormat.copyWithMaxVideoDimensions(n, n2);
        }
        return mediaFormat;
    }
}

