/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.widget.MediaController;
import com.google.android.exoplayer.ExoPlayer;

public class PlayerControl
implements MediaController.MediaPlayerControl {
    private final ExoPlayer exoPlayer;

    public PlayerControl(ExoPlayer exoPlayer) {
        this.exoPlayer = exoPlayer;
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return true;
    }

    public boolean canSeekForward() {
        return true;
    }

    public int getAudioSessionId() {
        throw new UnsupportedOperationException();
    }

    public int getBufferPercentage() {
        return this.exoPlayer.getBufferedPercentage();
    }

    public int getCurrentPosition() {
        return this.exoPlayer.getDuration() == -1L ? 0 : (int)this.exoPlayer.getCurrentPosition();
    }

    public int getDuration() {
        return this.exoPlayer.getDuration() == -1L ? 0 : (int)this.exoPlayer.getDuration();
    }

    public boolean isPlaying() {
        return this.exoPlayer.getPlayWhenReady();
    }

    public void start() {
        this.exoPlayer.setPlayWhenReady(true);
    }

    public void pause() {
        this.exoPlayer.setPlayWhenReady(false);
    }

    public void seekTo(int n) {
        long l = this.exoPlayer.getDuration() == -1L ? 0L : (long)Math.min(Math.max(0, n), this.getDuration());
        this.exoPlayer.seekTo(l);
    }
}

