/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.text.eia608.Eia608Parser;
import com.google.android.exoplayer.util.ParsableByteArray;

final class SeiReader {
    private final TrackOutput output;

    public SeiReader(TrackOutput trackOutput) {
        this.output = trackOutput;
        trackOutput.format(MediaFormat.createTextFormat(null, "application/eia-608", -1, -1L, null));
    }

    public void consume(long l, ParsableByteArray parsableByteArray) {
        while (parsableByteArray.bytesLeft() > 1) {
            int n;
            int n2 = 0;
            do {
                n = parsableByteArray.readUnsignedByte();
                n2 += n;
            } while (n == 255);
            int n3 = 0;
            do {
                n = parsableByteArray.readUnsignedByte();
                n3 += n;
            } while (n == 255);
            if (Eia608Parser.isSeiMessageEia608(n2, n3, parsableByteArray)) {
                this.output.sampleData(parsableByteArray, n3);
                this.output.sampleMetadata(l, 1, n3, 0, null);
                continue;
            }
            parsableByteArray.skipBytes(n3);
        }
    }
}

