/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp3;

import com.google.android.exoplayer.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer.util.MpegAudioHeader;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;

final class VbriSeeker
implements Mp3Extractor.Seeker {
    private final long[] timesUs;
    private final long[] positions;
    private final long durationUs;

    public static VbriSeeker create(MpegAudioHeader mpegAudioHeader, ParsableByteArray parsableByteArray, long l, long l2) {
        parsableByteArray.skipBytes(10);
        int n = parsableByteArray.readInt();
        if (n <= 0) {
            return null;
        }
        int n2 = mpegAudioHeader.sampleRate;
        long l3 = Util.scaleLargeTimestamp(n, 1000000L * (long)(n2 >= 32000 ? 1152 : 576), n2);
        int n3 = parsableByteArray.readUnsignedShort();
        int n4 = parsableByteArray.readUnsignedShort();
        int n5 = parsableByteArray.readUnsignedShort();
        parsableByteArray.skipBytes(2);
        long[] lArray = new long[n3 + 1];
        long[] lArray2 = new long[n3 + 1];
        lArray[0] = 0L;
        lArray2[0] = l += (long)mpegAudioHeader.frameSize;
        for (int i = 1; i < lArray.length; ++i) {
            int n6;
            switch (n5) {
                case 1: {
                    n6 = parsableByteArray.readUnsignedByte();
                    break;
                }
                case 2: {
                    n6 = parsableByteArray.readUnsignedShort();
                    break;
                }
                case 3: {
                    n6 = parsableByteArray.readUnsignedInt24();
                    break;
                }
                case 4: {
                    n6 = parsableByteArray.readUnsignedIntToInt();
                    break;
                }
                default: {
                    return null;
                }
            }
            lArray[i] = (long)i * l3 / (long)n3;
            lArray2[i] = l2 == -1L ? l : Math.min(l2, l += (long)(n6 * n4));
        }
        return new VbriSeeker(lArray, lArray2, l3);
    }

    private VbriSeeker(long[] lArray, long[] lArray2, long l) {
        this.timesUs = lArray;
        this.positions = lArray2;
        this.durationUs = l;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getPosition(long l) {
        return this.positions[Util.binarySearchFloor(this.timesUs, l, true, true)];
    }

    @Override
    public long getTimeUs(long l) {
        return this.timesUs[Util.binarySearchFloor(this.positions, l, true, true)];
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }
}

