/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.os.Handler;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.NetworkLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class DefaultLoadControl
implements LoadControl {
    public static final int DEFAULT_LOW_WATERMARK_MS = 15000;
    public static final int DEFAULT_HIGH_WATERMARK_MS = 30000;
    public static final float DEFAULT_LOW_BUFFER_LOAD = 0.2f;
    public static final float DEFAULT_HIGH_BUFFER_LOAD = 0.8f;
    private static final int ABOVE_HIGH_WATERMARK = 0;
    private static final int BETWEEN_WATERMARKS = 1;
    private static final int BELOW_LOW_WATERMARK = 2;
    private final Allocator allocator;
    private final List<Object> loaders;
    private final HashMap<Object, LoaderState> loaderStates;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final long lowWatermarkUs;
    private final long highWatermarkUs;
    private final float lowBufferLoad;
    private final float highBufferLoad;
    private int targetBufferSize;
    private long maxLoadStartPositionUs;
    private int bufferState;
    private boolean fillingBuffers;
    private boolean streamingPrioritySet;

    public DefaultLoadControl(Allocator allocator) {
        this(allocator, null, null);
    }

    public DefaultLoadControl(Allocator allocator, Handler handler, EventListener eventListener) {
        this(allocator, handler, eventListener, 15000, 30000, 0.2f, 0.8f);
    }

    public DefaultLoadControl(Allocator allocator, Handler handler, EventListener eventListener, int n, int n2, float f2, float f3) {
        this.allocator = allocator;
        this.eventHandler = handler;
        this.eventListener = eventListener;
        this.loaders = new ArrayList<Object>();
        this.loaderStates = new HashMap();
        this.lowWatermarkUs = (long)n * 1000L;
        this.highWatermarkUs = (long)n2 * 1000L;
        this.lowBufferLoad = f2;
        this.highBufferLoad = f3;
    }

    @Override
    public void register(Object object, int n) {
        this.loaders.add(object);
        this.loaderStates.put(object, new LoaderState(n));
        this.targetBufferSize += n;
    }

    @Override
    public void unregister(Object object) {
        this.loaders.remove(object);
        LoaderState loaderState = this.loaderStates.remove(object);
        this.targetBufferSize -= loaderState.bufferSizeContribution;
        this.updateControlState();
    }

    @Override
    public void trimAllocator() {
        this.allocator.trim(this.targetBufferSize);
    }

    @Override
    public Allocator getAllocator() {
        return this.allocator;
    }

    @Override
    public boolean update(Object object, long l, long l2, boolean bl) {
        int n;
        int n2;
        boolean bl2;
        boolean bl3;
        int n3 = this.getLoaderBufferState(l, l2);
        LoaderState loaderState = this.loaderStates.get(object);
        boolean bl4 = bl3 = loaderState.bufferState != n3 || loaderState.nextLoadPositionUs != l2 || loaderState.loading != bl;
        if (bl3) {
            loaderState.bufferState = n3;
            loaderState.nextLoadPositionUs = l2;
            loaderState.loading = bl;
        }
        boolean bl5 = bl2 = this.bufferState != (n2 = this.getBufferState(n = this.allocator.getTotalBytesAllocated()));
        if (bl2) {
            this.bufferState = n2;
        }
        if (bl3 || bl2) {
            this.updateControlState();
        }
        return n < this.targetBufferSize && l2 != -1L && l2 <= this.maxLoadStartPositionUs;
    }

    private int getLoaderBufferState(long l, long l2) {
        if (l2 == -1L) {
            return 0;
        }
        long l3 = l2 - l;
        return l3 > this.highWatermarkUs ? 0 : (l3 < this.lowWatermarkUs ? 2 : 1);
    }

    private int getBufferState(int n) {
        float f2 = (float)n / (float)this.targetBufferSize;
        return f2 > this.highBufferLoad ? 0 : (f2 < this.lowBufferLoad ? 2 : 1);
    }

    private void updateControlState() {
        Object object;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.bufferState;
        for (n = 0; n < this.loaders.size(); ++n) {
            object = this.loaderStates.get(this.loaders.get(n));
            bl |= ((LoaderState)object).loading;
            bl2 |= ((LoaderState)object).nextLoadPositionUs != -1L;
            n2 = Math.max(n2, ((LoaderState)object).bufferState);
        }
        boolean bl3 = this.fillingBuffers = !this.loaders.isEmpty() && (bl || bl2) && (n2 == 2 || n2 == 1 && this.fillingBuffers);
        if (this.fillingBuffers && !this.streamingPrioritySet) {
            NetworkLock.instance.add(0);
            this.streamingPrioritySet = true;
            this.notifyLoadingChanged(true);
        } else if (!this.fillingBuffers && this.streamingPrioritySet && !bl) {
            NetworkLock.instance.remove(0);
            this.streamingPrioritySet = false;
            this.notifyLoadingChanged(false);
        }
        this.maxLoadStartPositionUs = -1L;
        if (this.fillingBuffers) {
            for (n = 0; n < this.loaders.size(); ++n) {
                object = this.loaders.get(n);
                LoaderState loaderState = this.loaderStates.get(object);
                long l = loaderState.nextLoadPositionUs;
                if (l == -1L || this.maxLoadStartPositionUs != -1L && l >= this.maxLoadStartPositionUs) continue;
                this.maxLoadStartPositionUs = l;
            }
        }
    }

    private void notifyLoadingChanged(final boolean bl) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    DefaultLoadControl.this.eventListener.onLoadingChanged(bl);
                }
            });
        }
    }

    private static class LoaderState {
        public final int bufferSizeContribution;
        public int bufferState;
        public boolean loading;
        public long nextLoadPositionUs;

        public LoaderState(int n) {
            this.bufferSizeContribution = n;
            this.bufferState = 0;
            this.loading = false;
            this.nextLoadPositionUs = -1L;
        }
    }

    public static interface EventListener {
        public void onLoadingChanged(boolean var1);
    }
}

