/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.impl.conn.CPoolEntry;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.http.protocol.HttpContext;

@NotThreadSafe
class CPoolProxy
implements ManagedHttpClientConnection,
HttpContext {
    private volatile CPoolEntry poolEntry;

    CPoolProxy(CPoolEntry cPoolEntry) {
        this.poolEntry = cPoolEntry;
    }

    CPoolEntry getPoolEntry() {
        return this.poolEntry;
    }

    CPoolEntry detach() {
        CPoolEntry cPoolEntry = this.poolEntry;
        this.poolEntry = null;
        return cPoolEntry;
    }

    ManagedHttpClientConnection getConnection() {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry == null) {
            return null;
        }
        return (ManagedHttpClientConnection)cPoolEntry.getConnection();
    }

    ManagedHttpClientConnection getValidConnection() {
        ManagedHttpClientConnection managedHttpClientConnection = this.getConnection();
        if (managedHttpClientConnection == null) {
            throw new ConnectionShutdownException();
        }
        return managedHttpClientConnection;
    }

    public void close() throws IOException {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry != null) {
            cPoolEntry.closeConnection();
        }
    }

    public void shutdown() throws IOException {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry != null) {
            cPoolEntry.shutdownConnection();
        }
    }

    public boolean isOpen() {
        CPoolEntry cPoolEntry = this.poolEntry;
        if (cPoolEntry != null) {
            return !cPoolEntry.isClosed();
        }
        return false;
    }

    public boolean isStale() {
        ManagedHttpClientConnection managedHttpClientConnection = this.getConnection();
        if (managedHttpClientConnection != null) {
            return managedHttpClientConnection.isStale();
        }
        return true;
    }

    public void setSocketTimeout(int n) {
        this.getValidConnection().setSocketTimeout(n);
    }

    public int getSocketTimeout() {
        return this.getValidConnection().getSocketTimeout();
    }

    @Override
    public String getId() {
        return this.getValidConnection().getId();
    }

    @Override
    public void bind(Socket socket) throws IOException {
        this.getValidConnection().bind(socket);
    }

    @Override
    public Socket getSocket() {
        return this.getValidConnection().getSocket();
    }

    @Override
    public SSLSession getSSLSession() {
        return this.getValidConnection().getSSLSession();
    }

    public boolean isResponseAvailable(int n) throws IOException {
        return this.getValidConnection().isResponseAvailable(n);
    }

    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        this.getValidConnection().sendRequestHeader(httpRequest);
    }

    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        this.getValidConnection().sendRequestEntity(httpEntityEnclosingRequest);
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        return this.getValidConnection().receiveResponseHeader();
    }

    public void receiveResponseEntity(HttpResponse httpResponse) throws HttpException, IOException {
        this.getValidConnection().receiveResponseEntity(httpResponse);
    }

    public void flush() throws IOException {
        this.getValidConnection().flush();
    }

    public HttpConnectionMetrics getMetrics() {
        return this.getValidConnection().getMetrics();
    }

    public InetAddress getLocalAddress() {
        return this.getValidConnection().getLocalAddress();
    }

    public int getLocalPort() {
        return this.getValidConnection().getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this.getValidConnection().getRemoteAddress();
    }

    public int getRemotePort() {
        return this.getValidConnection().getRemotePort();
    }

    public Object getAttribute(String string) {
        ManagedHttpClientConnection managedHttpClientConnection = this.getValidConnection();
        if (managedHttpClientConnection instanceof HttpContext) {
            return ((HttpContext)managedHttpClientConnection).getAttribute(string);
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        ManagedHttpClientConnection managedHttpClientConnection = this.getValidConnection();
        if (managedHttpClientConnection instanceof HttpContext) {
            ((HttpContext)managedHttpClientConnection).setAttribute(string, object);
        }
    }

    public Object removeAttribute(String string) {
        ManagedHttpClientConnection managedHttpClientConnection = this.getValidConnection();
        if (managedHttpClientConnection instanceof HttpContext) {
            return ((HttpContext)managedHttpClientConnection).removeAttribute(string);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CPoolProxy{");
        ManagedHttpClientConnection managedHttpClientConnection = this.getConnection();
        if (managedHttpClientConnection != null) {
            stringBuilder.append(managedHttpClientConnection);
        } else {
            stringBuilder.append("detached");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static HttpClientConnection newProxy(CPoolEntry cPoolEntry) {
        return new CPoolProxy(cPoolEntry);
    }

    private static CPoolProxy getProxy(HttpClientConnection httpClientConnection) {
        if (!CPoolProxy.class.isInstance(httpClientConnection)) {
            throw new IllegalStateException("Unexpected connection proxy class: " + httpClientConnection.getClass());
        }
        return (CPoolProxy)CPoolProxy.class.cast(httpClientConnection);
    }

    public static CPoolEntry getPoolEntry(HttpClientConnection httpClientConnection) {
        CPoolEntry cPoolEntry = CPoolProxy.getProxy(httpClientConnection).getPoolEntry();
        if (cPoolEntry == null) {
            throw new ConnectionShutdownException();
        }
        return cPoolEntry;
    }

    public static CPoolEntry detach(HttpClientConnection httpClientConnection) {
        return CPoolProxy.getProxy(httpClientConnection).detach();
    }
}

