/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Deprecated
@Immutable
public class DefaultRedirectHandler
implements RedirectHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";

    @Override
    public boolean isRedirectRequested(HttpResponse httpResponse, HttpContext httpContext) {
        Args.notNull((Object)httpResponse, (String)"HTTP response");
        int n = httpResponse.getStatusLine().getStatusCode();
        switch (n) {
            case 301: 
            case 302: 
            case 307: {
                HttpRequest httpRequest = (HttpRequest)httpContext.getAttribute("http.request");
                String string = httpRequest.getRequestLine().getMethod();
                return string.equalsIgnoreCase("GET") || string.equalsIgnoreCase("HEAD");
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    @Override
    public URI getLocationURI(HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        URI uRI;
        URI uRI2;
        Object object;
        URI uRI3;
        Args.notNull((Object)httpResponse, (String)"HTTP response");
        Header header = httpResponse.getFirstHeader("location");
        if (header == null) {
            throw new ProtocolException("Received redirect response " + httpResponse.getStatusLine() + " but no location header");
        }
        String string = header.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirect requested to location '" + string + "'"));
        }
        try {
            uRI3 = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: " + string, (Throwable)uRISyntaxException);
        }
        HttpParams httpParams = httpResponse.getParams();
        if (!uRI3.isAbsolute()) {
            if (httpParams.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uRI3 + "' not allowed");
            }
            object = (HttpHost)httpContext.getAttribute("http.target_host");
            Asserts.notNull((Object)object, (String)"Target host");
            uRI2 = (HttpRequest)httpContext.getAttribute("http.request");
            try {
                uRI = new URI(uRI2.getRequestLine().getUri());
                URI uRI4 = URIUtils.rewriteURI(uRI, (HttpHost)object, true);
                uRI3 = URIUtils.resolve(uRI4, uRI3);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
            }
        }
        if (httpParams.isParameterFalse("http.protocol.allow-circular-redirects")) {
            object = (RedirectLocations)httpContext.getAttribute(REDIRECT_LOCATIONS);
            if (object == null) {
                object = new RedirectLocations();
                httpContext.setAttribute(REDIRECT_LOCATIONS, object);
            }
            if (uRI3.getFragment() != null) {
                try {
                    uRI = new HttpHost(uRI3.getHost(), uRI3.getPort(), uRI3.getScheme());
                    uRI2 = URIUtils.rewriteURI(uRI3, (HttpHost)uRI, true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
                }
            } else {
                uRI2 = uRI3;
            }
            if (((RedirectLocations)object).contains(uRI2)) {
                throw new CircularRedirectException("Circular redirect to '" + uRI2 + "'");
            }
            ((RedirectLocations)object).add(uRI2);
        }
        return uRI3;
    }
}

