/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Immutable
public class URIUtils {
    @Deprecated
    public static URI createURI(String string, String string2, int n, String string3, String string4, String string5) throws URISyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append("://");
            }
            stringBuilder.append(string2);
            if (n > 0) {
                stringBuilder.append(':');
                stringBuilder.append(n);
            }
        }
        if (string3 == null || !string3.startsWith("/")) {
            stringBuilder.append('/');
        }
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        if (string4 != null) {
            stringBuilder.append('?');
            stringBuilder.append(string4);
        }
        if (string5 != null) {
            stringBuilder.append('#');
            stringBuilder.append(string5);
        }
        return new URI(stringBuilder.toString());
    }

    public static URI rewriteURI(URI uRI, HttpHost httpHost, boolean bl) throws URISyntaxException {
        Args.notNull((Object)uRI, (String)"URI");
        if (uRI.isOpaque()) {
            return uRI;
        }
        URIBuilder uRIBuilder = new URIBuilder(uRI);
        if (httpHost != null) {
            uRIBuilder.setScheme(httpHost.getSchemeName());
            uRIBuilder.setHost(httpHost.getHostName());
            uRIBuilder.setPort(httpHost.getPort());
        } else {
            uRIBuilder.setScheme(null);
            uRIBuilder.setHost(null);
            uRIBuilder.setPort(-1);
        }
        if (bl) {
            uRIBuilder.setFragment(null);
        }
        if (TextUtils.isEmpty((CharSequence)uRIBuilder.getPath())) {
            uRIBuilder.setPath("/");
        }
        return uRIBuilder.build();
    }

    public static URI rewriteURI(URI uRI, HttpHost httpHost) throws URISyntaxException {
        return URIUtils.rewriteURI(uRI, httpHost, false);
    }

    public static URI rewriteURI(URI uRI) throws URISyntaxException {
        Args.notNull((Object)uRI, (String)"URI");
        if (uRI.isOpaque()) {
            return uRI;
        }
        URIBuilder uRIBuilder = new URIBuilder(uRI);
        if (uRIBuilder.getUserInfo() != null) {
            uRIBuilder.setUserInfo(null);
        }
        if (TextUtils.isEmpty((CharSequence)uRIBuilder.getPath())) {
            uRIBuilder.setPath("/");
        }
        if (uRIBuilder.getHost() != null) {
            uRIBuilder.setHost(uRIBuilder.getHost().toLowerCase(Locale.ROOT));
        }
        uRIBuilder.setFragment(null);
        return uRIBuilder.build();
    }

    public static URI rewriteURIForRoute(URI uRI, RouteInfo routeInfo) throws URISyntaxException {
        if (uRI == null) {
            return null;
        }
        if (routeInfo.getProxyHost() != null && !routeInfo.isTunnelled()) {
            if (!uRI.isAbsolute()) {
                HttpHost httpHost = routeInfo.getTargetHost();
                return URIUtils.rewriteURI(uRI, httpHost, true);
            }
            return URIUtils.rewriteURI(uRI);
        }
        if (uRI.isAbsolute()) {
            return URIUtils.rewriteURI(uRI, null, true);
        }
        return URIUtils.rewriteURI(uRI);
    }

    public static URI resolve(URI uRI, String string) {
        return URIUtils.resolve(uRI, URI.create(string));
    }

    public static URI resolve(URI uRI, URI uRI2) {
        URI uRI3;
        Args.notNull((Object)uRI, (String)"Base URI");
        Args.notNull((Object)uRI2, (String)"Reference URI");
        String string = uRI2.toASCIIString();
        if (string.startsWith("?")) {
            String string2 = uRI.toASCIIString();
            int n = string2.indexOf(63);
            string2 = n > -1 ? string2.substring(0, n) : string2;
            return URI.create(string2 + string);
        }
        boolean bl = string.isEmpty();
        if (bl) {
            uRI3 = uRI.resolve(URI.create("#"));
            String string3 = uRI3.toASCIIString();
            uRI3 = URI.create(string3.substring(0, string3.indexOf(35)));
        } else {
            uRI3 = uRI.resolve(uRI2);
        }
        try {
            return URIUtils.normalizeSyntax(uRI3);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    static URI normalizeSyntax(URI uRI) throws URISyntaxException {
        if (uRI.isOpaque() || uRI.getAuthority() == null) {
            return uRI;
        }
        Args.check((boolean)uRI.isAbsolute(), (String)"Base URI must be absolute");
        URIBuilder uRIBuilder = new URIBuilder(uRI);
        String string = uRIBuilder.getPath();
        if (string != null && !string.equals("/")) {
            String[] stringArray = string.split("/");
            Stack<String> stack = new Stack<String>();
            for (String string2 : stringArray) {
                if (string2.isEmpty() || ".".equals(string2)) continue;
                if ("..".equals(string2)) {
                    if (stack.isEmpty()) continue;
                    stack.pop();
                    continue;
                }
                stack.push(string2);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stack) {
                stringBuilder.append('/').append(string3);
            }
            if (string.lastIndexOf(47) == string.length() - 1) {
                stringBuilder.append('/');
            }
            uRIBuilder.setPath(stringBuilder.toString());
        }
        if (uRIBuilder.getScheme() != null) {
            uRIBuilder.setScheme(uRIBuilder.getScheme().toLowerCase(Locale.ROOT));
        }
        if (uRIBuilder.getHost() != null) {
            uRIBuilder.setHost(uRIBuilder.getHost().toLowerCase(Locale.ROOT));
        }
        return uRIBuilder.build();
    }

    public static HttpHost extractHost(URI uRI) {
        if (uRI == null) {
            return null;
        }
        HttpHost httpHost = null;
        if (uRI.isAbsolute()) {
            int n = uRI.getPort();
            String string = uRI.getHost();
            if (string == null && (string = uRI.getAuthority()) != null) {
                int n2;
                int n3 = string.indexOf(64);
                if (n3 >= 0) {
                    string = string.length() > n3 + 1 ? string.substring(n3 + 1) : null;
                }
                if (string != null && (n2 = string.indexOf(58)) >= 0) {
                    int n4 = n2 + 1;
                    int n5 = 0;
                    for (int i = n4; i < string.length() && Character.isDigit(string.charAt(i)); ++i) {
                        ++n5;
                    }
                    if (n5 > 0) {
                        try {
                            n = Integer.parseInt(string.substring(n4, n4 + n5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    string = string.substring(0, n2);
                }
            }
            String string2 = uRI.getScheme();
            if (!TextUtils.isBlank((CharSequence)string)) {
                try {
                    httpHost = new HttpHost(string, n, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return httpHost;
    }

    public static URI resolve(URI uRI, HttpHost httpHost, List<URI> list) throws URISyntaxException {
        URIBuilder uRIBuilder;
        Args.notNull((Object)uRI, (String)"Request URI");
        if (list == null || list.isEmpty()) {
            uRIBuilder = new URIBuilder(uRI);
        } else {
            uRIBuilder = new URIBuilder(list.get(list.size() - 1));
            String string = uRIBuilder.getFragment();
            for (int i = list.size() - 1; string == null && i >= 0; --i) {
                string = list.get(i).getFragment();
            }
            uRIBuilder.setFragment(string);
        }
        if (uRIBuilder.getFragment() == null) {
            uRIBuilder.setFragment(uRI.getFragment());
        }
        if (httpHost != null && !uRIBuilder.isAbsolute()) {
            uRIBuilder.setScheme(httpHost.getSchemeName());
            uRIBuilder.setHost(httpHost.getHostName());
            uRIBuilder.setPort(httpHost.getPort());
        }
        return uRIBuilder.build();
    }

    private URIUtils() {
    }
}

