/*
 * Decompiled with CFR 0.152.
 */
package com.vcc.playerwrappersdk.controllers;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.layeredvideo.PlaybackControlLayer;
import com.vcc.playerwrappersdk.a.d;
import com.vcc.playerwrappersdk.a.f;
import com.vcc.playerwrappersdk.a.g;
import com.vcc.playerwrappersdk.b.c;
import com.vcc.playerwrappersdk.controllers.APITransaction;
import com.vcc.playerwrappersdk.controllers.OnViewNumberCallback;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PlayerController
implements Parcelable,
PlaybackControlLayer.FullscreenCallback,
PlaybackControlLayer.PlayCallback {
    public static final String TAG = "Player sdk: ";
    private static final Object a = new Object();
    public static final int STATE_IDLE = 1;
    public static final int STATE_PREPARING = 2;
    public static final int STATE_BUFFERING = 3;
    public static final int STATE_READY = 4;
    public static final int STATE_ENDED = 5;
    public static final int TIME_DEFAULT = 5000;
    private static PlayerController b;
    private com.vcc.playerwrappersdk.controllers.b c;
    private FrameLayout d;
    private WeakReference<OnPlayerCallback> e;
    private Video f;
    private String g;
    private boolean h;
    private int i = -1;
    private ProgressBar j;
    private boolean k = false;
    private b l;
    private boolean m;
    private boolean n;
    private long o = 0L;
    private boolean p = false;
    private int q;
    private TimerTask r;
    private Timer s;
    private Handler t = new Handler();
    private boolean u = false;
    private String v = "";
    private Handler w = new Handler(Looper.getMainLooper());
    public static final Parcelable.Creator<PlayerController> CREATOR;
    public static final String TIME_PROGRESS = "time_progress_skin";
    public static final String BUFFER_PROGRESS = "buffer_progress_skin";
    public static final String CURRENT_TIME = "current_time_skin";
    public static final String DURATION_VIDEO = "duration_video_skin";
    public static final String SHOW_CONTROL = "show_control_skin";
    public static final String LIVE_VIDEO = "live_video_skin";
    public static final String LOADING_VIDEO = "loading_video_skin";
    public static final String RELEASE_SKIN = "release_sdk_skin";

    protected PlayerController(Parcel parcel) {
        this.g = parcel.readString();
        this.h = parcel.readByte() != 0;
        this.i = parcel.readInt();
        this.k = parcel.readByte() != 0;
        this.m = parcel.readByte() != 0;
        this.n = parcel.readByte() != 0;
        this.o = parcel.readLong();
        this.p = parcel.readByte() != 0;
        this.q = parcel.readInt();
        this.u = parcel.readByte() != 0;
    }

    private Date a(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public boolean setContext(Context context) {
        try {
            com.vcc.playerwrappersdk.controllers.a.a().b(context);
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.a(exception.getMessage());
            return false;
        }
    }

    PlayerController(Context context, String string2, String string3, String string4, OnPlayerCallback onPlayerCallback) {
        com.vcc.playerwrappersdk.controllers.a.a(context);
        this.setOnPlayerCallback(onPlayerCallback);
        com.vcc.playerwrappersdk.controllers.a.a().a(string2);
        com.vcc.playerwrappersdk.controllers.a.a().b(string3);
        com.vcc.playerwrappersdk.controllers.a.a().c(string4);
        if (!this.b("android.permission.INTERNET")) {
            if (onPlayerCallback == null) {
                Log.e((String)TAG, (String)"OnPlayerCallback cannot null");
            } else {
                onPlayerCallback.onError("You not permission internet. Please check again!");
            }
        } else {
            Call<g> call;
            Object object;
            if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
                this.i = -1;
                if (onPlayerCallback == null) {
                    Log.e((String)TAG, (String)"AppKey, Secret Key must not empty! OnPlayerCallback cannot null");
                } else {
                    onPlayerCallback.onError("AppKey, Secret Key must not empty!");
                }
                return;
            }
            String string5 = "";
            Date date = new Date();
            final Date date2 = this.a(date, 1);
            try {
                object = new HashMap<String, String>();
                object.put("appkey", this.getAppkey());
                object.put("player", this.getPlayerId());
                object.put("platform", "android");
                object.put("package_name", this.getActivity().getPackageName());
                call = string2 + "-" + string3;
                string5 = Jwts.builder().setClaims(object).setHeaderParam("typ", (Object)"JWT").setIssuedAt(date).setExpiration(date2).signWith(SignatureAlgorithm.HS256, call.getBytes()).compact();
            }
            catch (Exception exception) {
                this.a();
                return;
            }
            object = "https://adminplayer.sohatv.vn/secure/verify/" + string2 + "/" + this.getPlayerId() + "/" + string5;
            call = APITransaction.b().verifySDK((String)object);
            Callback<g> callback = new Callback<g>(){

                public void onResponse(Call<g> call, Response<g> response) {
                    if (response == null || response.body() == null) {
                        PlayerController.this.a();
                        return;
                    }
                    g g2 = (g)response.body();
                    if (g2.a().equals("200")) {
                        String string2 = PlayerController.this.a(String.valueOf(date2.getTime() / 1000L));
                        String string3 = g2.b();
                        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3) && string2.equals(string3)) {
                            PlayerController.this.i = 1;
                            if (PlayerController.this.k) {
                                PlayerController.this.c();
                            }
                            return;
                        }
                        PlayerController.this.a();
                    }
                }

                public void onFailure(Call<g> call, Throwable throwable) {
                    PlayerController.this.a();
                }
            };
            call.enqueue((Callback)callback);
        }
    }

    private void a() {
        this.i = 0;
        if (this.getOnPlayerCallback() == null) {
            Log.e((String)TAG, (String)"You have not permission!");
        } else {
            this.getOnPlayerCallback().onError("You have not permission!");
        }
    }

    private String a(String string2) {
        String string3 = string2 + "-player-verified";
        String string4 = "MD5";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string3.getBytes());
            byte[] byArray = messageDigest.digest();
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                String string5 = Integer.toHexString(0xFF & by);
                while (string5.length() < 2) {
                    string5 = "0" + string5;
                }
                stringBuilder.append(string5);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PlayerController initialized(Context context, String string2, String string3, String string4, OnPlayerCallback onPlayerCallback) {
        com.vcc.playerwrappersdk.controllers.a.a().b(context);
        Object object = a;
        synchronized (object) {
            if (b == null) {
                b = new PlayerController(context, string2, string3, string4, onPlayerCallback);
            }
            return b;
        }
    }

    public static PlayerController shared() {
        return b;
    }

    public void setLogoPlayer(Drawable drawable2) {
        try {
            this.c.a(drawable2);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed: " + exception.getMessage()));
        }
    }

    public void setLogoPlayer(int n) {
        try {
            Drawable drawable2 = com.vcc.playerwrappersdk.controllers.a.a().e().getResources().getDrawable(n);
            this.c.a(drawable2);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed: " + exception.getMessage()));
        }
    }

    public boolean addActionButton(Drawable drawable2, String string2, View.OnClickListener onClickListener) {
        try {
            this.c.a(drawable2, string2, onClickListener);
            return true;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed: " + exception.getMessage()));
            return false;
        }
    }

    public boolean addActionButtonRes(int n, int n2, View.OnClickListener onClickListener) {
        try {
            this.c.a(com.vcc.playerwrappersdk.controllers.a.a().e().getResources().getDrawable(n), com.vcc.playerwrappersdk.controllers.a.a().e().getResources().getString(n2), onClickListener);
            return true;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Failed: " + exception.getMessage()));
            return false;
        }
    }

    public void releasePlayer() {
        if (this.c != null) {
            this.c.d();
            this.c = null;
        }
    }

    private com.vcc.playerwrappersdk.controllers.b b() {
        return this.c;
    }

    public boolean playVideo() {
        if (this.i == -1 || this.i == 0) {
            try {
                this.c.b();
            }
            catch (Exception exception) {
                com.vcc.playerwrappersdk.a.d(TAG, "Failed " + exception.getMessage());
            }
            Log.e((String)TAG, (String)"You have not permission!");
            return false;
        }
        try {
            this.c.c();
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.d(TAG, "Error: " + exception.getMessage());
            return false;
        }
    }

    public boolean pauseVideo() {
        if (this.i == -1 || this.i == 0) {
            Log.e((String)TAG, (String)"You have not permission!");
            return false;
        }
        try {
            this.c.b();
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.d(TAG, "Error: " + exception.getMessage());
            return false;
        }
    }

    public boolean resumeVideo() {
        if (this.i == -1 || this.i == 0) {
            try {
                this.c.b();
            }
            catch (Exception exception) {
                com.vcc.playerwrappersdk.a.d(TAG, "Failed " + exception.getMessage());
            }
            Log.e((String)TAG, (String)"You have not permission!");
            return false;
        }
        try {
            this.c.c();
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.d(TAG, "Error: " + exception.getMessage());
            return false;
        }
    }

    public boolean stopVideo() {
        try {
            this.c.b();
            this.c.d();
            return true;
        }
        catch (Exception exception) {
            com.vcc.playerwrappersdk.a.d(TAG, "Error: " + exception.getMessage());
            return false;
        }
    }

    public int getCurrentPosition() {
        if (this.b() != null) {
            return this.b().g();
        }
        return -1;
    }

    public int getLengthVideo() {
        if (this.b() != null) {
            return this.b().h();
        }
        return -1;
    }

    public void seekTo(int n) {
        if (this.b() != null) {
            this.b().a(n);
        }
    }

    public boolean isPlaying() {
        return this.b() != null && this.b().j();
    }

    public void getTimeCurrentLive(final @NonNull OnCurrentTimeLiveCallback onCurrentTimeLiveCallback) {
        if (this.i == -1 || this.i == 0) {
            if (this.c != null) {
                this.c.b();
            }
            onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
            Log.e((String)TAG, (String)"You have not permission!");
            return;
        }
        if (this.f == null || TextUtils.isEmpty((CharSequence)this.f.getUrl())) {
            onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
            Log.e((String)TAG, (String)"Content url is invalid. Check again");
            return;
        }
        if (this.f.getVideoType() != Video.VideoType.HLS) {
            onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
            Log.e((String)TAG, (String)"Video must live.");
            return;
        }
        String string2 = this.v;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
            Log.e((String)TAG, (String)"Url invalid to get time live.");
            return;
        }
        Call<f> call = APITransaction.a().getTimeLive(string2);
        Callback<f> callback = new Callback<f>(){

            public void onResponse(Call<f> call, Response<f> response) {
                if (response == null || response.body() == null || ((f)response.body()).a() == null) {
                    onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
                    Log.e((String)PlayerController.TAG, (String)"Cannot get current time error response empty");
                    return;
                }
                Log.e((String)PlayerController.TAG, (String)"Cannot get current time error response empty");
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                try {
                    l = Long.parseLong(((f)response.body()).a().a());
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                try {
                    l2 = Long.parseLong(((f)response.body()).a().b());
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                try {
                    l3 = Long.parseLong(((f)response.body()).a().c());
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                onCurrentTimeLiveCallback.onCurrentTime(true, l, l2, l3);
            }

            public void onFailure(Call<f> call, Throwable throwable) {
                onCurrentTimeLiveCallback.onCurrentTime(false, 0L, 0L, 0L);
                Log.e((String)PlayerController.TAG, (String)"Cannot get current time error require api");
            }
        };
        call.enqueue((Callback)callback);
    }

    public boolean isMuted() {
        return this.c != null && this.c.k();
    }

    public boolean setMute(boolean bl) {
        return this.c != null && this.c.d(bl);
    }

    @Override
    public void onGoToFullscreen() {
        OnPlayerCallback onPlayerCallback = this.getOnPlayerCallback();
        if (onPlayerCallback == null) {
            Log.e((String)TAG, (String)"OnPlayerCallback cannot null");
            return;
        }
        onPlayerCallback.onFullScreen();
    }

    @Override
    public void onReturnFromFullscreen() {
        OnPlayerCallback onPlayerCallback = this.getOnPlayerCallback();
        if (onPlayerCallback == null) {
            Log.e((String)TAG, (String)"OnPlayerCallback cannot null");
            return;
        }
        onPlayerCallback.onNormalScreen();
    }

    @Override
    public void onPlay() {
        if (this.i == -1 || this.i == 0) {
            this.c.b();
            Log.e((String)TAG, (String)"You have not permission!");
            return;
        }
        OnPlayerCallback onPlayerCallback = this.getOnPlayerCallback();
        if (onPlayerCallback == null) {
            Log.e((String)TAG, (String)"OnPlayerCallback cannot null");
            return;
        }
        onPlayerCallback.onPlay();
    }

    private void c() {
        if (this.l != null && this.l.getStatus() == AsyncTask.Status.RUNNING) {
            this.l.cancel(true);
            this.l = null;
        }
        if (this.f == null) {
            if (this.getOnPlayerCallback() != null) {
                this.getOnPlayerCallback().onError("Video content url is not null!");
            }
            return;
        }
        this.l = new b(this.f.getUrl());
        this.l.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[]{null});
    }

    private void d() {
        if (this.j != null) {
            this.j.setVisibility(8);
        }
        if (this.c != null) {
            this.c.d();
        }
        this.d.removeAllViews();
        this.c = new com.vcc.playerwrappersdk.controllers.b(com.vcc.playerwrappersdk.controllers.a.a().e(), this.d, this.f, this.g, this.n);
        OnPlayerCallback onPlayerCallback = this.getOnPlayerCallback();
        if (onPlayerCallback != null) {
            this.c.a(onPlayerCallback);
        }
        this.c.b(this.m);
        this.c.a(this.h);
        this.c.a(this);
        this.c.a(this);
    }

    public Video getVideoContentUrl() {
        return this.f;
    }

    public PlayerController setVideoContentUrl(Video video) {
        this.v = video.getUrl();
        this.f = new Video(video.getUrl(), video.getVideoType(), video.getContentId());
        return this;
    }

    public String getVideoTitle() {
        return this.g;
    }

    public PlayerController setVideoTitle(String string2) {
        this.g = string2;
        return this;
    }

    public boolean isAutoPlay() {
        return this.h;
    }

    public PlayerController setAutoPlay(boolean bl) {
        this.h = bl;
        return this;
    }

    public void toggleFullscreen() {
        if (this.b() != null) {
            this.b().i();
        }
    }

    public void subcribleViewerNumber(int n) {
        if (this.f == null) {
            throw new NullPointerException("SubcribleViewerNumber: Video content is null or empty must setup before.");
        }
        if (n < 5000) {
            n = 5000;
        }
        this.setTimeInterval(n);
        if (this.f.getVideoType() == Video.VideoType.HLS) {
            this.e();
        } else if (this.f.getVideoType() == Video.VideoType.OTHER) {
            if (this.f.getUrl().endsWith(".m3u8")) {
                this.e();
            }
        } else if (this.getOnPlayerCallback() != null) {
            this.getOnPlayerCallback().onViewerNumber(this.f.getUrl(), false, "0", "Your video is not counter number viewer");
        }
    }

    public void unSubcribleViewerNumber() {
        this.q = 0;
        this.o = System.currentTimeMillis();
        this.p = true;
        if (this.s != null) {
            this.s.purge();
            this.s.cancel();
        }
        this.s = null;
        if (this.r != null) {
            this.r.cancel();
        }
        this.r = null;
        this.p = false;
        this.o = 0L;
        this.u = false;
    }

    private void e() {
        if (this.u) {
            return;
        }
        if (this.s == null) {
            this.s = new Timer();
        }
        if (this.r == null) {
            this.r = new TimerTask(){

                @Override
                public void run() {
                    PlayerController.this.t.post(new Runnable(){

                        @Override
                        public void run() {
                            PlayerController.this.a(PlayerController.this.q);
                        }
                    });
                }
            };
        }
        this.s.schedule(this.r, 0L, (long)this.q);
        this.u = true;
    }

    private void a(int n) {
        if (this.p) {
            return;
        }
        if (this.o == 0L || System.currentTimeMillis() - this.o > (long)n) {
            this.p = true;
            this.o = System.currentTimeMillis();
            com.vcc.playerwrappersdk.a.a("Start: " + this.o);
            this.a("", false);
        }
    }

    private void a(String string2, boolean bl) {
        if (this.p) {
            return;
        }
        if (this.o == 0L || System.currentTimeMillis() - this.o > (long)this.q) {
            this.p = true;
            this.o = System.currentTimeMillis();
            com.vcc.playerwrappersdk.a.a("Start: " + this.o);
            this.getViewerNumber(this.v, false, new OnViewNumberCallback(){

                @Override
                public void callback(String string2, boolean bl, String string3, String string4) {
                    com.vcc.playerwrappersdk.a.a("End: " + System.currentTimeMillis());
                    PlayerController.this.p = false;
                    com.vcc.playerwrappersdk.a.a("Request viewer: " + string3 + "startTime: " + PlayerController.this.o);
                    if (PlayerController.this.getOnPlayerCallback() != null) {
                        PlayerController.this.getOnPlayerCallback().onViewerNumber(string2, bl, string3, string4);
                    }
                }
            });
        }
    }

    public void getViewerNumber(final String string2, final boolean bl, final @Nullable OnViewNumberCallback onViewNumberCallback) {
        String string3 = "https://live-viewing.sohatv.vn/live-viewing?" + (bl ? "v=" : "url=") + string2;
        com.vcc.playerwrappersdk.a.a("baseUrl: " + string3);
        Call<com.vcc.playerwrappersdk.a.a> call = APITransaction.b().getCCU(string3);
        com.vcc.playerwrappersdk.a.a("Run 1");
        Callback<com.vcc.playerwrappersdk.a.a> callback = new Callback<com.vcc.playerwrappersdk.a.a>(){

            public void onResponse(Call<com.vcc.playerwrappersdk.a.a> call, Response<com.vcc.playerwrappersdk.a.a> response) {
                if (response == null || response.body() == null) {
                    com.vcc.playerwrappersdk.a.a("Run 1'");
                    if (onViewNumberCallback != null) {
                        onViewNumberCallback.callback(string2, bl, "0", "Cannot get viewer number!");
                    } else if (PlayerController.this.getOnPlayerCallback() != null) {
                        PlayerController.this.getOnPlayerCallback().onViewerNumber(string2, bl, "0", "Cannot get viewer number!");
                    }
                    return;
                }
                if (onViewNumberCallback != null) {
                    onViewNumberCallback.callback(string2, bl, ((com.vcc.playerwrappersdk.a.a)response.body()).a(), "Request number viewer success!");
                } else if (PlayerController.this.getOnPlayerCallback() != null) {
                    PlayerController.this.getOnPlayerCallback().onViewerNumber(string2, bl, ((com.vcc.playerwrappersdk.a.a)response.body()).a(), "Request number viewer success!");
                }
            }

            public void onFailure(Call<com.vcc.playerwrappersdk.a.a> call, Throwable throwable) {
                if (onViewNumberCallback != null) {
                    onViewNumberCallback.callback(string2, bl, "0", "Exception:" + throwable.getMessage());
                } else if (PlayerController.this.getOnPlayerCallback() != null) {
                    PlayerController.this.getOnPlayerCallback().onViewerNumber(string2, bl, "0", "Exception:" + throwable.getMessage());
                }
            }
        };
        call.enqueue((Callback)callback);
    }

    public OnPlayerCallback getOnPlayerCallback() {
        return this.e == null ? null : (OnPlayerCallback)this.e.get();
    }

    public PlayerController setOnPlayerCallback(OnPlayerCallback onPlayerCallback) {
        this.e = new WeakReference<OnPlayerCallback>(onPlayerCallback);
        if (this.c != null) {
            this.c.a(onPlayerCallback);
        }
        return this;
    }

    public FrameLayout getVideoPlayerContainer() {
        return this.d;
    }

    public PlayerController setVideoPlayerContainer(FrameLayout frameLayout) {
        this.d = frameLayout;
        if (this.j == null) {
            this.j = new ProgressBar(com.vcc.playerwrappersdk.controllers.a.a().e());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(100, 100);
            layoutParams.gravity = 17;
            this.d.addView((View)this.j, (ViewGroup.LayoutParams)layoutParams);
            this.j.setVisibility(0);
        } else {
            this.j.setVisibility(0);
        }
        return this;
    }

    public void showLoading() {
        if (this.j != null) {
            this.j.bringToFront();
            if (this.d != null) {
                this.d.bringChildToFront((View)this.j);
            }
            this.j.setVisibility(0);
        }
    }

    public void hideLoading() {
        if (this.j != null) {
            this.j.bringToFront();
            this.d.bringChildToFront((View)this.j);
            this.j.setVisibility(8);
        }
    }

    public PlayerController build() {
        this.k = true;
        if (this.i == -1 || this.i == 0) {
            Log.e((String)TAG, (String)"Waiting!");
            return this;
        }
        this.c();
        return this;
    }

    private boolean b(String string2) {
        return ContextCompat.checkSelfPermission((Context)com.vcc.playerwrappersdk.controllers.a.a().e(), (String)string2) == 0;
    }

    public PlayerController hideController(boolean bl) {
        this.m = bl;
        return this;
    }

    public PlayerController setFixedContent(boolean bl) {
        this.n = bl;
        if (this.c != null) {
            this.c.c(bl);
        }
        return this;
    }

    public Context getActivity() {
        return com.vcc.playerwrappersdk.controllers.a.a().e();
    }

    public void setAppkey(String string2) {
        com.vcc.playerwrappersdk.controllers.a.a().a(string2);
    }

    public String getAppkey() {
        return com.vcc.playerwrappersdk.controllers.a.a().f();
    }

    public void setSecretKey(String string2) {
        com.vcc.playerwrappersdk.controllers.a.a().b(string2);
    }

    public String getSecretKey() {
        return com.vcc.playerwrappersdk.controllers.a.a().g();
    }

    public void setTimeInterval(int n) {
        this.q = n;
    }

    public int getTimeInterval() {
        return this.q;
    }

    public String getPlayerId() {
        return com.vcc.playerwrappersdk.controllers.a.a().h();
    }

    public void setPlayerId(String string2) {
        com.vcc.playerwrappersdk.controllers.a.a().c(string2);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.g);
        parcel.writeByte((byte)(this.h ? 1 : 0));
        parcel.writeInt(this.i);
        parcel.writeByte((byte)(this.k ? 1 : 0));
        parcel.writeByte((byte)(this.m ? 1 : 0));
        parcel.writeByte((byte)(this.n ? 1 : 0));
        parcel.writeLong(this.o);
        parcel.writeByte((byte)(this.p ? 1 : 0));
        parcel.writeInt(this.q);
        parcel.writeByte((byte)(this.u ? 1 : 0));
    }

    private void c(String string2) {
        new a().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{string2});
    }

    @Subscribe(threadMode=ThreadMode.BACKGROUND)
    public void onEvent(JSONObject jSONObject) {
        final c c2 = new c();
        final String string2 = c2.a("event", jSONObject);
        final Object object = c2.b("value", jSONObject);
        if (object == null) {
            return;
        }
        if (this.w == null) {
            this.w = new Handler(Looper.getMainLooper());
        }
        this.w.post(new Runnable(){

            @Override
            public void run() {
                switch (string2) {
                    case "VIEW_NUMBER": {
                        if (!(object instanceof JSONObject)) break;
                        String string22 = c2.a("id", (JSONObject)object);
                        String string3 = c2.a("isVideoId", (JSONObject)object);
                        String string4 = c2.a("number", (JSONObject)object);
                        String string5 = c2.a("message", (JSONObject)object);
                        if (PlayerController.this.getOnPlayerCallback() == null) break;
                        PlayerController.this.getOnPlayerCallback().onViewerNumber(string22, string3.equals("true"), string4, string5);
                    }
                }
            }
        });
    }

    static {
        CREATOR = new Parcelable.Creator<PlayerController>(){

            public PlayerController a(Parcel parcel) {
                return new PlayerController(parcel);
            }

            public PlayerController[] a(int n) {
                return new PlayerController[n];
            }

            public /* synthetic */ Object[] newArray(int n) {
                return this.a(n);
            }

            public /* synthetic */ Object createFromParcel(Parcel parcel) {
                return this.a(parcel);
            }
        };
    }

    private class a
    extends AsyncTask<String, Void, String> {
        String a = this.a();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String a(String ... stringArray) {
            URL uRL;
            String string2 = stringArray[0];
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                return string2 != null ? string2 : "";
            }
            com.vcc.playerwrappersdk.a.a(PlayerController.TAG, "Checking URL redirect:" + string2);
            int n = -1;
            HttpURLConnection httpURLConnection = null;
            String string3 = uRL.toString();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string3);
            try {
                do {
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestProperty("User-Agent", this.a);
                    httpURLConnection.setInstanceFollowRedirects(false);
                    n = httpURLConnection.getResponseCode();
                    if (n == 200) {
                        httpURLConnection.disconnect();
                        break;
                    }
                    string3 = httpURLConnection.getHeaderField("location");
                    httpURLConnection.disconnect();
                    if (!hashSet.add(string3)) {
                        Log.d((String)PlayerController.TAG, (String)"URL redirect cycle detected");
                        String string4 = "";
                        return string4;
                    }
                    uRL = new URL(string3);
                } while (n == 302 || n == 301 || n == 307 || n == 303);
            }
            catch (IOException iOException) {
                String string5 = string3 != null ? string3 : "";
                return string5;
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            return string3;
        }

        protected void a(String string2) {
            com.vcc.playerwrappersdk.a.a(PlayerController.TAG, "Url response: " + string2);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                PlayerController.this.d();
                return;
            }
            this.b(string2);
        }

        private void b(String string2) {
            if (string2.equals("")) {
                Toast.makeText((Context)com.vcc.playerwrappersdk.controllers.a.a().e(), (CharSequence)"Cannot play this video!", (int)0).show();
                if (PlayerController.this.getOnPlayerCallback() != null) {
                    PlayerController.this.getOnPlayerCallback().onError("Url video is empty!");
                }
                return;
            }
            PlayerController.this.f.setUrl(string2);
            PlayerController.this.d();
        }

        public String a() {
            String string2 = System.getProperty("http.agent");
            return string2;
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((String)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((String[])objectArray);
        }
    }

    private class b
    extends AsyncTask<Void, Void, Void> {
        private final String b;
        private int c = 1;
        private Activity d = null;

        b(String string2) {
            this.b = string2;
            this.d = com.vcc.playerwrappersdk.controllers.a.a().e() instanceof Activity ? (Activity)com.vcc.playerwrappersdk.controllers.a.a().e() : null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Void a(Void ... voidArray) {
            this.a();
            return null;
        }

        private void a() {
            String string2 = Settings.Secure.getString((ContentResolver)com.vcc.playerwrappersdk.controllers.a.a().e().getContentResolver(), (String)"android_id");
            if (this.b.equals("")) {
                return;
            }
            int n = this.b.lastIndexOf("/");
            String string3 = this.b.substring(0, n + 1);
            if (n + 1 == this.b.length() || TextUtils.isEmpty((CharSequence)string3) || this.b.equals(string3)) {
                PlayerController.this.c(this.b);
                return;
            }
            this.a(string3, string2);
        }

        private void a(String string2, String string3) {
            Call<d> call = APITransaction.b().getLinkPlayVideo(this.b, string3);
            call.enqueue((Callback)new Callback<d>(){

                public void onResponse(Call<d> call, Response<d> response) {
                    if (response == null || response.body() == null || ((d)response.body()).a() == null) {
                        if (PlayerController.this.j != null) {
                            PlayerController.this.j.setVisibility(8);
                        }
                        com.vcc.playerwrappersdk.a.d("PLAYER.VCC", "===============parse data error!!!===========\n");
                        PlayerController.this.c(b.this.b);
                        return;
                    }
                    d d2 = (d)response.body();
                    String string2 = d2.a().a();
                    if (Integer.parseInt(string2) == b.this.c) {
                        String string3 = d2.b().b();
                        String string4 = d2.b().a();
                        b.this.b(string4, string3);
                    } else {
                        if (PlayerController.this.j != null) {
                            PlayerController.this.j.setVisibility(8);
                        }
                        PlayerController.this.c(b.this.b);
                    }
                }

                public void onFailure(Call<d> call, Throwable throwable) {
                    com.vcc.playerwrappersdk.a.d("PLAYER.VCC", "" + throwable.getMessage());
                    if (PlayerController.this.j != null) {
                        PlayerController.this.j.setVisibility(8);
                    }
                    PlayerController.this.c(b.this.b);
                }
            });
        }

        private void b(String string2, String string3) {
            if (string2.equals("")) {
                Toast.makeText((Context)com.vcc.playerwrappersdk.controllers.a.a().e(), (CharSequence)"Cannot play this video!", (int)0).show();
                if (PlayerController.this.getOnPlayerCallback() != null) {
                    PlayerController.this.getOnPlayerCallback().onError("Url video is empty!");
                }
                return;
            }
            this.a(string3);
            PlayerController.this.f.setUrl(string2);
            PlayerController.this.d();
        }

        private void a(String string2) {
            if (this.d == null) {
                return;
            }
            switch (string2) {
                case "2": {
                    this.d.setRequestedOrientation(7);
                    break;
                }
                case "1": {
                    this.d.setRequestedOrientation(6);
                    break;
                }
                default: {
                    this.d.setRequestedOrientation(4);
                }
            }
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }

    public static interface OnCurrentTimeLiveCallback {
        public void onCurrentTime(boolean var1, long var2, long var4, long var6);
    }

    public static interface OnPlayerCallback {
        public void onFullScreen();

        public void onNormalScreen();

        public void onPlay();

        public void onError(String var1);

        public void playState(int var1);

        public void videSizeChange(int var1, int var2, int var3, float var4);

        public void onPlayPressed();

        public void onPausePressed();

        public void onUpdateProgress(int var1, int var2);

        public void onBuffering(int var1);

        public void onShowHideControl(boolean var1);

        public void onViewerNumber(String var1, boolean var2, String var3, String var4);
    }
}

