/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.layeredvideo;

import android.content.Context;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.TextureView;
import android.widget.FrameLayout;

public class VideoTextureView
extends TextureView {
    private static final float MAX_ASPECT_RATIO_DEFORMATION_PERCENT = 0.01f;
    private float videoAspectRatio;
    private FrameLayout layoutContainer;
    private boolean fixedContent;
    private float mVideoWidth;
    private float mVideoHeight;

    public VideoTextureView(Context context) {
        super(context);
    }

    public VideoTextureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (this.isFixedContent()) {
            if (this.mVideoWidth == 0.0f && this.mVideoHeight == 0.0f) {
                return;
            }
            if (this.videoAspectRatio == 0.0f) {
                return;
            }
            float f2 = this.layoutContainer.getWidth();
            float f3 = this.layoutContainer.getHeight();
            this.updateTextureViewSize(f2, f3);
            return;
        }
        int n3 = this.getMeasuredWidth();
        int n4 = this.getMeasuredHeight();
        if (this.videoAspectRatio != 0.0f) {
            float f4 = (float)n3 / (float)n4;
            float f5 = this.videoAspectRatio / f4 - 1.0f;
            if (f5 > 0.01f) {
                n4 = (int)((float)n3 / this.videoAspectRatio);
            } else if (f5 < -0.01f) {
                n3 = (int)((float)n4 * this.videoAspectRatio);
            }
        }
        this.setMeasuredDimension(n3, n4);
    }

    private void updateTextureViewSize(float f2, float f3) {
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (this.mVideoWidth > f2 && this.mVideoHeight > f3) {
            f4 = this.mVideoWidth / f2;
            f5 = this.mVideoHeight / f3;
        } else if (this.mVideoWidth < f2 && this.mVideoHeight < f3) {
            f5 = f2 / this.mVideoWidth;
            f4 = f3 / this.mVideoHeight;
        } else if (f2 > this.mVideoWidth) {
            f5 = f2 / this.mVideoWidth / (f3 / this.mVideoHeight);
        } else if (f3 > this.mVideoHeight) {
            f4 = f3 / this.mVideoHeight / (f2 / this.mVideoWidth);
        }
        float f6 = f2 / 2.0f;
        float f7 = f3 / 2.0f;
        Matrix matrix = new Matrix();
        matrix.setScale(f4, f5, f6, f7);
        this.setTransform(matrix);
    }

    public void setVideoWidthHeightRatio(float f2) {
        if (this.videoAspectRatio != f2) {
            this.videoAspectRatio = f2;
            this.requestLayout();
        }
    }

    public void setLayoutContainer(FrameLayout frameLayout) {
        this.layoutContainer = frameLayout;
    }

    public void setFixedContent(boolean bl) {
        this.fixedContent = bl;
    }

    public boolean isFixedContent() {
        return this.fixedContent;
    }

    public void setVideoSize(float f2, float f3) {
        if (this.mVideoWidth == 0.0f && this.mVideoHeight == 0.0f) {
            this.mVideoWidth = f2;
            this.mVideoHeight = f3;
        }
    }
}

