/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.layeredvideo;

import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.google.android.libraries.mediaframework.exoplayerextensions.ObservablePlayerControl;
import com.google.android.libraries.mediaframework.exoplayerextensions.RendererBuilderFactory;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.layeredvideo.Layer;
import java.util.List;

public class LayerManager {
    private Context mContext;
    private FrameLayout container;
    private ObservablePlayerControl control;
    private ExoplayerWrapper exoplayerWrapper;

    public LayerManager(Context context, FrameLayout frameLayout, Video video, List<Layer> list, boolean bl) {
        this.mContext = context;
        this.container = frameLayout;
        frameLayout.setBackgroundColor(-16777216);
        ExoplayerWrapper.RendererBuilder rendererBuilder = RendererBuilderFactory.createRendererBuilder(context, video, bl);
        this.exoplayerWrapper = new ExoplayerWrapper(rendererBuilder);
        this.exoplayerWrapper.prepare();
        this.control = this.exoplayerWrapper.getPlayerControl();
        frameLayout.removeAllViews();
        for (Layer layer : list) {
            frameLayout.addView((View)layer.createView(this));
            layer.onLayerDisplayed(this);
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public FrameLayout getContainer() {
        return this.container;
    }

    public ObservablePlayerControl getControl() {
        return this.control;
    }

    public ExoplayerWrapper getExoplayerWrapper() {
        return this.exoplayerWrapper;
    }

    public void release() {
        this.container.removeAllViews();
        if (this.exoplayerWrapper != null) {
            this.exoplayerWrapper.release();
            this.exoplayerWrapper = null;
        }
    }
}

