/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.mediaframework.exoplayerextensions;

import android.content.Context;
import android.net.Uri;
import com.google.android.libraries.mediaframework.exoplayerextensions.DashRendererBuilder;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerUtil;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExtractorRendererBuilder;
import com.google.android.libraries.mediaframework.exoplayerextensions.HlsRendererBuilder;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.exoplayerextensions.WidevineTestMediaDrmCallback;

public class RendererBuilderFactory {
    public static ExoplayerWrapper.RendererBuilder createRendererBuilder(Context context, Video video, boolean bl) {
        switch (video.getVideoType()) {
            case HLS: {
                return new HlsRendererBuilder(context, ExoplayerUtil.getUserAgent(context), video.getUrl(), bl);
            }
            case DASH: {
                return new DashRendererBuilder(context, ExoplayerUtil.getUserAgent(context), video.getUrl(), new WidevineTestMediaDrmCallback(video.getContentId()), bl);
            }
            case MP4: {
                return new ExtractorRendererBuilder(context, ExoplayerUtil.getUserAgent(context), Uri.parse((String)video.getUrl()), bl);
            }
            case OTHER: {
                return new ExtractorRendererBuilder(context, ExoplayerUtil.getUserAgent(context), Uri.parse((String)video.getUrl()), bl);
            }
        }
        return null;
    }
}

