/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

public final class MpegAudioHeader {
    public static final int MAX_FRAME_SIZE_BYTES = 4096;
    private static final String[] MIME_TYPE_BY_LAYER = new String[]{"audio/mpeg-L1", "audio/mpeg-L2", "audio/mpeg"};
    private static final int[] SAMPLING_RATE_V1 = new int[]{44100, 48000, 32000};
    private static final int[] BITRATE_V1_L1 = new int[]{32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448};
    private static final int[] BITRATE_V2_L1 = new int[]{32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256};
    private static final int[] BITRATE_V1_L2 = new int[]{32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384};
    private static final int[] BITRATE_V1_L3 = new int[]{32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
    private static final int[] BITRATE_V2 = new int[]{8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160};
    public int version;
    public String mimeType;
    public int frameSize;
    public int sampleRate;
    public int channels;
    public int bitrate;
    public int samplesPerFrame;

    public static int getFrameSize(int n) {
        if ((n & 0xFFE00000) != -2097152) {
            return -1;
        }
        int n2 = n >>> 19 & 3;
        if (n2 == 1) {
            return -1;
        }
        int n3 = n >>> 17 & 3;
        if (n3 == 0) {
            return -1;
        }
        int n4 = n >>> 12 & 0xF;
        if (n4 == 0 || n4 == 15) {
            return -1;
        }
        int n5 = n >>> 10 & 3;
        if (n5 == 3) {
            return -1;
        }
        int n6 = SAMPLING_RATE_V1[n5];
        if (n2 == 2) {
            n6 /= 2;
        } else if (n2 == 0) {
            n6 /= 4;
        }
        int n7 = n >>> 9 & 1;
        if (n3 == 3) {
            int n8 = n2 == 3 ? BITRATE_V1_L1[n4 - 1] : BITRATE_V2_L1[n4 - 1];
            return (12000 * n8 / n6 + n7) * 4;
        }
        int n9 = n2 == 3 ? (n3 == 2 ? BITRATE_V1_L2[n4 - 1] : BITRATE_V1_L3[n4 - 1]) : BITRATE_V2[n4 - 1];
        if (n2 == 3) {
            return 144000 * n9 / n6 + n7;
        }
        return (n3 == 1 ? 72000 : 144000) * n9 / n6 + n7;
    }

    public static boolean populateHeader(int n, MpegAudioHeader mpegAudioHeader) {
        int n2;
        int n3;
        int n4;
        if ((n & 0xFFE00000) != -2097152) {
            return false;
        }
        int n5 = n >>> 19 & 3;
        if (n5 == 1) {
            return false;
        }
        int n6 = n >>> 17 & 3;
        if (n6 == 0) {
            return false;
        }
        int n7 = n >>> 12 & 0xF;
        if (n7 == 0 || n7 == 15) {
            return false;
        }
        int n8 = n >>> 10 & 3;
        if (n8 == 3) {
            return false;
        }
        int n9 = SAMPLING_RATE_V1[n8];
        if (n5 == 2) {
            n9 /= 2;
        } else if (n5 == 0) {
            n9 /= 4;
        }
        int n10 = n >>> 9 & 1;
        if (n6 == 3) {
            n4 = n5 == 3 ? BITRATE_V1_L1[n7 - 1] : BITRATE_V2_L1[n7 - 1];
            n3 = (12000 * n4 / n9 + n10) * 4;
            n2 = 384;
        } else if (n5 == 3) {
            n4 = n6 == 2 ? BITRATE_V1_L2[n7 - 1] : BITRATE_V1_L3[n7 - 1];
            n2 = 1152;
            n3 = 144000 * n4 / n9 + n10;
        } else {
            n4 = BITRATE_V2[n7 - 1];
            n2 = n6 == 1 ? 576 : 1152;
            n3 = (n6 == 1 ? 72000 : 144000) * n4 / n9 + n10;
        }
        String string = MIME_TYPE_BY_LAYER[3 - n6];
        int n11 = (n >> 6 & 3) == 3 ? 1 : 2;
        mpegAudioHeader.setValues(n5, string, n3, n9, n11, n4 * 1000, n2);
        return true;
    }

    private void setValues(int n, String string, int n2, int n3, int n4, int n5, int n6) {
        this.version = n;
        this.mimeType = string;
        this.frameSize = n2;
        this.sampleRate = n3;
        this.channels = n4;
        this.bitrate = n5;
        this.samplesPerFrame = n6;
    }
}

