/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.TraceUtil;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public final class Loader {
    private static final int MSG_END_OF_SOURCE = 0;
    private static final int MSG_IO_EXCEPTION = 1;
    private static final int MSG_FATAL_ERROR = 2;
    private final ExecutorService downloadExecutorService;
    private LoadTask currentTask;
    private boolean loading;

    public Loader(String string) {
        this.downloadExecutorService = Util.newSingleThreadExecutor(string);
    }

    public void startLoading(Loadable loadable, Callback callback) {
        Looper looper = Looper.myLooper();
        Assertions.checkState(looper != null);
        this.startLoading(looper, loadable, callback);
    }

    public void startLoading(Looper looper, Loadable loadable, Callback callback) {
        Assertions.checkState(!this.loading);
        this.loading = true;
        this.currentTask = new LoadTask(looper, loadable, callback);
        this.downloadExecutorService.submit(this.currentTask);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void cancelLoading() {
        Assertions.checkState(this.loading);
        this.currentTask.quit();
    }

    public void release() {
        if (this.loading) {
            this.cancelLoading();
        }
        this.downloadExecutorService.shutdown();
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class LoadTask
    extends Handler
    implements Runnable {
        private static final String TAG = "LoadTask";
        private final Loadable loadable;
        private final Callback callback;
        private volatile Thread executorThread;

        public LoadTask(Looper looper, Loadable loadable, Callback callback) {
            super(looper);
            this.loadable = loadable;
            this.callback = callback;
        }

        public void quit() {
            this.loadable.cancelLoad();
            if (this.executorThread != null) {
                this.executorThread.interrupt();
            }
        }

        @Override
        public void run() {
            try {
                this.executorThread = Thread.currentThread();
                if (!this.loadable.isLoadCanceled()) {
                    TraceUtil.beginSection(this.loadable.getClass().getSimpleName() + ".load()");
                    this.loadable.load();
                    TraceUtil.endSection();
                }
                this.sendEmptyMessage(0);
            }
            catch (IOException iOException) {
                this.obtainMessage(1, iOException).sendToTarget();
            }
            catch (InterruptedException interruptedException) {
                Assertions.checkState(this.loadable.isLoadCanceled());
                this.sendEmptyMessage(0);
            }
            catch (Exception exception) {
                a.b(TAG, "Unexpected exception loading stream", exception);
                this.obtainMessage(1, new UnexpectedLoaderException(exception)).sendToTarget();
            }
            catch (Error error) {
                a.a(TAG, "Unexpected error loading stream", error);
                this.obtainMessage(2, error).sendToTarget();
                throw error;
            }
        }

        public void handleMessage(Message message) {
            if (message.what == 2) {
                throw (Error)message.obj;
            }
            this.onFinished();
            if (this.loadable.isLoadCanceled()) {
                this.callback.onLoadCanceled(this.loadable);
                return;
            }
            switch (message.what) {
                case 0: {
                    this.callback.onLoadCompleted(this.loadable);
                    break;
                }
                case 1: {
                    this.callback.onLoadError(this.loadable, (IOException)message.obj);
                }
            }
        }

        private void onFinished() {
            Loader.this.loading = false;
            Loader.this.currentTask = null;
        }
    }

    public static interface Callback {
        public void onLoadCanceled(Loadable var1);

        public void onLoadCompleted(Loadable var1);

        public void onLoadError(Loadable var1, IOException var2);
    }

    public static interface Loadable {
        public void cancelLoad();

        public boolean isLoadCanceled();

        public void load() throws IOException, InterruptedException;
    }

    public static final class UnexpectedLoaderException
    extends IOException {
        public UnexpectedLoaderException(Exception exception) {
            super("Unexpected " + exception.getClass().getSimpleName() + ": " + exception.getMessage(), exception);
        }
    }
}

