/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.content.Context;
import com.google.android.exoplayer.upstream.AssetDataSource;
import com.google.android.exoplayer.upstream.ContentDataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer.upstream.FileDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

public final class DefaultUriDataSource
implements UriDataSource {
    private static final String SCHEME_ASSET = "asset";
    private static final String SCHEME_CONTENT = "content";
    private final UriDataSource httpDataSource;
    private final UriDataSource fileDataSource;
    private final UriDataSource assetDataSource;
    private final UriDataSource contentDataSource;
    private UriDataSource dataSource;

    public DefaultUriDataSource(Context context, String string) {
        this(context, null, string, false);
    }

    public DefaultUriDataSource(Context context, TransferListener transferListener, String string) {
        this(context, transferListener, string, false);
    }

    public DefaultUriDataSource(Context context, TransferListener transferListener, String string, boolean bl) {
        this(context, transferListener, new DefaultHttpDataSource(string, null, transferListener, 8000, 8000, bl));
    }

    public DefaultUriDataSource(Context context, TransferListener transferListener, UriDataSource uriDataSource) {
        this.httpDataSource = Assertions.checkNotNull(uriDataSource);
        this.fileDataSource = new FileDataSource(transferListener);
        this.assetDataSource = new AssetDataSource(context, transferListener);
        this.contentDataSource = new ContentDataSource(context, transferListener);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        Assertions.checkState(this.dataSource == null);
        String string = dataSpec.uri.getScheme();
        this.dataSource = Util.isLocalFileUri(dataSpec.uri) ? (dataSpec.uri.getPath().startsWith("/android_asset/") ? this.assetDataSource : this.fileDataSource) : (SCHEME_ASSET.equals(string) ? this.assetDataSource : (SCHEME_CONTENT.equals(string) ? this.contentDataSource : this.httpDataSource));
        return this.dataSource.open(dataSpec);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.dataSource.read(byArray, n, n2);
    }

    @Override
    public String getUri() {
        return this.dataSource == null ? null : this.dataSource.getUri();
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            finally {
                this.dataSource = null;
            }
        }
    }
}

