/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.content.Context;
import android.content.res.AssetManager;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class AssetDataSource
implements UriDataSource {
    private final AssetManager assetManager;
    private final TransferListener listener;
    private String uriString;
    private InputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public AssetDataSource(Context context) {
        this(context, null);
    }

    public AssetDataSource(Context context, TransferListener transferListener) {
        this.assetManager = context.getAssets();
        this.listener = transferListener;
    }

    @Override
    public long open(DataSpec dataSpec) throws AssetDataSourceException {
        try {
            this.uriString = dataSpec.uri.toString();
            String string = dataSpec.uri.getPath();
            if (string.startsWith("/android_asset/")) {
                string = string.substring(15);
            } else if (string.startsWith("/")) {
                string = string.substring(1);
            }
            this.uriString = dataSpec.uri.toString();
            this.inputStream = this.assetManager.open(string, 1);
            long l = this.inputStream.skip(dataSpec.position);
            if (l < dataSpec.position) {
                throw new EOFException();
            }
            if (dataSpec.length != -1L) {
                this.bytesRemaining = dataSpec.length;
            } else {
                this.bytesRemaining = this.inputStream.available();
                if (this.bytesRemaining == Integer.MAX_VALUE) {
                    this.bytesRemaining = -1L;
                }
            }
        }
        catch (IOException iOException) {
            throw new AssetDataSourceException(iOException);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return this.bytesRemaining;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws AssetDataSourceException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int n3 = 0;
        try {
            int n4 = this.bytesRemaining == -1L ? n2 : (int)Math.min(this.bytesRemaining, (long)n2);
            n3 = this.inputStream.read(byArray, n, n4);
        }
        catch (IOException iOException) {
            throw new AssetDataSourceException(iOException);
        }
        if (n3 > 0) {
            if (this.bytesRemaining != -1L) {
                this.bytesRemaining -= (long)n3;
            }
            if (this.listener != null) {
                this.listener.onBytesTransferred(n3);
            }
        }
        return n3;
    }

    @Override
    public String getUri() {
        return this.uriString;
    }

    @Override
    public void close() throws AssetDataSourceException {
        this.uriString = null;
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                throw new AssetDataSourceException(iOException);
            }
            finally {
                this.inputStream = null;
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd();
                    }
                }
            }
        }
    }

    public static final class AssetDataSourceException
    extends IOException {
        public AssetDataSourceException(IOException iOException) {
            super(iOException);
        }
    }
}

