/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import android.text.SpannableStringBuilder;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.webvtt.WebvttCue;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class WebvttSubtitle
implements Subtitle {
    private final List<WebvttCue> cues;
    private final int numCues;
    private final long[] cueTimesUs;
    private final long[] sortedCueTimesUs;

    public WebvttSubtitle(List<WebvttCue> list) {
        this.cues = list;
        this.numCues = list.size();
        this.cueTimesUs = new long[2 * this.numCues];
        for (int i = 0; i < this.numCues; ++i) {
            WebvttCue webvttCue = list.get(i);
            int n = i * 2;
            this.cueTimesUs[n] = webvttCue.startTime;
            this.cueTimesUs[n + 1] = webvttCue.endTime;
        }
        this.sortedCueTimesUs = Arrays.copyOf(this.cueTimesUs, this.cueTimesUs.length);
        Arrays.sort(this.sortedCueTimesUs);
    }

    @Override
    public int getNextEventTimeIndex(long l) {
        int n = Util.binarySearchCeil(this.sortedCueTimesUs, l, false, false);
        return n < this.sortedCueTimesUs.length ? n : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.sortedCueTimesUs.length;
    }

    @Override
    public long getEventTime(int n) {
        Assertions.checkArgument(n >= 0);
        Assertions.checkArgument(n < this.sortedCueTimesUs.length);
        return this.sortedCueTimesUs[n];
    }

    @Override
    public long getLastEventTime() {
        if (this.getEventTimeCount() == 0) {
            return -1L;
        }
        return this.sortedCueTimesUs[this.sortedCueTimesUs.length - 1];
    }

    @Override
    public List<Cue> getCues(long l) {
        ArrayList<WebvttCue> arrayList = null;
        WebvttCue webvttCue = null;
        SpannableStringBuilder spannableStringBuilder = null;
        for (int i = 0; i < this.numCues; ++i) {
            WebvttCue webvttCue2;
            if (this.cueTimesUs[i * 2] > l || l >= this.cueTimesUs[i * 2 + 1]) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<WebvttCue>();
            }
            if ((webvttCue2 = this.cues.get(i)).isNormalCue()) {
                if (webvttCue == null) {
                    webvttCue = webvttCue2;
                    continue;
                }
                if (spannableStringBuilder == null) {
                    spannableStringBuilder = new SpannableStringBuilder();
                    spannableStringBuilder.append(webvttCue.text).append((CharSequence)"\n").append(webvttCue2.text);
                    continue;
                }
                spannableStringBuilder.append((CharSequence)"\n").append(webvttCue2.text);
                continue;
            }
            arrayList.add(webvttCue2);
        }
        if (spannableStringBuilder != null) {
            arrayList.add(new WebvttCue((CharSequence)spannableStringBuilder));
        } else if (webvttCue != null) {
            arrayList.add(webvttCue);
        }
        if (arrayList != null) {
            return arrayList;
        }
        return Collections.emptyList();
    }
}

