/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import android.text.TextUtils;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class TtmlColorParser {
    private static final String RGB = "rgb";
    private static final String RGBA = "rgba";
    private static final Pattern RGB_PATTERN = Pattern.compile("^rgb\\((\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)$");
    private static final Pattern RGBA_PATTERN = Pattern.compile("^rgba\\((\\d{1,3}),(\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)$");
    static final int TRANSPARENT = 0;
    static final int BLACK = -16777216;
    static final int SILVER = -4144960;
    static final int GRAY = -8355712;
    static final int WHITE = -1;
    static final int MAROON = -8388608;
    static final int RED = -65536;
    static final int PURPLE = -8388480;
    static final int FUCHSIA = -65281;
    static final int MAGENTA = -65281;
    static final int GREEN = -16744448;
    static final int LIME = -16711936;
    static final int OLIVE = -8355840;
    static final int YELLOW = -256;
    static final int NAVY = -16777088;
    static final int BLUE = -16776961;
    static final int TEAL = -16744320;
    static final int AQUA = 0xFFFFFF;
    static final int CYAN = -16711681;
    private static final Map<String, Integer> COLOR_NAME_MAP = new HashMap<String, Integer>();

    TtmlColorParser() {
    }

    public static int parseColor(String string) {
        Assertions.checkArgument(!TextUtils.isEmpty((CharSequence)string));
        string = string.replace(" ", "");
        if (string.charAt(0) == '#') {
            int n = (int)Long.parseLong(string.substring(1), 16);
            if (string.length() == 7) {
                n |= 0xFF000000;
            } else if (string.length() == 9) {
                n = (n & 0xFF) << 24 | n >>> 8;
            } else {
                throw new IllegalArgumentException();
            }
            return n;
        }
        if (string.startsWith(RGBA)) {
            Matcher matcher = RGBA_PATTERN.matcher(string);
            if (matcher.matches()) {
                return TtmlColorParser.argb(255 - Integer.parseInt(matcher.group(4), 10), Integer.parseInt(matcher.group(1), 10), Integer.parseInt(matcher.group(2), 10), Integer.parseInt(matcher.group(3), 10));
            }
        } else if (string.startsWith(RGB)) {
            Matcher matcher = RGB_PATTERN.matcher(string);
            if (matcher.matches()) {
                return TtmlColorParser.rgb(Integer.parseInt(matcher.group(1), 10), Integer.parseInt(matcher.group(2), 10), Integer.parseInt(matcher.group(3), 10));
            }
        } else {
            Integer n = COLOR_NAME_MAP.get(Util.toLowerInvariant(string));
            if (n != null) {
                return n;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int argb(int n, int n2, int n3, int n4) {
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    private static int rgb(int n, int n2, int n3) {
        return TtmlColorParser.argb(255, n, n2, n3);
    }

    static {
        COLOR_NAME_MAP.put("transparent", 0);
        COLOR_NAME_MAP.put("black", -16777216);
        COLOR_NAME_MAP.put("silver", -4144960);
        COLOR_NAME_MAP.put("gray", -8355712);
        COLOR_NAME_MAP.put("white", -1);
        COLOR_NAME_MAP.put("maroon", -8388608);
        COLOR_NAME_MAP.put("red", -65536);
        COLOR_NAME_MAP.put("purple", -8388480);
        COLOR_NAME_MAP.put("fuchsia", -65281);
        COLOR_NAME_MAP.put("magenta", -65281);
        COLOR_NAME_MAP.put("green", -16744448);
        COLOR_NAME_MAP.put("lime", -16711936);
        COLOR_NAME_MAP.put("olive", -8355840);
        COLOR_NAME_MAP.put("yellow", -256);
        COLOR_NAME_MAP.put("navy", -16777088);
        COLOR_NAME_MAP.put("blue", -16776961);
        COLOR_NAME_MAP.put("teal", -16744320);
        COLOR_NAME_MAP.put("aqua", 0xFFFFFF);
        COLOR_NAME_MAP.put("cyan", -16711681);
    }
}

