/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.subrip;

import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.util.Collections;
import java.util.List;

final class SubripSubtitle
implements Subtitle {
    private final Cue[] cues;
    private final long[] cueTimesUs;

    public SubripSubtitle(Cue[] cueArray, long[] lArray) {
        this.cues = cueArray;
        this.cueTimesUs = lArray;
    }

    @Override
    public int getNextEventTimeIndex(long l) {
        int n = Util.binarySearchCeil(this.cueTimesUs, l, false, false);
        return n < this.cueTimesUs.length ? n : -1;
    }

    @Override
    public int getEventTimeCount() {
        return this.cueTimesUs.length;
    }

    @Override
    public long getEventTime(int n) {
        Assertions.checkArgument(n >= 0);
        Assertions.checkArgument(n < this.cueTimesUs.length);
        return this.cueTimesUs[n];
    }

    @Override
    public long getLastEventTime() {
        if (this.getEventTimeCount() == 0) {
            return -1L;
        }
        return this.cueTimesUs[this.cueTimesUs.length - 1];
    }

    @Override
    public List<Cue> getCues(long l) {
        int n = Util.binarySearchFloor(this.cueTimesUs, l, true, false);
        if (n == -1 || this.cues[n] == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.cues[n]);
    }
}

