/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.google.android.exoplayer.text.CaptionStyleCompat;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;

final class CuePainter {
    private static final String TAG = "CuePainter";
    private static final float INNER_PADDING_RATIO = 0.125f;
    private final RectF lineBounds = new RectF();
    private final float cornerRadius;
    private final float outlineWidth;
    private final float shadowRadius;
    private final float shadowOffset;
    private final float spacingMult;
    private final float spacingAdd;
    private final TextPaint textPaint;
    private final Paint paint;
    private CharSequence cueText;
    private Layout.Alignment cueTextAlignment;
    private float cueLine;
    private int cueLineType;
    private int cueLineAnchor;
    private float cuePosition;
    private int cuePositionAnchor;
    private float cueSize;
    private boolean applyEmbeddedStyles;
    private int foregroundColor;
    private int backgroundColor;
    private int windowColor;
    private int edgeColor;
    private int edgeType;
    private float textSizePx;
    private float bottomPaddingFraction;
    private int parentLeft;
    private int parentTop;
    private int parentRight;
    private int parentBottom;
    private StaticLayout textLayout;
    private int textLeft;
    private int textTop;
    private int textPaddingX;

    public CuePainter(Context context) {
        int[] nArray = new int[]{16843287, 16843288};
        TypedArray typedArray = context.obtainStyledAttributes(null, nArray, 0, 0);
        this.spacingAdd = typedArray.getDimensionPixelSize(0, 0);
        this.spacingMult = typedArray.getFloat(1, 1.0f);
        typedArray.recycle();
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        int n = Math.round(2.0f * (float)displayMetrics.densityDpi / 160.0f);
        this.cornerRadius = n;
        this.outlineWidth = n;
        this.shadowRadius = n;
        this.shadowOffset = n;
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setSubpixelText(true);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
    }

    public void draw(Cue cue, boolean bl, CaptionStyleCompat captionStyleCompat, float f2, float f3, Canvas canvas, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        CharSequence charSequence = cue.text;
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            return;
        }
        if (!bl) {
            charSequence = charSequence.toString();
        }
        if (CuePainter.areCharSequencesEqual(this.cueText, charSequence) && Util.areEqual(this.cueTextAlignment, cue.textAlignment) && this.cueLine == cue.line && this.cueLineType == cue.lineType && Util.areEqual(this.cueLineAnchor, cue.lineAnchor) && this.cuePosition == cue.position && Util.areEqual(this.cuePositionAnchor, cue.positionAnchor) && this.cueSize == cue.size && this.applyEmbeddedStyles == bl && this.foregroundColor == captionStyleCompat.foregroundColor && this.backgroundColor == captionStyleCompat.backgroundColor && this.windowColor == captionStyleCompat.windowColor && this.edgeType == captionStyleCompat.edgeType && this.edgeColor == captionStyleCompat.edgeColor && Util.areEqual(this.textPaint.getTypeface(), captionStyleCompat.typeface) && this.textSizePx == f2 && this.bottomPaddingFraction == f3 && this.parentLeft == n && this.parentTop == n2 && this.parentRight == n3 && this.parentBottom == n4) {
            this.drawLayout(canvas);
            return;
        }
        this.cueText = charSequence;
        this.cueTextAlignment = cue.textAlignment;
        this.cueLine = cue.line;
        this.cueLineType = cue.lineType;
        this.cueLineAnchor = cue.lineAnchor;
        this.cuePosition = cue.position;
        this.cuePositionAnchor = cue.positionAnchor;
        this.cueSize = cue.size;
        this.applyEmbeddedStyles = bl;
        this.foregroundColor = captionStyleCompat.foregroundColor;
        this.backgroundColor = captionStyleCompat.backgroundColor;
        this.windowColor = captionStyleCompat.windowColor;
        this.edgeType = captionStyleCompat.edgeType;
        this.edgeColor = captionStyleCompat.edgeColor;
        this.textPaint.setTypeface(captionStyleCompat.typeface);
        this.textSizePx = f2;
        this.bottomPaddingFraction = f3;
        this.parentLeft = n;
        this.parentTop = n2;
        this.parentRight = n3;
        this.parentBottom = n4;
        int n8 = this.parentRight - this.parentLeft;
        int n9 = this.parentBottom - this.parentTop;
        this.textPaint.setTextSize(f2);
        int n10 = (int)(f2 * 0.125f + 0.5f);
        int n11 = n8 - n10 * 2;
        if (this.cueSize != Float.MIN_VALUE) {
            n11 = (int)((float)n11 * this.cueSize);
        }
        if (n11 <= 0) {
            a.c(TAG, "Skipped drawing subtitle cue (insufficient space)");
            return;
        }
        Layout.Alignment alignment = this.cueTextAlignment == null ? Layout.Alignment.ALIGN_CENTER : this.cueTextAlignment;
        this.textLayout = new StaticLayout(charSequence, this.textPaint, n11, alignment, this.spacingMult, this.spacingAdd, true);
        int n12 = this.textLayout.getHeight();
        int n13 = 0;
        int n14 = this.textLayout.getLineCount();
        for (n7 = 0; n7 < n14; ++n7) {
            n13 = Math.max((int)Math.ceil(this.textLayout.getLineWidth(n7)), n13);
        }
        n13 += n10 * 2;
        if (this.cuePosition != Float.MIN_VALUE) {
            n6 = Math.round((float)n8 * this.cuePosition) + this.parentLeft;
            n7 = this.cuePositionAnchor == 2 ? n6 - n13 : (this.cuePositionAnchor == 1 ? (n6 * 2 - n13) / 2 : n6);
            n7 = Math.max(n7, this.parentLeft);
            n5 = Math.min(n7 + n13, this.parentRight);
        } else {
            n7 = (n8 - n13) / 2;
            n5 = n7 + n13;
        }
        if (this.cueLine != Float.MIN_VALUE) {
            int n15;
            if (this.cueLineType == 0) {
                n15 = Math.round((float)n9 * this.cueLine) + this.parentTop;
            } else {
                int n16 = this.textLayout.getLineBottom(0) - this.textLayout.getLineTop(0);
                n15 = this.cueLine >= 0.0f ? Math.round(this.cueLine * (float)n16) + this.parentTop : Math.round(this.cueLine * (float)n16) + this.parentBottom;
            }
            n6 = this.cueLineAnchor == 2 ? n15 - n12 : (this.cueLineAnchor == 1 ? (n15 * 2 - n12) / 2 : n15);
            int n17 = n6 + n12;
            if (n17 > this.parentBottom) {
                n6 = this.parentBottom - n12;
                n17 = this.parentBottom;
            } else if (n6 < this.parentTop) {
                n6 = this.parentTop;
                n17 = this.parentTop + n12;
            }
        } else {
            n6 = this.parentBottom - n12 - (int)((float)n9 * f3);
            int n18 = n6 + n12;
        }
        n13 = n5 - n7;
        this.textLayout = new StaticLayout(charSequence, this.textPaint, n13, alignment, this.spacingMult, this.spacingAdd, true);
        this.textLeft = n7;
        this.textTop = n6;
        this.textPaddingX = n10;
        this.drawLayout(canvas);
    }

    private void drawLayout(Canvas canvas) {
        int n;
        int n2;
        StaticLayout staticLayout = this.textLayout;
        if (staticLayout == null) {
            return;
        }
        int n3 = canvas.save();
        canvas.translate((float)this.textLeft, (float)this.textTop);
        if (Color.alpha((int)this.windowColor) > 0) {
            this.paint.setColor(this.windowColor);
            canvas.drawRect((float)(-this.textPaddingX), 0.0f, (float)(staticLayout.getWidth() + this.textPaddingX), (float)staticLayout.getHeight(), this.paint);
        }
        if (Color.alpha((int)this.backgroundColor) > 0) {
            this.paint.setColor(this.backgroundColor);
            float f2 = staticLayout.getLineTop(0);
            n2 = staticLayout.getLineCount();
            for (n = 0; n < n2; ++n) {
                this.lineBounds.left = staticLayout.getLineLeft(n) - (float)this.textPaddingX;
                this.lineBounds.right = staticLayout.getLineRight(n) + (float)this.textPaddingX;
                this.lineBounds.top = f2;
                f2 = this.lineBounds.bottom = (float)staticLayout.getLineBottom(n);
                canvas.drawRoundRect(this.lineBounds, this.cornerRadius, this.cornerRadius, this.paint);
            }
        }
        if (this.edgeType == 1) {
            this.textPaint.setStrokeJoin(Paint.Join.ROUND);
            this.textPaint.setStrokeWidth(this.outlineWidth);
            this.textPaint.setColor(this.edgeColor);
            this.textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            staticLayout.draw(canvas);
        } else if (this.edgeType == 2) {
            this.textPaint.setShadowLayer(this.shadowRadius, this.shadowOffset, this.shadowOffset, this.edgeColor);
        } else if (this.edgeType == 3 || this.edgeType == 4) {
            boolean bl = this.edgeType == 3;
            n2 = bl ? -1 : this.edgeColor;
            n = bl ? this.edgeColor : -1;
            float f3 = this.shadowRadius / 2.0f;
            this.textPaint.setColor(this.foregroundColor);
            this.textPaint.setStyle(Paint.Style.FILL);
            this.textPaint.setShadowLayer(this.shadowRadius, -f3, -f3, n2);
            staticLayout.draw(canvas);
            this.textPaint.setShadowLayer(this.shadowRadius, f3, f3, n);
        }
        this.textPaint.setColor(this.foregroundColor);
        this.textPaint.setStyle(Paint.Style.FILL);
        staticLayout.draw(canvas);
        this.textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        canvas.restoreToCount(n3);
    }

    private static boolean areCharSequencesEqual(CharSequence charSequence, CharSequence charSequence2) {
        return charSequence == charSequence2 || charSequence != null && charSequence.equals(charSequence2);
    }
}

