/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ts;

import android.util.SparseArray;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.ts.Ac3Reader;
import com.google.android.exoplayer.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer.extractor.ts.H262Reader;
import com.google.android.exoplayer.extractor.ts.MpegAudioReader;
import com.google.android.exoplayer.extractor.ts.PtsTimestampAdjuster;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

public final class PsExtractor
implements Extractor {
    private static final int PACK_START_CODE = 442;
    private static final int SYSTEM_HEADER_START_CODE = 443;
    private static final int PACKET_START_CODE_PREFIX = 1;
    private static final int MPEG_PROGRAM_END_CODE = 441;
    private static final long MAX_SEARCH_LENGTH = 0x100000L;
    public static final int PRIVATE_STREAM_1 = 189;
    public static final int AUDIO_STREAM = 192;
    public static final int AUDIO_STREAM_MASK = 224;
    public static final int VIDEO_STREAM = 224;
    public static final int VIDEO_STREAM_MASK = 240;
    private final PtsTimestampAdjuster ptsTimestampAdjuster;
    private final SparseArray<PesReader> psPayloadReaders;
    private final ParsableByteArray psPacketBuffer;
    private boolean foundAllTracks;
    private boolean foundAudioTrack;
    private boolean foundVideoTrack;
    private ExtractorOutput output;

    public PsExtractor() {
        this(new PtsTimestampAdjuster(0L));
    }

    public PsExtractor(PtsTimestampAdjuster ptsTimestampAdjuster) {
        this.ptsTimestampAdjuster = ptsTimestampAdjuster;
        this.psPacketBuffer = new ParsableByteArray(4096);
        this.psPayloadReaders = new SparseArray();
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        byte[] byArray = new byte[14];
        extractorInput.peekFully(byArray, 0, 14);
        if (442 != ((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF)) {
            return false;
        }
        if ((byArray[4] & 0xC4) != 68) {
            return false;
        }
        if ((byArray[6] & 4) != 4) {
            return false;
        }
        if ((byArray[8] & 4) != 4) {
            return false;
        }
        if ((byArray[9] & 1) != 1) {
            return false;
        }
        if ((byArray[12] & 3) != 3) {
            return false;
        }
        int n = byArray[13] & 7;
        extractorInput.advancePeekPosition(n);
        extractorInput.peekFully(byArray, 0, 3);
        return 1 == ((byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF);
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.output = extractorOutput;
        extractorOutput.seekMap(SeekMap.UNSEEKABLE);
    }

    @Override
    public void seek() {
        this.ptsTimestampAdjuster.reset();
        for (int i = 0; i < this.psPayloadReaders.size(); ++i) {
            ((PesReader)this.psPayloadReaders.valueAt(i)).seek();
        }
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        if (!extractorInput.peekFully(this.psPacketBuffer.data, 0, 4, true)) {
            return -1;
        }
        this.psPacketBuffer.setPosition(0);
        int n = this.psPacketBuffer.readInt();
        if (n == 441) {
            return -1;
        }
        if (n == 442) {
            extractorInput.peekFully(this.psPacketBuffer.data, 0, 10);
            this.psPacketBuffer.setPosition(0);
            this.psPacketBuffer.skipBytes(9);
            int n2 = this.psPacketBuffer.readUnsignedByte() & 7;
            extractorInput.skipFully(n2 + 14);
            return 0;
        }
        if (n == 443) {
            extractorInput.peekFully(this.psPacketBuffer.data, 0, 2);
            this.psPacketBuffer.setPosition(0);
            int n3 = this.psPacketBuffer.readUnsignedShort();
            extractorInput.skipFully(n3 + 6);
            return 0;
        }
        if ((n & 0xFFFFFF00) >> 8 != 1) {
            extractorInput.skipFully(1);
            return 0;
        }
        int n4 = n & 0xFF;
        PesReader pesReader = (PesReader)this.psPayloadReaders.get(n4);
        if (!this.foundAllTracks) {
            if (pesReader == null) {
                ElementaryStreamReader elementaryStreamReader = null;
                if (!this.foundAudioTrack && n4 == 189) {
                    elementaryStreamReader = new Ac3Reader(this.output.track(n4), false);
                    this.foundAudioTrack = true;
                } else if (!this.foundAudioTrack && (n4 & 0xE0) == 192) {
                    elementaryStreamReader = new MpegAudioReader(this.output.track(n4));
                    this.foundAudioTrack = true;
                } else if (!this.foundVideoTrack && (n4 & 0xF0) == 224) {
                    elementaryStreamReader = new H262Reader(this.output.track(n4));
                    this.foundVideoTrack = true;
                }
                if (elementaryStreamReader != null) {
                    pesReader = new PesReader(elementaryStreamReader, this.ptsTimestampAdjuster);
                    this.psPayloadReaders.put(n4, (Object)pesReader);
                }
            }
            if (this.foundAudioTrack && this.foundVideoTrack || extractorInput.getPosition() > 0x100000L) {
                this.foundAllTracks = true;
                this.output.endTracks();
            }
        }
        extractorInput.peekFully(this.psPacketBuffer.data, 0, 2);
        this.psPacketBuffer.setPosition(0);
        int n5 = this.psPacketBuffer.readUnsignedShort();
        int n6 = n5 + 6;
        if (pesReader == null) {
            extractorInput.skipFully(n6);
        } else {
            if (this.psPacketBuffer.capacity() < n6) {
                this.psPacketBuffer.reset(new byte[n6], n6);
            }
            extractorInput.readFully(this.psPacketBuffer.data, 0, n6);
            this.psPacketBuffer.setPosition(6);
            this.psPacketBuffer.setLimit(n6);
            pesReader.consume(this.psPacketBuffer, this.output);
            this.psPacketBuffer.setLimit(this.psPacketBuffer.capacity());
        }
        return 0;
    }

    private static final class PesReader {
        private static final int PES_SCRATCH_SIZE = 64;
        private final ElementaryStreamReader pesPayloadReader;
        private final PtsTimestampAdjuster ptsTimestampAdjuster;
        private final ParsableBitArray pesScratch;
        private boolean ptsFlag;
        private boolean dtsFlag;
        private boolean seenFirstDts;
        private int extendedHeaderLength;
        private long timeUs;

        public PesReader(ElementaryStreamReader elementaryStreamReader, PtsTimestampAdjuster ptsTimestampAdjuster) {
            this.pesPayloadReader = elementaryStreamReader;
            this.ptsTimestampAdjuster = ptsTimestampAdjuster;
            this.pesScratch = new ParsableBitArray(new byte[64]);
        }

        public void seek() {
            this.seenFirstDts = false;
            this.pesPayloadReader.seek();
        }

        public void consume(ParsableByteArray parsableByteArray, ExtractorOutput extractorOutput) {
            parsableByteArray.readBytes(this.pesScratch.data, 0, 3);
            this.pesScratch.setPosition(0);
            this.parseHeader();
            parsableByteArray.readBytes(this.pesScratch.data, 0, this.extendedHeaderLength);
            this.pesScratch.setPosition(0);
            this.parseHeaderExtension();
            this.pesPayloadReader.packetStarted(this.timeUs, true);
            this.pesPayloadReader.consume(parsableByteArray);
            this.pesPayloadReader.packetFinished();
        }

        private void parseHeader() {
            this.pesScratch.skipBits(8);
            this.ptsFlag = this.pesScratch.readBit();
            this.dtsFlag = this.pesScratch.readBit();
            this.pesScratch.skipBits(6);
            this.extendedHeaderLength = this.pesScratch.readBits(8);
        }

        private void parseHeaderExtension() {
            this.timeUs = 0L;
            if (this.ptsFlag) {
                this.pesScratch.skipBits(4);
                long l = (long)this.pesScratch.readBits(3) << 30;
                this.pesScratch.skipBits(1);
                l |= (long)(this.pesScratch.readBits(15) << 15);
                this.pesScratch.skipBits(1);
                l |= (long)this.pesScratch.readBits(15);
                this.pesScratch.skipBits(1);
                if (!this.seenFirstDts && this.dtsFlag) {
                    this.pesScratch.skipBits(4);
                    long l2 = (long)this.pesScratch.readBits(3) << 30;
                    this.pesScratch.skipBits(1);
                    l2 |= (long)(this.pesScratch.readBits(15) << 15);
                    this.pesScratch.skipBits(1);
                    this.pesScratch.skipBits(1);
                    this.ptsTimestampAdjuster.adjustTimestamp(l2 |= (long)this.pesScratch.readBits(15));
                    this.seenFirstDts = true;
                }
                this.timeUs = this.ptsTimestampAdjuster.adjustTimestamp(l);
            }
        }
    }
}

