/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import android.util.Pair;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.GaplessInfo;
import com.google.android.exoplayer.extractor.mp4.Atom;
import com.google.android.exoplayer.extractor.mp4.Track;
import com.google.android.exoplayer.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer.extractor.mp4.TrackSampleTable;
import com.google.android.exoplayer.util.Ac3Util;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableBitArray;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class AtomParsers {
    public static Track parseTrak(Atom.ContainerAtom containerAtom, Atom.LeafAtom leafAtom, boolean bl) {
        Atom.ContainerAtom containerAtom2 = containerAtom.getContainerAtomOfType(Atom.TYPE_mdia);
        int n = AtomParsers.parseHdlr(containerAtom2.getLeafAtomOfType((int)Atom.TYPE_hdlr).data);
        if (n != Track.TYPE_soun && n != Track.TYPE_vide && n != Track.TYPE_text && n != Track.TYPE_sbtl && n != Track.TYPE_subt) {
            return null;
        }
        TkhdData tkhdData = AtomParsers.parseTkhd(containerAtom.getLeafAtomOfType((int)Atom.TYPE_tkhd).data);
        long l = tkhdData.duration;
        long l2 = AtomParsers.parseMvhd(leafAtom.data);
        long l3 = l == -1L ? -1L : Util.scaleLargeTimestamp(l, 1000000L, l2);
        Atom.ContainerAtom containerAtom3 = containerAtom2.getContainerAtomOfType(Atom.TYPE_minf).getContainerAtomOfType(Atom.TYPE_stbl);
        Pair<Long, String> pair = AtomParsers.parseMdhd(containerAtom2.getLeafAtomOfType((int)Atom.TYPE_mdhd).data);
        StsdData stsdData = AtomParsers.parseStsd(containerAtom3.getLeafAtomOfType((int)Atom.TYPE_stsd).data, tkhdData.id, l3, tkhdData.rotationDegrees, (String)pair.second, bl);
        Pair<long[], long[]> pair2 = AtomParsers.parseEdts(containerAtom.getContainerAtomOfType(Atom.TYPE_edts));
        return stsdData.mediaFormat == null ? null : new Track(tkhdData.id, n, (Long)pair.first, l2, l3, stsdData.mediaFormat, stsdData.trackEncryptionBoxes, stsdData.nalUnitLengthFieldLength, (long[])pair2.first, (long[])pair2.second);
    }

    public static TrackSampleTable parseStbl(Track track, Atom.ContainerAtom containerAtom) throws ParserException {
        int n;
        int n2;
        ParsableByteArray parsableByteArray = containerAtom.getLeafAtomOfType((int)Atom.TYPE_stsz).data;
        Atom.LeafAtom leafAtom = containerAtom.getLeafAtomOfType(Atom.TYPE_stco);
        if (leafAtom == null) {
            leafAtom = containerAtom.getLeafAtomOfType(Atom.TYPE_co64);
        }
        ParsableByteArray parsableByteArray2 = leafAtom.data;
        ParsableByteArray parsableByteArray3 = containerAtom.getLeafAtomOfType((int)Atom.TYPE_stsc).data;
        ParsableByteArray parsableByteArray4 = containerAtom.getLeafAtomOfType((int)Atom.TYPE_stts).data;
        Atom.LeafAtom leafAtom2 = containerAtom.getLeafAtomOfType(Atom.TYPE_stss);
        ParsableByteArray parsableByteArray5 = leafAtom2 != null ? leafAtom2.data : null;
        Atom.LeafAtom leafAtom3 = containerAtom.getLeafAtomOfType(Atom.TYPE_ctts);
        ParsableByteArray parsableByteArray6 = leafAtom3 != null ? leafAtom3.data : null;
        parsableByteArray.setPosition(12);
        int n3 = parsableByteArray.readUnsignedIntToInt();
        int n4 = parsableByteArray.readUnsignedIntToInt();
        long[] lArray = new long[n4];
        int[] nArray = new int[n4];
        int n5 = 0;
        long[] lArray2 = new long[n4];
        int[] nArray2 = new int[n4];
        if (n4 == 0) {
            return new TrackSampleTable(lArray, nArray, n5, lArray2, nArray2);
        }
        parsableByteArray2.setPosition(12);
        int n6 = parsableByteArray2.readUnsignedIntToInt();
        parsableByteArray3.setPosition(12);
        int n7 = parsableByteArray3.readUnsignedIntToInt() - 1;
        Assertions.checkState(parsableByteArray3.readInt() == 1, "stsc first chunk must be 1");
        int n8 = parsableByteArray3.readUnsignedIntToInt();
        parsableByteArray3.skipBytes(4);
        int n9 = -1;
        if (n7 > 0) {
            n9 = parsableByteArray3.readUnsignedIntToInt() - 1;
        }
        int n10 = 0;
        int n11 = n8;
        parsableByteArray4.setPosition(12);
        int n12 = parsableByteArray4.readUnsignedIntToInt() - 1;
        int n13 = parsableByteArray4.readUnsignedIntToInt();
        int n14 = parsableByteArray4.readUnsignedIntToInt();
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        if (parsableByteArray6 != null) {
            parsableByteArray6.setPosition(12);
            n16 = parsableByteArray6.readUnsignedIntToInt();
        }
        int n18 = -1;
        int n19 = 0;
        if (parsableByteArray5 != null) {
            parsableByteArray5.setPosition(12);
            n19 = parsableByteArray5.readUnsignedIntToInt();
            n18 = parsableByteArray5.readUnsignedIntToInt() - 1;
        }
        long l = leafAtom.type == Atom.TYPE_stco ? parsableByteArray2.readUnsignedInt() : parsableByteArray2.readUnsignedLongToLong();
        long l2 = 0L;
        for (n2 = 0; n2 < n4; ++n2) {
            if (parsableByteArray6 != null) {
                while (n15 == 0 && n16 > 0) {
                    n15 = parsableByteArray6.readUnsignedIntToInt();
                    n17 = parsableByteArray6.readInt();
                    --n16;
                }
                --n15;
            }
            lArray[n2] = l;
            int n20 = nArray[n2] = n3 == 0 ? parsableByteArray.readUnsignedIntToInt() : n3;
            if (nArray[n2] > n5) {
                n5 = nArray[n2];
            }
            lArray2[n2] = l2 + (long)n17;
            int n21 = nArray2[n2] = parsableByteArray5 == null ? 1 : 0;
            if (n2 == n18) {
                nArray2[n2] = 1;
                if (--n19 > 0) {
                    n18 = parsableByteArray5.readUnsignedIntToInt() - 1;
                }
            }
            l2 += (long)n14;
            if (--n13 == 0 && n12 > 0) {
                n13 = parsableByteArray4.readUnsignedIntToInt();
                n14 = parsableByteArray4.readUnsignedIntToInt();
                --n12;
            }
            if (--n11 == 0) {
                if (++n10 < n6) {
                    l = leafAtom.type == Atom.TYPE_stco ? parsableByteArray2.readUnsignedInt() : parsableByteArray2.readUnsignedLongToLong();
                }
                if (n10 == n9) {
                    n8 = parsableByteArray3.readUnsignedIntToInt();
                    parsableByteArray3.skipBytes(4);
                    if (--n7 > 0) {
                        n9 = parsableByteArray3.readUnsignedIntToInt() - 1;
                    }
                }
                if (n10 >= n6) continue;
                n11 = n8;
                continue;
            }
            l += (long)nArray[n2];
        }
        Assertions.checkArgument(n19 == 0);
        Assertions.checkArgument(n13 == 0);
        Assertions.checkArgument(n11 == 0);
        Assertions.checkArgument(n12 == 0);
        Assertions.checkArgument(n16 == 0);
        if (track.editListDurations == null) {
            Util.scaleLargeTimestampsInPlace(lArray2, 1000000L, track.timescale);
            return new TrackSampleTable(lArray, nArray, n5, lArray2, nArray2);
        }
        if (track.editListDurations.length == 1 && track.editListDurations[0] == 0L) {
            for (n2 = 0; n2 < lArray2.length; ++n2) {
                lArray2[n2] = Util.scaleLargeTimestamp(lArray2[n2] - track.editListMediaTimes[0], 1000000L, track.timescale);
            }
            return new TrackSampleTable(lArray, nArray, n5, lArray2, nArray2);
        }
        n2 = 0;
        int n22 = 0;
        boolean bl = false;
        for (int i = 0; i < track.editListDurations.length; ++i) {
            long l3 = track.editListMediaTimes[i];
            if (l3 == -1L) continue;
            long l4 = Util.scaleLargeTimestamp(track.editListDurations[i], track.timescale, track.movieTimescale);
            int n23 = Util.binarySearchCeil(lArray2, l3, true, true);
            int n24 = Util.binarySearchCeil(lArray2, l3 + l4, true, false);
            n2 += n24 - n23;
            bl |= n22 != n23;
            n22 = n24;
        }
        long[] lArray3 = (bl |= n2 != n4) ? new long[n2] : lArray;
        int[] nArray3 = bl ? new int[n2] : nArray;
        int n25 = bl ? 0 : n5;
        int[] nArray4 = bl ? new int[n2] : nArray2;
        long[] lArray4 = new long[n2];
        long l5 = 0L;
        int n26 = 0;
        for (n = 0; n < track.editListDurations.length; ++n) {
            long l6 = track.editListMediaTimes[n];
            long l7 = track.editListDurations[n];
            if (l6 != -1L) {
                int n27;
                long l8 = l6 + Util.scaleLargeTimestamp(l7, track.timescale, track.movieTimescale);
                int n28 = Util.binarySearchCeil(lArray2, l6, true, true);
                int n29 = Util.binarySearchCeil(lArray2, l8, true, false);
                if (bl) {
                    n27 = n29 - n28;
                    System.arraycopy(lArray, n28, lArray3, n26, n27);
                    System.arraycopy(nArray, n28, nArray3, n26, n27);
                    System.arraycopy(nArray2, n28, nArray4, n26, n27);
                }
                for (n27 = n28; n27 < n29; ++n27) {
                    long l9 = Util.scaleLargeTimestamp(l5, 1000000L, track.movieTimescale);
                    long l10 = Util.scaleLargeTimestamp(lArray2[n27] - l6, 1000000L, track.timescale);
                    lArray4[n26] = l9 + l10;
                    if (bl && nArray3[n26] > n25) {
                        n25 = nArray[n27];
                    }
                    ++n26;
                }
            }
            l5 += l7;
        }
        n = 0;
        for (int i = 0; i < nArray4.length && n == 0; n |= (nArray4[i] & 1) != 0 ? 1 : 0, ++i) {
        }
        if (n == 0) {
            throw new ParserException("The edited sample sequence does not contain a sync sample.");
        }
        return new TrackSampleTable(lArray3, nArray3, n25, lArray4, nArray4);
    }

    public static GaplessInfo parseUdta(Atom.LeafAtom leafAtom, boolean bl) {
        if (bl) {
            return null;
        }
        ParsableByteArray parsableByteArray = leafAtom.data;
        parsableByteArray.setPosition(8);
        while (parsableByteArray.bytesLeft() >= 8) {
            int n = parsableByteArray.readInt();
            int n2 = parsableByteArray.readInt();
            if (n2 == Atom.TYPE_meta) {
                parsableByteArray.setPosition(parsableByteArray.getPosition() - 8);
                parsableByteArray.setLimit(parsableByteArray.getPosition() + n);
                return AtomParsers.parseMetaAtom(parsableByteArray);
            }
            parsableByteArray.skipBytes(n - 8);
        }
        return null;
    }

    private static GaplessInfo parseMetaAtom(ParsableByteArray parsableByteArray) {
        parsableByteArray.skipBytes(12);
        ParsableByteArray parsableByteArray2 = new ParsableByteArray();
        while (parsableByteArray.bytesLeft() >= 8) {
            int n = parsableByteArray.readInt() - 8;
            int n2 = parsableByteArray.readInt();
            if (n2 == Atom.TYPE_ilst) {
                parsableByteArray2.reset(parsableByteArray.data, parsableByteArray.getPosition() + n);
                parsableByteArray2.setPosition(parsableByteArray.getPosition());
                GaplessInfo gaplessInfo = AtomParsers.parseIlst(parsableByteArray2);
                if (gaplessInfo != null) {
                    return gaplessInfo;
                }
            }
            parsableByteArray.skipBytes(n);
        }
        return null;
    }

    private static GaplessInfo parseIlst(ParsableByteArray parsableByteArray) {
        while (parsableByteArray.bytesLeft() > 0) {
            int n = parsableByteArray.getPosition();
            int n2 = n + parsableByteArray.readInt();
            int n3 = parsableByteArray.readInt();
            if (n3 == Atom.TYPE_DASHES) {
                String string = null;
                String string2 = null;
                String string3 = null;
                while (parsableByteArray.getPosition() < n2) {
                    int n4 = parsableByteArray.readInt() - 12;
                    int n5 = parsableByteArray.readInt();
                    parsableByteArray.skipBytes(4);
                    if (n5 == Atom.TYPE_mean) {
                        string = parsableByteArray.readString(n4);
                        continue;
                    }
                    if (n5 == Atom.TYPE_name) {
                        string2 = parsableByteArray.readString(n4);
                        continue;
                    }
                    if (n5 == Atom.TYPE_data) {
                        parsableByteArray.skipBytes(4);
                        string3 = parsableByteArray.readString(n4 - 4);
                        continue;
                    }
                    parsableByteArray.skipBytes(n4);
                }
                if (string2 == null || string3 == null || !"com.apple.iTunes".equals(string)) continue;
                return GaplessInfo.createFromComment(string2, string3);
            }
            parsableByteArray.setPosition(n2);
        }
        return null;
    }

    private static long parseMvhd(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        int n = parsableByteArray.readInt();
        int n2 = Atom.parseFullAtomVersion(n);
        parsableByteArray.skipBytes(n2 == 0 ? 8 : 16);
        return parsableByteArray.readUnsignedInt();
    }

    private static TkhdData parseTkhd(ParsableByteArray parsableByteArray) {
        long l;
        parsableByteArray.setPosition(8);
        int n = parsableByteArray.readInt();
        int n2 = Atom.parseFullAtomVersion(n);
        parsableByteArray.skipBytes(n2 == 0 ? 8 : 16);
        int n3 = parsableByteArray.readInt();
        parsableByteArray.skipBytes(4);
        boolean bl = true;
        int n4 = parsableByteArray.getPosition();
        int n5 = n2 == 0 ? 4 : 8;
        for (int i = 0; i < n5; ++i) {
            if (parsableByteArray.data[n4 + i] == -1) continue;
            bl = false;
            break;
        }
        if (bl) {
            parsableByteArray.skipBytes(n5);
            l = -1L;
        } else {
            l = n2 == 0 ? parsableByteArray.readUnsignedInt() : parsableByteArray.readUnsignedLongToLong();
        }
        parsableByteArray.skipBytes(16);
        int n6 = parsableByteArray.readInt();
        int n7 = parsableByteArray.readInt();
        parsableByteArray.skipBytes(4);
        int n8 = parsableByteArray.readInt();
        int n9 = parsableByteArray.readInt();
        int n10 = 65536;
        int n11 = n6 == 0 && n7 == n10 && n8 == -n10 && n9 == 0 ? 90 : (n6 == 0 && n7 == -n10 && n8 == n10 && n9 == 0 ? 270 : (n6 == -n10 && n7 == 0 && n8 == 0 && n9 == -n10 ? 180 : 0));
        return new TkhdData(n3, l, n11);
    }

    private static int parseHdlr(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(16);
        return parsableByteArray.readInt();
    }

    private static Pair<Long, String> parseMdhd(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        int n = parsableByteArray.readInt();
        int n2 = Atom.parseFullAtomVersion(n);
        parsableByteArray.skipBytes(n2 == 0 ? 8 : 16);
        long l = parsableByteArray.readUnsignedInt();
        parsableByteArray.skipBytes(n2 == 0 ? 4 : 8);
        int n3 = parsableByteArray.readUnsignedShort();
        String string = "" + (char)((n3 >> 10 & 0x1F) + 96) + (char)((n3 >> 5 & 0x1F) + 96) + (char)((n3 & 0x1F) + 96);
        return Pair.create((Object)l, (Object)string);
    }

    private static StsdData parseStsd(ParsableByteArray parsableByteArray, int n, long l, int n2, String string, boolean bl) {
        parsableByteArray.setPosition(12);
        int n3 = parsableByteArray.readInt();
        StsdData stsdData = new StsdData(n3);
        for (int i = 0; i < n3; ++i) {
            int n4 = parsableByteArray.getPosition();
            int n5 = parsableByteArray.readInt();
            Assertions.checkArgument(n5 > 0, "childAtomSize should be positive");
            int n6 = parsableByteArray.readInt();
            if (n6 == Atom.TYPE_avc1 || n6 == Atom.TYPE_avc3 || n6 == Atom.TYPE_encv || n6 == Atom.TYPE_mp4v || n6 == Atom.TYPE_hvc1 || n6 == Atom.TYPE_hev1 || n6 == Atom.TYPE_s263) {
                AtomParsers.parseVideoSampleEntry(parsableByteArray, n4, n5, n, l, n2, stsdData, i);
            } else if (n6 == Atom.TYPE_mp4a || n6 == Atom.TYPE_enca || n6 == Atom.TYPE_ac_3 || n6 == Atom.TYPE_ec_3 || n6 == Atom.TYPE_dtsc || n6 == Atom.TYPE_dtse || n6 == Atom.TYPE_dtsh || n6 == Atom.TYPE_dtsl || n6 == Atom.TYPE_samr || n6 == Atom.TYPE_sawb) {
                AtomParsers.parseAudioSampleEntry(parsableByteArray, n6, n4, n5, n, l, string, bl, stsdData, i);
            } else if (n6 == Atom.TYPE_TTML) {
                stsdData.mediaFormat = MediaFormat.createTextFormat(Integer.toString(n), "application/ttml+xml", -1, l, string);
            } else if (n6 == Atom.TYPE_tx3g) {
                stsdData.mediaFormat = MediaFormat.createTextFormat(Integer.toString(n), "application/x-quicktime-tx3g", -1, l, string);
            } else if (n6 == Atom.TYPE_wvtt) {
                stsdData.mediaFormat = MediaFormat.createTextFormat(Integer.toString(n), "application/x-mp4vtt", -1, l, string);
            } else if (n6 == Atom.TYPE_stpp) {
                stsdData.mediaFormat = MediaFormat.createTextFormat(Integer.toString(n), "application/ttml+xml", -1, l, string, 0L);
            }
            parsableByteArray.setPosition(n4 + n5);
        }
        return stsdData;
    }

    private static void parseVideoSampleEntry(ParsableByteArray parsableByteArray, int n, int n2, int n3, long l, int n4, StsdData stsdData, int n5) {
        parsableByteArray.setPosition(n + 8);
        parsableByteArray.skipBytes(24);
        int n6 = parsableByteArray.readUnsignedShort();
        int n7 = parsableByteArray.readUnsignedShort();
        boolean bl = false;
        float f2 = 1.0f;
        parsableByteArray.skipBytes(50);
        List<Object> list = null;
        int n8 = parsableByteArray.getPosition();
        String string = null;
        while (n8 - n < n2) {
            Object object;
            parsableByteArray.setPosition(n8);
            int n9 = parsableByteArray.getPosition();
            int n10 = parsableByteArray.readInt();
            if (n10 == 0 && parsableByteArray.getPosition() - n == n2) break;
            Assertions.checkArgument(n10 > 0, "childAtomSize should be positive");
            int n11 = parsableByteArray.readInt();
            if (n11 == Atom.TYPE_avcC) {
                Assertions.checkState(string == null);
                string = "video/avc";
                object = AtomParsers.parseAvcCFromParent(parsableByteArray, n9);
                list = object.initializationData;
                stsdData.nalUnitLengthFieldLength = object.nalUnitLengthFieldLength;
                if (!bl) {
                    f2 = object.pixelWidthAspectRatio;
                }
            } else if (n11 == Atom.TYPE_hvcC) {
                Assertions.checkState(string == null);
                string = "video/hevc";
                object = AtomParsers.parseHvcCFromParent(parsableByteArray, n9);
                list = (List<Object>)object.first;
                stsdData.nalUnitLengthFieldLength = (Integer)object.second;
            } else if (n11 == Atom.TYPE_d263) {
                Assertions.checkState(string == null);
                string = "video/3gpp";
            } else if (n11 == Atom.TYPE_esds) {
                Assertions.checkState(string == null);
                object = AtomParsers.parseEsdsFromParent(parsableByteArray, n9);
                string = (String)object.first;
                list = Collections.singletonList(object.second);
            } else if (n11 == Atom.TYPE_sinf) {
                stsdData.trackEncryptionBoxes[n5] = AtomParsers.parseSinfFromParent(parsableByteArray, n9, n10);
            } else if (n11 == Atom.TYPE_pasp) {
                f2 = AtomParsers.parsePaspFromParent(parsableByteArray, n9);
                bl = true;
            }
            n8 += n10;
        }
        if (string == null) {
            return;
        }
        stsdData.mediaFormat = MediaFormat.createVideoFormat(Integer.toString(n3), string, -1, -1, l, n6, n7, list, n4, f2);
    }

    private static AvcCData parseAvcCFromParent(ParsableByteArray parsableByteArray, int n) {
        int n2;
        parsableByteArray.setPosition(n + 8 + 4);
        int n3 = (parsableByteArray.readUnsignedByte() & 3) + 1;
        if (n3 == 3) {
            throw new IllegalStateException();
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        float f2 = 1.0f;
        int n4 = parsableByteArray.readUnsignedByte() & 0x1F;
        for (n2 = 0; n2 < n4; ++n2) {
            arrayList.add(NalUnitUtil.parseChildNalUnit(parsableByteArray));
        }
        n2 = parsableByteArray.readUnsignedByte();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(NalUnitUtil.parseChildNalUnit(parsableByteArray));
        }
        if (n4 > 0) {
            ParsableBitArray parsableBitArray = new ParsableBitArray((byte[])arrayList.get(0));
            parsableBitArray.setPosition(8 * (n3 + 1));
            f2 = NalUnitUtil.parseSpsNalUnit((ParsableBitArray)parsableBitArray).pixelWidthAspectRatio;
        }
        return new AvcCData(arrayList, n3, f2);
    }

    private static Pair<List<byte[]>, Integer> parseHvcCFromParent(ParsableByteArray parsableByteArray, int n) {
        int n2;
        int n3;
        int n4;
        parsableByteArray.setPosition(n + 8 + 21);
        int n5 = parsableByteArray.readUnsignedByte() & 3;
        int n6 = parsableByteArray.readUnsignedByte();
        int n7 = 0;
        int n8 = parsableByteArray.getPosition();
        for (int i = 0; i < n6; ++i) {
            parsableByteArray.skipBytes(1);
            n4 = parsableByteArray.readUnsignedShort();
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = parsableByteArray.readUnsignedShort();
                n7 += 4 + n2;
                parsableByteArray.skipBytes(n2);
            }
        }
        parsableByteArray.setPosition(n8);
        byte[] byArray = new byte[n7];
        n4 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            parsableByteArray.skipBytes(1);
            n2 = parsableByteArray.readUnsignedShort();
            for (int i = 0; i < n2; ++i) {
                int n9 = parsableByteArray.readUnsignedShort();
                System.arraycopy(NalUnitUtil.NAL_START_CODE, 0, byArray, n4, NalUnitUtil.NAL_START_CODE.length);
                System.arraycopy(parsableByteArray.data, parsableByteArray.getPosition(), byArray, n4 += NalUnitUtil.NAL_START_CODE.length, n9);
                n4 += n9;
                parsableByteArray.skipBytes(n9);
            }
        }
        List<byte[]> list = n7 == 0 ? null : Collections.singletonList(byArray);
        return Pair.create(list, (Object)(n5 + 1));
    }

    private static Pair<long[], long[]> parseEdts(Atom.ContainerAtom containerAtom) {
        Atom.LeafAtom leafAtom;
        if (containerAtom == null || (leafAtom = containerAtom.getLeafAtomOfType(Atom.TYPE_elst)) == null) {
            return Pair.create(null, null);
        }
        ParsableByteArray parsableByteArray = leafAtom.data;
        parsableByteArray.setPosition(8);
        int n = parsableByteArray.readInt();
        int n2 = Atom.parseFullAtomVersion(n);
        int n3 = parsableByteArray.readUnsignedIntToInt();
        long[] lArray = new long[n3];
        long[] lArray2 = new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray[i] = n2 == 1 ? parsableByteArray.readUnsignedLongToLong() : parsableByteArray.readUnsignedInt();
            lArray2[i] = n2 == 1 ? parsableByteArray.readLong() : (long)parsableByteArray.readInt();
            short s = parsableByteArray.readShort();
            if (s != 1) {
                throw new IllegalArgumentException("Unsupported media rate.");
            }
            parsableByteArray.skipBytes(2);
        }
        return Pair.create((Object)lArray, (Object)lArray2);
    }

    private static TrackEncryptionBox parseSinfFromParent(ParsableByteArray parsableByteArray, int n, int n2) {
        int n3 = n + 8;
        TrackEncryptionBox trackEncryptionBox = null;
        while (n3 - n < n2) {
            parsableByteArray.setPosition(n3);
            int n4 = parsableByteArray.readInt();
            int n5 = parsableByteArray.readInt();
            if (n5 == Atom.TYPE_frma) {
                parsableByteArray.readInt();
            } else if (n5 == Atom.TYPE_schm) {
                parsableByteArray.skipBytes(4);
                parsableByteArray.readInt();
                parsableByteArray.readInt();
            } else if (n5 == Atom.TYPE_schi) {
                trackEncryptionBox = AtomParsers.parseSchiFromParent(parsableByteArray, n3, n4);
            }
            n3 += n4;
        }
        return trackEncryptionBox;
    }

    private static float parsePaspFromParent(ParsableByteArray parsableByteArray, int n) {
        parsableByteArray.setPosition(n + 8);
        int n2 = parsableByteArray.readUnsignedIntToInt();
        int n3 = parsableByteArray.readUnsignedIntToInt();
        return (float)n2 / (float)n3;
    }

    private static TrackEncryptionBox parseSchiFromParent(ParsableByteArray parsableByteArray, int n, int n2) {
        int n3 = n + 8;
        while (n3 - n < n2) {
            parsableByteArray.setPosition(n3);
            int n4 = parsableByteArray.readInt();
            int n5 = parsableByteArray.readInt();
            if (n5 == Atom.TYPE_tenc) {
                parsableByteArray.skipBytes(4);
                int n6 = parsableByteArray.readInt();
                boolean bl = n6 >> 8 == 1;
                int n7 = n6 & 0xFF;
                byte[] byArray = new byte[16];
                parsableByteArray.readBytes(byArray, 0, byArray.length);
                return new TrackEncryptionBox(bl, n7, byArray);
            }
            n3 += n4;
        }
        return null;
    }

    private static void parseAudioSampleEntry(ParsableByteArray parsableByteArray, int n, int n2, int n3, int n4, long l, String string, boolean bl, StsdData stsdData, int n5) {
        parsableByteArray.setPosition(n2 + 8);
        int n6 = 0;
        if (bl) {
            parsableByteArray.skipBytes(8);
            n6 = parsableByteArray.readUnsignedShort();
            parsableByteArray.skipBytes(6);
        } else {
            parsableByteArray.skipBytes(16);
        }
        int n7 = parsableByteArray.readUnsignedShort();
        int n8 = parsableByteArray.readUnsignedShort();
        parsableByteArray.skipBytes(4);
        int n9 = parsableByteArray.readUnsignedFixedPoint1616();
        if (n6 > 0) {
            parsableByteArray.skipBytes(16);
            if (n6 == 2) {
                parsableByteArray.skipBytes(20);
            }
        }
        String string2 = null;
        if (n == Atom.TYPE_ac_3) {
            string2 = "audio/ac3";
        } else if (n == Atom.TYPE_ec_3) {
            string2 = "audio/eac3";
        } else if (n == Atom.TYPE_dtsc) {
            string2 = "audio/vnd.dts";
        } else if (n == Atom.TYPE_dtsh || n == Atom.TYPE_dtsl) {
            string2 = "audio/vnd.dts.hd";
        } else if (n == Atom.TYPE_dtse) {
            string2 = "audio/vnd.dts.hd;profile=lbr";
        } else if (n == Atom.TYPE_samr) {
            string2 = "audio/3gpp";
        } else if (n == Atom.TYPE_sawb) {
            string2 = "audio/amr-wb";
        }
        byte[] byArray = null;
        int n10 = parsableByteArray.getPosition();
        while (n10 - n2 < n3) {
            parsableByteArray.setPosition(n10);
            int n11 = parsableByteArray.readInt();
            Assertions.checkArgument(n11 > 0, "childAtomSize should be positive");
            int n12 = parsableByteArray.readInt();
            if (n == Atom.TYPE_mp4a || n == Atom.TYPE_enca) {
                int n13 = -1;
                if (n12 == Atom.TYPE_esds) {
                    n13 = n10;
                } else if (bl && n12 == Atom.TYPE_wave) {
                    n13 = AtomParsers.findEsdsPosition(parsableByteArray, n10, n11);
                }
                if (n13 != -1) {
                    Pair<String, byte[]> pair = AtomParsers.parseEsdsFromParent(parsableByteArray, n13);
                    string2 = (String)pair.first;
                    byArray = (byte[])pair.second;
                    if ("audio/mp4a-latm".equals(string2)) {
                        Pair<Integer, Integer> pair2 = CodecSpecificDataUtil.parseAacAudioSpecificConfig(byArray);
                        n9 = (Integer)pair2.first;
                        n7 = (Integer)pair2.second;
                    }
                } else if (n12 == Atom.TYPE_sinf) {
                    stsdData.trackEncryptionBoxes[n5] = AtomParsers.parseSinfFromParent(parsableByteArray, n10, n11);
                }
            } else {
                if (n == Atom.TYPE_ac_3 && n12 == Atom.TYPE_dac3) {
                    parsableByteArray.setPosition(8 + n10);
                    stsdData.mediaFormat = Ac3Util.parseAc3AnnexFFormat(parsableByteArray, Integer.toString(n4), l, string);
                    return;
                }
                if (n == Atom.TYPE_ec_3 && n12 == Atom.TYPE_dec3) {
                    parsableByteArray.setPosition(8 + n10);
                    stsdData.mediaFormat = Ac3Util.parseEAc3AnnexFFormat(parsableByteArray, Integer.toString(n4), l, string);
                    return;
                }
                if ((n == Atom.TYPE_dtsc || n == Atom.TYPE_dtse || n == Atom.TYPE_dtsh || n == Atom.TYPE_dtsl) && n12 == Atom.TYPE_ddts) {
                    stsdData.mediaFormat = MediaFormat.createAudioFormat(Integer.toString(n4), string2, -1, -1, l, n7, n9, null, string);
                    return;
                }
            }
            n10 += n11;
        }
        if (string2 == null) {
            return;
        }
        stsdData.mediaFormat = MediaFormat.createAudioFormat(Integer.toString(n4), string2, -1, n8, l, n7, n9, byArray == null ? null : Collections.singletonList(byArray), string);
    }

    private static int findEsdsPosition(ParsableByteArray parsableByteArray, int n, int n2) {
        int n3 = parsableByteArray.getPosition();
        while (n3 - n < n2) {
            parsableByteArray.setPosition(n3);
            int n4 = parsableByteArray.readInt();
            Assertions.checkArgument(n4 > 0, "childAtomSize should be positive");
            int n5 = parsableByteArray.readInt();
            if (n5 == Atom.TYPE_esds) {
                return n3;
            }
            n3 += n4;
        }
        return -1;
    }

    private static Pair<String, byte[]> parseEsdsFromParent(ParsableByteArray parsableByteArray, int n) {
        String string;
        parsableByteArray.setPosition(n + 8 + 4);
        parsableByteArray.skipBytes(1);
        AtomParsers.parseExpandableClassSize(parsableByteArray);
        parsableByteArray.skipBytes(2);
        int n2 = parsableByteArray.readUnsignedByte();
        if ((n2 & 0x80) != 0) {
            parsableByteArray.skipBytes(2);
        }
        if ((n2 & 0x40) != 0) {
            parsableByteArray.skipBytes(parsableByteArray.readUnsignedShort());
        }
        if ((n2 & 0x20) != 0) {
            parsableByteArray.skipBytes(2);
        }
        parsableByteArray.skipBytes(1);
        AtomParsers.parseExpandableClassSize(parsableByteArray);
        int n3 = parsableByteArray.readUnsignedByte();
        switch (n3) {
            case 107: {
                String string2 = "audio/mpeg";
                return Pair.create((Object)string2, null);
            }
            case 32: {
                string = "video/mp4v-es";
                break;
            }
            case 33: {
                string = "video/avc";
                break;
            }
            case 35: {
                string = "video/hevc";
                break;
            }
            case 64: 
            case 102: 
            case 103: 
            case 104: {
                string = "audio/mp4a-latm";
                break;
            }
            case 165: {
                string = "audio/ac3";
                break;
            }
            case 166: {
                string = "audio/eac3";
                break;
            }
            case 169: 
            case 172: {
                String string3 = "audio/vnd.dts";
                return Pair.create((Object)string3, null);
            }
            case 170: 
            case 171: {
                String string4 = "audio/vnd.dts.hd";
                return Pair.create((Object)string4, null);
            }
            default: {
                string = null;
            }
        }
        parsableByteArray.skipBytes(12);
        parsableByteArray.skipBytes(1);
        int n4 = AtomParsers.parseExpandableClassSize(parsableByteArray);
        byte[] byArray = new byte[n4];
        parsableByteArray.readBytes(byArray, 0, n4);
        return Pair.create((Object)string, (Object)byArray);
    }

    private static int parseExpandableClassSize(ParsableByteArray parsableByteArray) {
        int n = parsableByteArray.readUnsignedByte();
        int n2 = n & 0x7F;
        while ((n & 0x80) == 128) {
            n = parsableByteArray.readUnsignedByte();
            n2 = n2 << 7 | n & 0x7F;
        }
        return n2;
    }

    private AtomParsers() {
    }

    private static final class AvcCData {
        public final List<byte[]> initializationData;
        public final int nalUnitLengthFieldLength;
        public final float pixelWidthAspectRatio;

        public AvcCData(List<byte[]> list, int n, float f2) {
            this.initializationData = list;
            this.nalUnitLengthFieldLength = n;
            this.pixelWidthAspectRatio = f2;
        }
    }

    private static final class StsdData {
        public final TrackEncryptionBox[] trackEncryptionBoxes;
        public MediaFormat mediaFormat;
        public int nalUnitLengthFieldLength;

        public StsdData(int n) {
            this.trackEncryptionBoxes = new TrackEncryptionBox[n];
            this.nalUnitLengthFieldLength = -1;
        }
    }

    private static final class TkhdData {
        private final int id;
        private final long duration;
        private final int rotationDegrees;

        public TkhdData(int n, long l, int n2) {
            this.id = n;
            this.duration = l;
            this.rotationDegrees = n2;
        }
    }
}

