/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class Atom {
    public static final int HEADER_SIZE = 8;
    public static final int FULL_HEADER_SIZE = 12;
    public static final int LONG_HEADER_SIZE = 16;
    public static final int LONG_SIZE_PREFIX = 1;
    public static final int TYPE_ftyp = Util.getIntegerCodeForString("ftyp");
    public static final int TYPE_avc1 = Util.getIntegerCodeForString("avc1");
    public static final int TYPE_avc3 = Util.getIntegerCodeForString("avc3");
    public static final int TYPE_hvc1 = Util.getIntegerCodeForString("hvc1");
    public static final int TYPE_hev1 = Util.getIntegerCodeForString("hev1");
    public static final int TYPE_s263 = Util.getIntegerCodeForString("s263");
    public static final int TYPE_d263 = Util.getIntegerCodeForString("d263");
    public static final int TYPE_mdat = Util.getIntegerCodeForString("mdat");
    public static final int TYPE_mp4a = Util.getIntegerCodeForString("mp4a");
    public static final int TYPE_wave = Util.getIntegerCodeForString("wave");
    public static final int TYPE_ac_3 = Util.getIntegerCodeForString("ac-3");
    public static final int TYPE_dac3 = Util.getIntegerCodeForString("dac3");
    public static final int TYPE_ec_3 = Util.getIntegerCodeForString("ec-3");
    public static final int TYPE_dec3 = Util.getIntegerCodeForString("dec3");
    public static final int TYPE_dtsc = Util.getIntegerCodeForString("dtsc");
    public static final int TYPE_dtsh = Util.getIntegerCodeForString("dtsh");
    public static final int TYPE_dtsl = Util.getIntegerCodeForString("dtsl");
    public static final int TYPE_dtse = Util.getIntegerCodeForString("dtse");
    public static final int TYPE_ddts = Util.getIntegerCodeForString("ddts");
    public static final int TYPE_tfdt = Util.getIntegerCodeForString("tfdt");
    public static final int TYPE_tfhd = Util.getIntegerCodeForString("tfhd");
    public static final int TYPE_trex = Util.getIntegerCodeForString("trex");
    public static final int TYPE_trun = Util.getIntegerCodeForString("trun");
    public static final int TYPE_sidx = Util.getIntegerCodeForString("sidx");
    public static final int TYPE_moov = Util.getIntegerCodeForString("moov");
    public static final int TYPE_mvhd = Util.getIntegerCodeForString("mvhd");
    public static final int TYPE_trak = Util.getIntegerCodeForString("trak");
    public static final int TYPE_mdia = Util.getIntegerCodeForString("mdia");
    public static final int TYPE_minf = Util.getIntegerCodeForString("minf");
    public static final int TYPE_stbl = Util.getIntegerCodeForString("stbl");
    public static final int TYPE_avcC = Util.getIntegerCodeForString("avcC");
    public static final int TYPE_hvcC = Util.getIntegerCodeForString("hvcC");
    public static final int TYPE_esds = Util.getIntegerCodeForString("esds");
    public static final int TYPE_moof = Util.getIntegerCodeForString("moof");
    public static final int TYPE_traf = Util.getIntegerCodeForString("traf");
    public static final int TYPE_mvex = Util.getIntegerCodeForString("mvex");
    public static final int TYPE_tkhd = Util.getIntegerCodeForString("tkhd");
    public static final int TYPE_edts = Util.getIntegerCodeForString("edts");
    public static final int TYPE_elst = Util.getIntegerCodeForString("elst");
    public static final int TYPE_mdhd = Util.getIntegerCodeForString("mdhd");
    public static final int TYPE_hdlr = Util.getIntegerCodeForString("hdlr");
    public static final int TYPE_stsd = Util.getIntegerCodeForString("stsd");
    public static final int TYPE_pssh = Util.getIntegerCodeForString("pssh");
    public static final int TYPE_sinf = Util.getIntegerCodeForString("sinf");
    public static final int TYPE_schm = Util.getIntegerCodeForString("schm");
    public static final int TYPE_schi = Util.getIntegerCodeForString("schi");
    public static final int TYPE_tenc = Util.getIntegerCodeForString("tenc");
    public static final int TYPE_encv = Util.getIntegerCodeForString("encv");
    public static final int TYPE_enca = Util.getIntegerCodeForString("enca");
    public static final int TYPE_frma = Util.getIntegerCodeForString("frma");
    public static final int TYPE_saiz = Util.getIntegerCodeForString("saiz");
    public static final int TYPE_saio = Util.getIntegerCodeForString("saio");
    public static final int TYPE_uuid = Util.getIntegerCodeForString("uuid");
    public static final int TYPE_senc = Util.getIntegerCodeForString("senc");
    public static final int TYPE_pasp = Util.getIntegerCodeForString("pasp");
    public static final int TYPE_TTML = Util.getIntegerCodeForString("TTML");
    public static final int TYPE_vmhd = Util.getIntegerCodeForString("vmhd");
    public static final int TYPE_mp4v = Util.getIntegerCodeForString("mp4v");
    public static final int TYPE_stts = Util.getIntegerCodeForString("stts");
    public static final int TYPE_stss = Util.getIntegerCodeForString("stss");
    public static final int TYPE_ctts = Util.getIntegerCodeForString("ctts");
    public static final int TYPE_stsc = Util.getIntegerCodeForString("stsc");
    public static final int TYPE_stsz = Util.getIntegerCodeForString("stsz");
    public static final int TYPE_stco = Util.getIntegerCodeForString("stco");
    public static final int TYPE_co64 = Util.getIntegerCodeForString("co64");
    public static final int TYPE_tx3g = Util.getIntegerCodeForString("tx3g");
    public static final int TYPE_wvtt = Util.getIntegerCodeForString("wvtt");
    public static final int TYPE_stpp = Util.getIntegerCodeForString("stpp");
    public static final int TYPE_samr = Util.getIntegerCodeForString("samr");
    public static final int TYPE_sawb = Util.getIntegerCodeForString("sawb");
    public static final int TYPE_udta = Util.getIntegerCodeForString("udta");
    public static final int TYPE_meta = Util.getIntegerCodeForString("meta");
    public static final int TYPE_ilst = Util.getIntegerCodeForString("ilst");
    public static final int TYPE_mean = Util.getIntegerCodeForString("mean");
    public static final int TYPE_name = Util.getIntegerCodeForString("name");
    public static final int TYPE_data = Util.getIntegerCodeForString("data");
    public static final int TYPE_DASHES = Util.getIntegerCodeForString("----");
    public final int type;

    public Atom(int n) {
        this.type = n;
    }

    public String toString() {
        return Atom.getAtomTypeString(this.type);
    }

    public static int parseFullAtomVersion(int n) {
        return 0xFF & n >> 24;
    }

    public static int parseFullAtomFlags(int n) {
        return 0xFFFFFF & n;
    }

    public static String getAtomTypeString(int n) {
        return "" + (char)(n >> 24) + (char)(n >> 16 & 0xFF) + (char)(n >> 8 & 0xFF) + (char)(n & 0xFF);
    }

    static final class ContainerAtom
    extends Atom {
        public final long endPosition;
        public final List<LeafAtom> leafChildren;
        public final List<ContainerAtom> containerChildren;

        public ContainerAtom(int n, long l) {
            super(n);
            this.endPosition = l;
            this.leafChildren = new ArrayList<LeafAtom>();
            this.containerChildren = new ArrayList<ContainerAtom>();
        }

        public void add(LeafAtom leafAtom) {
            this.leafChildren.add(leafAtom);
        }

        public void add(ContainerAtom containerAtom) {
            this.containerChildren.add(containerAtom);
        }

        public LeafAtom getLeafAtomOfType(int n) {
            int n2 = this.leafChildren.size();
            for (int i = 0; i < n2; ++i) {
                LeafAtom leafAtom = this.leafChildren.get(i);
                if (leafAtom.type != n) continue;
                return leafAtom;
            }
            return null;
        }

        public ContainerAtom getContainerAtomOfType(int n) {
            int n2 = this.containerChildren.size();
            for (int i = 0; i < n2; ++i) {
                ContainerAtom containerAtom = this.containerChildren.get(i);
                if (containerAtom.type != n) continue;
                return containerAtom;
            }
            return null;
        }

        public int getChildAtomOfTypeCount(int n) {
            Atom atom;
            int n2;
            int n3 = 0;
            int n4 = this.leafChildren.size();
            for (n2 = 0; n2 < n4; ++n2) {
                atom = this.leafChildren.get(n2);
                if (atom.type != n) continue;
                ++n3;
            }
            n4 = this.containerChildren.size();
            for (n2 = 0; n2 < n4; ++n2) {
                atom = this.containerChildren.get(n2);
                if (((ContainerAtom)atom).type != n) continue;
                ++n3;
            }
            return n3;
        }

        @Override
        public String toString() {
            return ContainerAtom.getAtomTypeString(this.type) + " leaves: " + Arrays.toString(this.leafChildren.toArray(new LeafAtom[0])) + " containers: " + Arrays.toString(this.containerChildren.toArray(new ContainerAtom[0]));
        }
    }

    static final class LeafAtom
    extends Atom {
        public final ParsableByteArray data;

        public LeafAtom(int n, ParsableByteArray parsableByteArray) {
            super(n);
            this.data = parsableByteArray;
        }
    }
}

