/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor;

import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.upstream.Allocation;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingDeque;

final class RollingSampleBuffer {
    private static final int INITIAL_SCRATCH_SIZE = 32;
    private final Allocator allocator;
    private final int allocationLength;
    private final InfoQueue infoQueue;
    private final LinkedBlockingDeque<Allocation> dataQueue;
    private final SampleExtrasHolder extrasHolder;
    private final ParsableByteArray scratch;
    private long totalBytesDropped;
    private long totalBytesWritten;
    private Allocation lastAllocation;
    private int lastAllocationOffset;

    public RollingSampleBuffer(Allocator allocator) {
        this.allocator = allocator;
        this.allocationLength = allocator.getIndividualAllocationLength();
        this.infoQueue = new InfoQueue();
        this.dataQueue = new LinkedBlockingDeque();
        this.extrasHolder = new SampleExtrasHolder();
        this.scratch = new ParsableByteArray(32);
        this.lastAllocationOffset = this.allocationLength;
    }

    public void clear() {
        this.infoQueue.clear();
        while (!this.dataQueue.isEmpty()) {
            this.allocator.release(this.dataQueue.remove());
        }
        this.totalBytesDropped = 0L;
        this.totalBytesWritten = 0L;
        this.lastAllocation = null;
        this.lastAllocationOffset = this.allocationLength;
    }

    public int getWriteIndex() {
        return this.infoQueue.getWriteIndex();
    }

    public void discardUpstreamSamples(int n) {
        this.totalBytesWritten = this.infoQueue.discardUpstreamSamples(n);
        this.dropUpstreamFrom(this.totalBytesWritten);
    }

    private void dropUpstreamFrom(long l) {
        int n = (int)(l - this.totalBytesDropped);
        int n2 = n / this.allocationLength;
        int n3 = n % this.allocationLength;
        int n4 = this.dataQueue.size() - n2 - 1;
        if (n3 == 0) {
            ++n4;
        }
        for (int i = 0; i < n4; ++i) {
            this.allocator.release(this.dataQueue.removeLast());
        }
        this.lastAllocation = this.dataQueue.peekLast();
        this.lastAllocationOffset = n3 == 0 ? this.allocationLength : n3;
    }

    public int getReadIndex() {
        return this.infoQueue.getReadIndex();
    }

    public boolean peekSample(SampleHolder sampleHolder) {
        return this.infoQueue.peekSample(sampleHolder, this.extrasHolder);
    }

    public void skipSample() {
        long l = this.infoQueue.moveToNextSample();
        this.dropDownstreamTo(l);
    }

    public boolean skipToKeyframeBefore(long l) {
        long l2 = this.infoQueue.skipToKeyframeBefore(l);
        if (l2 == -1L) {
            return false;
        }
        this.dropDownstreamTo(l2);
        return true;
    }

    public boolean readSample(SampleHolder sampleHolder) {
        boolean bl = this.infoQueue.peekSample(sampleHolder, this.extrasHolder);
        if (!bl) {
            return false;
        }
        if (sampleHolder.isEncrypted()) {
            this.readEncryptionData(sampleHolder, this.extrasHolder);
        }
        sampleHolder.ensureSpaceForWrite(sampleHolder.size);
        this.readData(this.extrasHolder.offset, sampleHolder.data, sampleHolder.size);
        long l = this.infoQueue.moveToNextSample();
        this.dropDownstreamTo(l);
        return true;
    }

    private void readEncryptionData(SampleHolder sampleHolder, SampleExtrasHolder sampleExtrasHolder) {
        int n;
        int[] nArray;
        int n2;
        long l = sampleExtrasHolder.offset;
        this.readData(l, this.scratch.data, 1);
        ++l;
        byte by = this.scratch.data[0];
        boolean bl = (by & 0x80) != 0;
        int n3 = by & 0x7F;
        if (sampleHolder.cryptoInfo.iv == null) {
            sampleHolder.cryptoInfo.iv = new byte[16];
        }
        this.readData(l, sampleHolder.cryptoInfo.iv, n3);
        l += (long)n3;
        if (bl) {
            this.readData(l, this.scratch.data, 2);
            l += 2L;
            this.scratch.setPosition(0);
            n2 = this.scratch.readUnsignedShort();
        } else {
            n2 = 1;
        }
        int[] nArray2 = sampleHolder.cryptoInfo.numBytesOfClearData;
        if (nArray2 == null || nArray2.length < n2) {
            nArray2 = new int[n2];
        }
        if ((nArray = sampleHolder.cryptoInfo.numBytesOfEncryptedData) == null || nArray.length < n2) {
            nArray = new int[n2];
        }
        if (bl) {
            n = 6 * n2;
            RollingSampleBuffer.ensureCapacity(this.scratch, n);
            this.readData(l, this.scratch.data, n);
            l += (long)n;
            this.scratch.setPosition(0);
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = this.scratch.readUnsignedShort();
                nArray[i] = this.scratch.readUnsignedIntToInt();
            }
        } else {
            nArray2[0] = 0;
            nArray[0] = sampleHolder.size - (int)(l - sampleExtrasHolder.offset);
        }
        sampleHolder.cryptoInfo.set(n2, nArray2, nArray, sampleExtrasHolder.encryptionKeyId, sampleHolder.cryptoInfo.iv, 1);
        n = (int)(l - sampleExtrasHolder.offset);
        sampleExtrasHolder.offset += (long)n;
        sampleHolder.size -= n;
    }

    private void readData(long l, ByteBuffer byteBuffer, int n) {
        int n2;
        for (int i = n; i > 0; i -= n2) {
            this.dropDownstreamTo(l);
            int n3 = (int)(l - this.totalBytesDropped);
            n2 = Math.min(i, this.allocationLength - n3);
            Allocation allocation = this.dataQueue.peek();
            byteBuffer.put(allocation.data, allocation.translateOffset(n3), n2);
            l += (long)n2;
        }
    }

    private void readData(long l, byte[] byArray, int n) {
        int n2;
        for (int i = 0; i < n; i += n2) {
            this.dropDownstreamTo(l);
            int n3 = (int)(l - this.totalBytesDropped);
            n2 = Math.min(n - i, this.allocationLength - n3);
            Allocation allocation = this.dataQueue.peek();
            System.arraycopy(allocation.data, allocation.translateOffset(n3), byArray, i, n2);
            l += (long)n2;
        }
    }

    private void dropDownstreamTo(long l) {
        int n = (int)(l - this.totalBytesDropped);
        int n2 = n / this.allocationLength;
        for (int i = 0; i < n2; ++i) {
            this.allocator.release(this.dataQueue.remove());
            this.totalBytesDropped += (long)this.allocationLength;
        }
    }

    private static void ensureCapacity(ParsableByteArray parsableByteArray, int n) {
        if (parsableByteArray.limit() < n) {
            parsableByteArray.reset(new byte[n], n);
        }
    }

    public long getWritePosition() {
        return this.totalBytesWritten;
    }

    public int appendData(DataSource dataSource, int n, boolean bl) throws IOException {
        n = this.prepareForAppend(n);
        int n2 = dataSource.read(this.lastAllocation.data, this.lastAllocation.translateOffset(this.lastAllocationOffset), n);
        if (n2 == -1) {
            if (bl) {
                return -1;
            }
            throw new EOFException();
        }
        this.lastAllocationOffset += n2;
        this.totalBytesWritten += (long)n2;
        return n2;
    }

    public int appendData(ExtractorInput extractorInput, int n, boolean bl) throws IOException, InterruptedException {
        n = this.prepareForAppend(n);
        int n2 = extractorInput.read(this.lastAllocation.data, this.lastAllocation.translateOffset(this.lastAllocationOffset), n);
        if (n2 == -1) {
            if (bl) {
                return -1;
            }
            throw new EOFException();
        }
        this.lastAllocationOffset += n2;
        this.totalBytesWritten += (long)n2;
        return n2;
    }

    public void appendData(ParsableByteArray parsableByteArray, int n) {
        while (n > 0) {
            int n2 = this.prepareForAppend(n);
            parsableByteArray.readBytes(this.lastAllocation.data, this.lastAllocation.translateOffset(this.lastAllocationOffset), n2);
            this.lastAllocationOffset += n2;
            this.totalBytesWritten += (long)n2;
            n -= n2;
        }
    }

    public void commitSample(long l, int n, long l2, int n2, byte[] byArray) {
        this.infoQueue.commitSample(l, n, l2, n2, byArray);
    }

    private int prepareForAppend(int n) {
        if (this.lastAllocationOffset == this.allocationLength) {
            this.lastAllocationOffset = 0;
            this.lastAllocation = this.allocator.allocate();
            this.dataQueue.add(this.lastAllocation);
        }
        return Math.min(n, this.allocationLength - this.lastAllocationOffset);
    }

    private static final class SampleExtrasHolder {
        public long offset;
        public byte[] encryptionKeyId;

        private SampleExtrasHolder() {
        }
    }

    private static final class InfoQueue {
        private static final int SAMPLE_CAPACITY_INCREMENT = 1000;
        private int capacity = 1000;
        private long[] offsets = new long[this.capacity];
        private int[] sizes;
        private int[] flags;
        private long[] timesUs = new long[this.capacity];
        private byte[][] encryptionKeys;
        private int queueSize;
        private int absoluteReadIndex;
        private int relativeReadIndex;
        private int relativeWriteIndex;

        public InfoQueue() {
            this.flags = new int[this.capacity];
            this.sizes = new int[this.capacity];
            this.encryptionKeys = new byte[this.capacity][];
        }

        public void clear() {
            this.absoluteReadIndex = 0;
            this.relativeReadIndex = 0;
            this.relativeWriteIndex = 0;
            this.queueSize = 0;
        }

        public int getWriteIndex() {
            return this.absoluteReadIndex + this.queueSize;
        }

        public long discardUpstreamSamples(int n) {
            int n2 = this.getWriteIndex() - n;
            Assertions.checkArgument(0 <= n2 && n2 <= this.queueSize);
            if (n2 == 0) {
                if (this.absoluteReadIndex == 0) {
                    return 0L;
                }
                int n3 = (this.relativeWriteIndex == 0 ? this.capacity : this.relativeWriteIndex) - 1;
                return this.offsets[n3] + (long)this.sizes[n3];
            }
            this.queueSize -= n2;
            this.relativeWriteIndex = (this.relativeWriteIndex + this.capacity - n2) % this.capacity;
            return this.offsets[this.relativeWriteIndex];
        }

        public int getReadIndex() {
            return this.absoluteReadIndex;
        }

        public synchronized boolean peekSample(SampleHolder sampleHolder, SampleExtrasHolder sampleExtrasHolder) {
            if (this.queueSize == 0) {
                return false;
            }
            sampleHolder.timeUs = this.timesUs[this.relativeReadIndex];
            sampleHolder.size = this.sizes[this.relativeReadIndex];
            sampleHolder.flags = this.flags[this.relativeReadIndex];
            sampleExtrasHolder.offset = this.offsets[this.relativeReadIndex];
            sampleExtrasHolder.encryptionKeyId = this.encryptionKeys[this.relativeReadIndex];
            return true;
        }

        public synchronized long moveToNextSample() {
            --this.queueSize;
            int n = this.relativeReadIndex++;
            ++this.absoluteReadIndex;
            if (this.relativeReadIndex == this.capacity) {
                this.relativeReadIndex = 0;
            }
            return this.queueSize > 0 ? this.offsets[this.relativeReadIndex] : (long)this.sizes[n] + this.offsets[n];
        }

        public synchronized long skipToKeyframeBefore(long l) {
            if (this.queueSize == 0 || l < this.timesUs[this.relativeReadIndex]) {
                return -1L;
            }
            int n = (this.relativeWriteIndex == 0 ? this.capacity : this.relativeWriteIndex) - 1;
            long l2 = this.timesUs[n];
            if (l > l2) {
                return -1L;
            }
            int n2 = 0;
            int n3 = -1;
            int n4 = this.relativeReadIndex;
            while (n4 != this.relativeWriteIndex && this.timesUs[n4] <= l) {
                if ((this.flags[n4] & 1) != 0) {
                    n3 = n2;
                }
                n4 = (n4 + 1) % this.capacity;
                ++n2;
            }
            if (n3 == -1) {
                return -1L;
            }
            this.queueSize -= n3;
            this.relativeReadIndex = (this.relativeReadIndex + n3) % this.capacity;
            this.absoluteReadIndex += n3;
            return this.offsets[this.relativeReadIndex];
        }

        public synchronized void commitSample(long l, int n, long l2, int n2, byte[] byArray) {
            this.timesUs[this.relativeWriteIndex] = l;
            this.offsets[this.relativeWriteIndex] = l2;
            this.sizes[this.relativeWriteIndex] = n2;
            this.flags[this.relativeWriteIndex] = n;
            this.encryptionKeys[this.relativeWriteIndex] = byArray;
            ++this.queueSize;
            if (this.queueSize == this.capacity) {
                int n3 = this.capacity + 1000;
                long[] lArray = new long[n3];
                long[] lArray2 = new long[n3];
                int[] nArray = new int[n3];
                int[] nArray2 = new int[n3];
                byte[][] byArrayArray = new byte[n3][];
                int n4 = this.capacity - this.relativeReadIndex;
                System.arraycopy(this.offsets, this.relativeReadIndex, lArray, 0, n4);
                System.arraycopy(this.timesUs, this.relativeReadIndex, lArray2, 0, n4);
                System.arraycopy(this.flags, this.relativeReadIndex, nArray, 0, n4);
                System.arraycopy(this.sizes, this.relativeReadIndex, nArray2, 0, n4);
                System.arraycopy(this.encryptionKeys, this.relativeReadIndex, byArrayArray, 0, n4);
                int n5 = this.relativeReadIndex;
                System.arraycopy(this.offsets, 0, lArray, n4, n5);
                System.arraycopy(this.timesUs, 0, lArray2, n4, n5);
                System.arraycopy(this.flags, 0, nArray, n4, n5);
                System.arraycopy(this.sizes, 0, nArray2, n4, n5);
                System.arraycopy(this.encryptionKeys, 0, byArrayArray, n4, n5);
                this.offsets = lArray;
                this.timesUs = lArray2;
                this.flags = nArray;
                this.sizes = nArray2;
                this.encryptionKeys = byArrayArray;
                this.relativeReadIndex = 0;
                this.relativeWriteIndex = this.capacity;
                this.queueSize = this.capacity;
                this.capacity = n3;
            } else {
                ++this.relativeWriteIndex;
                if (this.relativeWriteIndex == this.capacity) {
                    this.relativeWriteIndex = 0;
                }
            }
        }
    }
}

