/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.drm;

import com.google.android.exoplayer.util.Assertions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public interface DrmInitData {
    public SchemeInitData get(UUID var1);

    public static final class SchemeInitData {
        public final String mimeType;
        public final byte[] data;

        public SchemeInitData(String string, byte[] byArray) {
            this.mimeType = Assertions.checkNotNull(string);
            this.data = Assertions.checkNotNull(byArray);
        }

        public boolean equals(Object object) {
            if (!(object instanceof SchemeInitData)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            SchemeInitData schemeInitData = (SchemeInitData)object;
            return this.mimeType.equals(schemeInitData.mimeType) && Arrays.equals(this.data, schemeInitData.data);
        }

        public int hashCode() {
            return this.mimeType.hashCode() + 31 * Arrays.hashCode(this.data);
        }
    }

    public static final class Universal
    implements DrmInitData {
        private SchemeInitData data;

        public Universal(SchemeInitData schemeInitData) {
            this.data = schemeInitData;
        }

        @Override
        public SchemeInitData get(UUID uUID) {
            return this.data;
        }
    }

    public static final class Mapped
    implements DrmInitData {
        private final Map<UUID, SchemeInitData> schemeData = new HashMap<UUID, SchemeInitData>();

        @Override
        public SchemeInitData get(UUID uUID) {
            return this.schemeData.get(uUID);
        }

        public void put(UUID uUID, SchemeInitData schemeInitData) {
            this.schemeData.put(uUID, schemeInitData);
        }
    }
}

