/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import com.google.android.exoplayer.util.Clock;

public interface TimeRange {
    public boolean isStatic();

    public long[] getCurrentBoundsMs(long[] var1);

    public long[] getCurrentBoundsUs(long[] var1);

    public static final class DynamicTimeRange
    implements TimeRange {
        private final long minStartTimeUs;
        private final long maxEndTimeUs;
        private final long elapsedRealtimeAtStartUs;
        private final long bufferDepthUs;
        private final Clock systemClock;

        public DynamicTimeRange(long l, long l2, long l3, long l4, Clock clock) {
            this.minStartTimeUs = l;
            this.maxEndTimeUs = l2;
            this.elapsedRealtimeAtStartUs = l3;
            this.bufferDepthUs = l4;
            this.systemClock = clock;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public long[] getCurrentBoundsMs(long[] lArray) {
            lArray = this.getCurrentBoundsUs(lArray);
            lArray[0] = lArray[0] / 1000L;
            lArray[1] = lArray[1] / 1000L;
            return lArray;
        }

        @Override
        public long[] getCurrentBoundsUs(long[] lArray) {
            if (lArray == null || lArray.length < 2) {
                lArray = new long[2];
            }
            long l = Math.min(this.maxEndTimeUs, this.systemClock.elapsedRealtime() * 1000L - this.elapsedRealtimeAtStartUs);
            long l2 = this.minStartTimeUs;
            if (this.bufferDepthUs != -1L) {
                l2 = Math.max(l2, l - this.bufferDepthUs);
            }
            lArray[0] = l2;
            lArray[1] = l;
            return lArray;
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + (int)this.minStartTimeUs;
            n = 31 * n + (int)this.maxEndTimeUs;
            n = 31 * n + (int)this.elapsedRealtimeAtStartUs;
            n = 31 * n + (int)this.bufferDepthUs;
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DynamicTimeRange dynamicTimeRange = (DynamicTimeRange)object;
            return dynamicTimeRange.minStartTimeUs == this.minStartTimeUs && dynamicTimeRange.maxEndTimeUs == this.maxEndTimeUs && dynamicTimeRange.elapsedRealtimeAtStartUs == this.elapsedRealtimeAtStartUs && dynamicTimeRange.bufferDepthUs == this.bufferDepthUs;
        }
    }

    public static final class StaticTimeRange
    implements TimeRange {
        private final long startTimeUs;
        private final long endTimeUs;

        public StaticTimeRange(long l, long l2) {
            this.startTimeUs = l;
            this.endTimeUs = l2;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public long[] getCurrentBoundsMs(long[] lArray) {
            lArray = this.getCurrentBoundsUs(lArray);
            lArray[0] = lArray[0] / 1000L;
            lArray[1] = lArray[1] / 1000L;
            return lArray;
        }

        @Override
        public long[] getCurrentBoundsUs(long[] lArray) {
            if (lArray == null || lArray.length < 2) {
                lArray = new long[]{this.startTimeUs, this.endTimeUs};
            }
            return lArray;
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + (int)this.startTimeUs;
            n = 31 * n + (int)this.endTimeUs;
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StaticTimeRange staticTimeRange = (StaticTimeRange)object;
            return staticTimeRange.startTimeUs == this.startTimeUs && staticTimeRange.endTimeUs == this.endTimeUs;
        }
    }
}

