/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.util.ParsableBitArray;
import java.nio.ByteBuffer;

public final class DtsUtil {
    private static final int[] CHANNELS_BY_AMODE = new int[]{1, 2, 2, 2, 2, 3, 3, 4, 4, 5, 6, 6, 6, 7, 8, 8};
    private static final int[] SAMPLE_RATE_BY_SFREQ = new int[]{-1, 8000, 16000, 32000, -1, -1, 11025, 22050, 44100, -1, -1, 12000, 24000, 48000, -1, -1};
    private static final int[] TWICE_BITRATE_KBPS_BY_RATE = new int[]{64, 112, 128, 192, 224, 256, 384, 448, 512, 640, 768, 896, 1024, 1152, 1280, 1536, 1920, 2048, 2304, 2560, 2688, 2816, 2823, 2944, 3072, 3840, 4096, 6144, 7680};
    private static final ParsableBitArray SCRATCH_BITS = new ParsableBitArray();

    public static MediaFormat parseDtsFormat(byte[] byArray, String string, long l, String string2) {
        ParsableBitArray parsableBitArray = SCRATCH_BITS;
        parsableBitArray.reset(byArray);
        parsableBitArray.skipBits(60);
        int n = parsableBitArray.readBits(6);
        int n2 = CHANNELS_BY_AMODE[n];
        int n3 = parsableBitArray.readBits(4);
        int n4 = SAMPLE_RATE_BY_SFREQ[n3];
        int n5 = parsableBitArray.readBits(5);
        int n6 = n5 >= TWICE_BITRATE_KBPS_BY_RATE.length ? -1 : TWICE_BITRATE_KBPS_BY_RATE[n5] * 1000 / 2;
        parsableBitArray.skipBits(10);
        return MediaFormat.createAudioFormat(string, "audio/vnd.dts", n6, -1, l, n2 += parsableBitArray.readBits(2) > 0 ? 1 : 0, n4, null, string2);
    }

    public static int parseDtsAudioSampleCount(byte[] byArray) {
        int n = (byArray[4] & 1) << 6 | (byArray[5] & 0xFC) >> 2;
        return (n + 1) * 32;
    }

    public static int parseDtsAudioSampleCount(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = (byteBuffer.get(n + 4) & 1) << 6 | (byteBuffer.get(n + 5) & 0xFC) >> 2;
        return (n2 + 1) * 32;
    }

    public static int getDtsFrameSize(byte[] byArray) {
        return ((byArray[5] & 2) << 12 | (byArray[6] & 0xFF) << 4 | (byArray[7] & 0xF0) >> 4) + 1;
    }

    private DtsUtil() {
    }
}

