/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public final class UdpDataSource
implements UriDataSource {
    public static final int DEFAULT_MAX_PACKET_SIZE = 2000;
    public static final int DEAFULT_SOCKET_TIMEOUT_MILLIS = 8000;
    private final TransferListener listener;
    private final DatagramPacket packet;
    private final int socketTimeoutMillis;
    private DataSpec dataSpec;
    private DatagramSocket socket;
    private MulticastSocket multicastSocket;
    private InetAddress address;
    private InetSocketAddress socketAddress;
    private boolean opened;
    private byte[] packetBuffer;
    private int packetRemaining;

    public UdpDataSource(TransferListener transferListener) {
        this(transferListener, 2000);
    }

    public UdpDataSource(TransferListener transferListener, int n) {
        this(transferListener, n, 8000);
    }

    public UdpDataSource(TransferListener transferListener, int n, int n2) {
        this.listener = transferListener;
        this.socketTimeoutMillis = n2;
        this.packetBuffer = new byte[n];
        this.packet = new DatagramPacket(this.packetBuffer, 0, n);
    }

    @Override
    public long open(DataSpec dataSpec) throws UdpDataSourceException {
        this.dataSpec = dataSpec;
        String string = dataSpec.uri.getHost();
        int n = dataSpec.uri.getPort();
        try {
            this.address = InetAddress.getByName(string);
            this.socketAddress = new InetSocketAddress(this.address, n);
            if (this.address.isMulticastAddress()) {
                this.multicastSocket = new MulticastSocket(this.socketAddress);
                this.multicastSocket.joinGroup(this.address);
                this.socket = this.multicastSocket;
            } else {
                this.socket = new DatagramSocket(this.socketAddress);
            }
        }
        catch (IOException iOException) {
            throw new UdpDataSourceException(iOException);
        }
        try {
            this.socket.setSoTimeout(this.socketTimeoutMillis);
        }
        catch (SocketException socketException) {
            throw new UdpDataSourceException(socketException);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return -1L;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws UdpDataSourceException {
        if (this.packetRemaining == 0) {
            try {
                this.socket.receive(this.packet);
            }
            catch (IOException iOException) {
                throw new UdpDataSourceException(iOException);
            }
            this.packetRemaining = this.packet.getLength();
            if (this.listener != null) {
                this.listener.onBytesTransferred(this.packetRemaining);
            }
        }
        int n3 = this.packet.getLength() - this.packetRemaining;
        int n4 = Math.min(this.packetRemaining, n2);
        System.arraycopy(this.packetBuffer, n3, byArray, n, n4);
        this.packetRemaining -= n4;
        return n4;
    }

    @Override
    public void close() {
        if (this.multicastSocket != null) {
            try {
                this.multicastSocket.leaveGroup(this.address);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.multicastSocket = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.address = null;
        this.socketAddress = null;
        this.packetRemaining = 0;
        if (this.opened) {
            this.opened = false;
            if (this.listener != null) {
                this.listener.onTransferEnd();
            }
        }
    }

    @Override
    public String getUri() {
        return this.dataSpec == null ? null : this.dataSpec.uri.toString();
    }

    public static final class UdpDataSourceException
    extends IOException {
        public UdpDataSourceException(String string) {
            super(string);
        }

        public UdpDataSourceException(IOException iOException) {
            super(iOException);
        }
    }
}

