/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.io.InputStream;

public final class DataSourceInputStream
extends InputStream {
    private final DataSource dataSource;
    private final DataSpec dataSpec;
    private final byte[] singleByteArray;
    private boolean opened = false;
    private boolean closed = false;

    public DataSourceInputStream(DataSource dataSource, DataSpec dataSpec) {
        this.dataSource = dataSource;
        this.dataSpec = dataSpec;
        this.singleByteArray = new byte[1];
    }

    public void open() throws IOException {
        this.checkOpened();
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.singleByteArray);
        if (n == -1) {
            return -1;
        }
        return this.singleByteArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        Assertions.checkState(!this.closed);
        this.checkOpened();
        return this.dataSource.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        Assertions.checkState(!this.closed);
        this.checkOpened();
        return super.skip(l);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.dataSource.close();
            this.closed = true;
        }
    }

    private void checkOpened() throws IOException {
        if (!this.opened) {
            this.dataSource.open(this.dataSpec);
            this.opened = true;
        }
    }
}

