/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.webvtt;

import android.text.Layout;
import com.google.android.exoplayer.text.Cue;
import com.vcc.playerwrappersdk.a;

final class WebvttCue
extends Cue {
    public final long startTime;
    public final long endTime;

    public WebvttCue(CharSequence charSequence) {
        this(0L, 0L, charSequence);
    }

    public WebvttCue(long l, long l2, CharSequence charSequence) {
        this(l, l2, charSequence, null, Float.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Float.MIN_VALUE, Integer.MIN_VALUE, Float.MIN_VALUE);
    }

    public WebvttCue(long l, long l2, CharSequence charSequence, Layout.Alignment alignment, float f2, int n, int n2, float f3, int n3, float f4) {
        super(charSequence, alignment, f2, n, n2, f3, n3, f4);
        this.startTime = l;
        this.endTime = l2;
    }

    public boolean isNormalCue() {
        return this.line == Float.MIN_VALUE && this.position == Float.MIN_VALUE;
    }

    public static final class Builder {
        private static final String TAG = "WebvttCueBuilder";
        private long startTime;
        private long endTime;
        private CharSequence text;
        private Layout.Alignment textAlignment;
        private float line;
        private int lineType;
        private int lineAnchor;
        private float position;
        private int positionAnchor;
        private float width;

        public Builder() {
            this.reset();
        }

        public void reset() {
            this.startTime = 0L;
            this.endTime = 0L;
            this.text = null;
            this.textAlignment = null;
            this.line = Float.MIN_VALUE;
            this.lineType = Integer.MIN_VALUE;
            this.lineAnchor = Integer.MIN_VALUE;
            this.position = Float.MIN_VALUE;
            this.positionAnchor = Integer.MIN_VALUE;
            this.width = Float.MIN_VALUE;
        }

        public WebvttCue build() {
            if (this.position != Float.MIN_VALUE && this.positionAnchor == Integer.MIN_VALUE) {
                this.derivePositionAnchorFromAlignment();
            }
            return new WebvttCue(this.startTime, this.endTime, this.text, this.textAlignment, this.line, this.lineType, this.lineAnchor, this.position, this.positionAnchor, this.width);
        }

        public Builder setStartTime(long l) {
            this.startTime = l;
            return this;
        }

        public Builder setEndTime(long l) {
            this.endTime = l;
            return this;
        }

        public Builder setText(CharSequence charSequence) {
            this.text = charSequence;
            return this;
        }

        public Builder setTextAlignment(Layout.Alignment alignment) {
            this.textAlignment = alignment;
            return this;
        }

        public Builder setLine(float f2) {
            this.line = f2;
            return this;
        }

        public Builder setLineType(int n) {
            this.lineType = n;
            return this;
        }

        public Builder setLineAnchor(int n) {
            this.lineAnchor = n;
            return this;
        }

        public Builder setPosition(float f2) {
            this.position = f2;
            return this;
        }

        public Builder setPositionAnchor(int n) {
            this.positionAnchor = n;
            return this;
        }

        public Builder setWidth(float f2) {
            this.width = f2;
            return this;
        }

        private Builder derivePositionAnchorFromAlignment() {
            if (this.textAlignment == null) {
                this.positionAnchor = Integer.MIN_VALUE;
            } else {
                switch (this.textAlignment) {
                    case ALIGN_NORMAL: {
                        this.positionAnchor = 0;
                        break;
                    }
                    case ALIGN_CENTER: {
                        this.positionAnchor = 1;
                        break;
                    }
                    case ALIGN_OPPOSITE: {
                        this.positionAnchor = 2;
                        break;
                    }
                    default: {
                        a.c(TAG, "Unrecognized alignment: " + this.textAlignment);
                        this.positionAnchor = 0;
                    }
                }
            }
            return this;
        }
    }
}

