/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import android.text.SpannableStringBuilder;
import com.google.android.exoplayer.text.ttml.TtmlRenderUtil;
import com.google.android.exoplayer.text.ttml.TtmlStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

final class TtmlNode {
    public static final long UNDEFINED_TIME = -1L;
    public static final String TAG_TT = "tt";
    public static final String TAG_HEAD = "head";
    public static final String TAG_BODY = "body";
    public static final String TAG_DIV = "div";
    public static final String TAG_P = "p";
    public static final String TAG_SPAN = "span";
    public static final String TAG_BR = "br";
    public static final String TAG_STYLE = "style";
    public static final String TAG_STYLING = "styling";
    public static final String TAG_LAYOUT = "layout";
    public static final String TAG_REGION = "region";
    public static final String TAG_METADATA = "metadata";
    public static final String TAG_SMPTE_IMAGE = "smpte:image";
    public static final String TAG_SMPTE_DATA = "smpte:data";
    public static final String TAG_SMPTE_INFORMATION = "smpte:information";
    public static final String ATTR_ID = "id";
    public static final String ATTR_TTS_BACKGROUND_COLOR = "backgroundColor";
    public static final String ATTR_TTS_FONT_STYLE = "fontStyle";
    public static final String ATTR_TTS_FONT_SIZE = "fontSize";
    public static final String ATTR_TTS_FONT_FAMILY = "fontFamily";
    public static final String ATTR_TTS_FONT_WEIGHT = "fontWeight";
    public static final String ATTR_TTS_COLOR = "color";
    public static final String ATTR_TTS_TEXT_DECORATION = "textDecoration";
    public static final String ATTR_TTS_TEXT_ALIGN = "textAlign";
    public static final String LINETHROUGH = "linethrough";
    public static final String NO_LINETHROUGH = "nolinethrough";
    public static final String UNDERLINE = "underline";
    public static final String NO_UNDERLINE = "nounderline";
    public static final String ITALIC = "italic";
    public static final String BOLD = "bold";
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String START = "start";
    public static final String END = "end";
    public final String tag;
    public final String text;
    public final boolean isTextNode;
    public final long startTimeUs;
    public final long endTimeUs;
    public final TtmlStyle style;
    private String[] styleIds;
    private List<TtmlNode> children;
    private int start;
    private int end;

    public static TtmlNode buildTextNode(String string) {
        return new TtmlNode(null, TtmlRenderUtil.applyTextElementSpacePolicy(string), -1L, -1L, null, null);
    }

    public static TtmlNode buildNode(String string, long l, long l2, TtmlStyle ttmlStyle, String[] stringArray) {
        return new TtmlNode(string, null, l, l2, ttmlStyle, stringArray);
    }

    private TtmlNode(String string, String string2, long l, long l2, TtmlStyle ttmlStyle, String[] stringArray) {
        this.tag = string;
        this.text = string2;
        this.style = ttmlStyle;
        this.styleIds = stringArray;
        this.isTextNode = string2 != null;
        this.startTimeUs = l;
        this.endTimeUs = l2;
    }

    public boolean isActive(long l) {
        return this.startTimeUs == -1L && this.endTimeUs == -1L || this.startTimeUs <= l && this.endTimeUs == -1L || this.startTimeUs == -1L && l < this.endTimeUs || this.startTimeUs <= l && l < this.endTimeUs;
    }

    public void addChild(TtmlNode ttmlNode) {
        if (this.children == null) {
            this.children = new ArrayList<TtmlNode>();
        }
        this.children.add(ttmlNode);
    }

    public TtmlNode getChild(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.children.get(n);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public long[] getEventTimesUs() {
        TreeSet<Long> treeSet = new TreeSet<Long>();
        this.getEventTimes(treeSet, false);
        long[] lArray = new long[treeSet.size()];
        Iterator<Long> iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            long l = iterator.next();
            lArray[n++] = l;
        }
        return lArray;
    }

    private void getEventTimes(TreeSet<Long> treeSet, boolean bl) {
        boolean bl2 = TAG_P.equals(this.tag);
        if (bl || bl2) {
            if (this.startTimeUs != -1L) {
                treeSet.add(this.startTimeUs);
            }
            if (this.endTimeUs != -1L) {
                treeSet.add(this.endTimeUs);
            }
        }
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).getEventTimes(treeSet, bl || bl2);
        }
    }

    public String[] getStyleIds() {
        return this.styleIds;
    }

    public CharSequence getText(long l, Map<String, TtmlStyle> map) {
        int n;
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        this.traverseForText(l, spannableStringBuilder, false);
        this.traverseForStyle(spannableStringBuilder, map);
        int n2 = spannableStringBuilder.length();
        for (n = 0; n < n2; ++n) {
            int n3;
            if (spannableStringBuilder.charAt(n) != ' ') continue;
            for (n3 = n + 1; n3 < spannableStringBuilder.length() && spannableStringBuilder.charAt(n3) == ' '; ++n3) {
            }
            int n4 = n3 - (n + 1);
            if (n4 <= 0) continue;
            spannableStringBuilder.delete(n, n + n4);
            n2 -= n4;
        }
        if (n2 > 0 && spannableStringBuilder.charAt(0) == ' ') {
            spannableStringBuilder.delete(0, 1);
            --n2;
        }
        for (n = 0; n < n2 - 1; ++n) {
            if (spannableStringBuilder.charAt(n) != '\n' || spannableStringBuilder.charAt(n + 1) != ' ') continue;
            spannableStringBuilder.delete(n + 1, n + 2);
            --n2;
        }
        if (n2 > 0 && spannableStringBuilder.charAt(n2 - 1) == ' ') {
            spannableStringBuilder.delete(n2 - 1, n2);
            --n2;
        }
        for (n = 0; n < n2 - 1; ++n) {
            if (spannableStringBuilder.charAt(n) != ' ' || spannableStringBuilder.charAt(n + 1) != '\n') continue;
            spannableStringBuilder.delete(n, n + 1);
            --n2;
        }
        if (n2 > 0 && spannableStringBuilder.charAt(n2 - 1) == '\n') {
            spannableStringBuilder.delete(n2 - 1, n2);
        }
        return spannableStringBuilder;
    }

    private SpannableStringBuilder traverseForText(long l, SpannableStringBuilder spannableStringBuilder, boolean bl) {
        this.end = this.start = spannableStringBuilder.length();
        if (this.isTextNode && bl) {
            spannableStringBuilder.append((CharSequence)this.text);
        } else if (TAG_BR.equals(this.tag) && bl) {
            spannableStringBuilder.append('\n');
        } else if (!TAG_METADATA.equals(this.tag) && this.isActive(l)) {
            boolean bl2 = TAG_P.equals(this.tag);
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.getChild(i).traverseForText(l, spannableStringBuilder, bl || bl2);
            }
            if (bl2) {
                TtmlRenderUtil.endParagraph(spannableStringBuilder);
            }
            this.end = spannableStringBuilder.length();
        }
        return spannableStringBuilder;
    }

    private void traverseForStyle(SpannableStringBuilder spannableStringBuilder, Map<String, TtmlStyle> map) {
        if (this.start != this.end) {
            TtmlStyle ttmlStyle = TtmlRenderUtil.resolveStyle(this.style, this.styleIds, map);
            if (ttmlStyle != null) {
                TtmlRenderUtil.applyStylesToSpan(spannableStringBuilder, this.start, this.end, ttmlStyle);
            }
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.getChild(i).traverseForStyle(spannableStringBuilder, map);
            }
        }
    }
}

