/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.metadata.id3;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.metadata.MetadataParser;
import com.google.android.exoplayer.metadata.id3.BinaryFrame;
import com.google.android.exoplayer.metadata.id3.GeobFrame;
import com.google.android.exoplayer.metadata.id3.Id3Frame;
import com.google.android.exoplayer.metadata.id3.PrivFrame;
import com.google.android.exoplayer.metadata.id3.TxxxFrame;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class Id3Parser
implements MetadataParser<List<Id3Frame>> {
    private static final int ID3_TEXT_ENCODING_ISO_8859_1 = 0;
    private static final int ID3_TEXT_ENCODING_UTF_16 = 1;
    private static final int ID3_TEXT_ENCODING_UTF_16BE = 2;
    private static final int ID3_TEXT_ENCODING_UTF_8 = 3;

    @Override
    public boolean canParse(String string) {
        return string.equals("application/id3");
    }

    @Override
    public List<Id3Frame> parse(byte[] byArray, int n) throws UnsupportedEncodingException, ParserException {
        int n2;
        ArrayList<Id3Frame> arrayList = new ArrayList<Id3Frame>();
        ParsableByteArray parsableByteArray = new ParsableByteArray(byArray, n);
        for (int i = Id3Parser.parseId3Header(parsableByteArray); i > 0; i -= n2 + 10) {
            String string;
            int n3;
            int n4;
            String string2;
            int n5;
            Object object;
            Object object2;
            int n6 = parsableByteArray.readUnsignedByte();
            int n7 = parsableByteArray.readUnsignedByte();
            int n8 = parsableByteArray.readUnsignedByte();
            int n9 = parsableByteArray.readUnsignedByte();
            n2 = parsableByteArray.readSynchSafeInt();
            if (n2 <= 1) break;
            parsableByteArray.skipBytes(2);
            if (n6 == 84 && n7 == 88 && n8 == 88 && n9 == 88) {
                int n10 = parsableByteArray.readUnsignedByte();
                object2 = Id3Parser.getCharsetName(n10);
                object = new byte[n2 - 1];
                parsableByteArray.readBytes((byte[])object, 0, n2 - 1);
                n5 = Id3Parser.indexOfEOS(object, 0, n10);
                string2 = new String((byte[])object, 0, n5, (String)object2);
                n4 = n5 + Id3Parser.delimiterLength(n10);
                n3 = Id3Parser.indexOfEOS(object, n4, n10);
                string = new String((byte[])object, n4, n3 - n4, (String)object2);
                arrayList.add(new TxxxFrame(string2, string));
                continue;
            }
            if (n6 == 80 && n7 == 82 && n8 == 73 && n9 == 86) {
                byte[] byArray2 = new byte[n2];
                parsableByteArray.readBytes(byArray2, 0, n2);
                int n11 = Id3Parser.indexOf(byArray2, 0, (byte)0);
                object = new String(byArray2, 0, n11, "ISO-8859-1");
                byte[] byArray3 = new byte[n2 - n11 - 1];
                System.arraycopy(byArray2, n11 + 1, byArray3, 0, n2 - n11 - 1);
                arrayList.add(new PrivFrame((String)object, byArray3));
                continue;
            }
            if (n6 == 71 && n7 == 69 && n8 == 79 && n9 == 66) {
                int n12 = parsableByteArray.readUnsignedByte();
                object2 = Id3Parser.getCharsetName(n12);
                object = new byte[n2 - 1];
                parsableByteArray.readBytes((byte[])object, 0, n2 - 1);
                n5 = Id3Parser.indexOf(object, 0, (byte)0);
                string2 = new String((byte[])object, 0, n5, "ISO-8859-1");
                n4 = n5 + 1;
                n3 = Id3Parser.indexOfEOS(object, n4, n12);
                string = new String((byte[])object, n4, n3 - n4, (String)object2);
                int n13 = n3 + Id3Parser.delimiterLength(n12);
                int n14 = Id3Parser.indexOfEOS(object, n13, n12);
                String string3 = new String((byte[])object, n13, n14 - n13, (String)object2);
                int n15 = n2 - 1 - n14 - Id3Parser.delimiterLength(n12);
                byte[] byArray4 = new byte[n15];
                System.arraycopy(object, n14 + Id3Parser.delimiterLength(n12), byArray4, 0, n15);
                arrayList.add(new GeobFrame(string2, string, string3, byArray4));
                continue;
            }
            String string4 = String.format(Locale.US, "%c%c%c%c", n6, n7, n8, n9);
            object2 = new byte[n2];
            parsableByteArray.readBytes((byte[])object2, 0, n2);
            arrayList.add(new BinaryFrame(string4, (byte[])object2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static int indexOf(byte[] byArray, int n, byte by) {
        for (int i = n; i < byArray.length; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return byArray.length;
    }

    private static int indexOfEOS(byte[] byArray, int n, int n2) {
        int n3 = Id3Parser.indexOf(byArray, n, (byte)0);
        if (n2 == 0 || n2 == 3) {
            return n3;
        }
        while (n3 < byArray.length - 1) {
            if (byArray[n3 + 1] == 0) {
                return n3;
            }
            n3 = Id3Parser.indexOf(byArray, n3 + 1, (byte)0);
        }
        return byArray.length;
    }

    private static int delimiterLength(int n) {
        return n == 0 || n == 3 ? 1 : 2;
    }

    private static int parseId3Header(ParsableByteArray parsableByteArray) throws ParserException {
        int n = parsableByteArray.readUnsignedByte();
        int n2 = parsableByteArray.readUnsignedByte();
        int n3 = parsableByteArray.readUnsignedByte();
        if (n != 73 || n2 != 68 || n3 != 51) {
            throw new ParserException(String.format(Locale.US, "Unexpected ID3 file identifier, expected \"ID3\", actual \"%c%c%c\".", n, n2, n3));
        }
        parsableByteArray.skipBytes(2);
        int n4 = parsableByteArray.readUnsignedByte();
        int n5 = parsableByteArray.readSynchSafeInt();
        if ((n4 & 2) != 0) {
            int n6 = parsableByteArray.readSynchSafeInt();
            if (n6 > 4) {
                parsableByteArray.skipBytes(n6 - 4);
            }
            n5 -= n6;
        }
        if ((n4 & 8) != 0) {
            n5 -= 10;
        }
        return n5;
    }

    private static String getCharsetName(int n) {
        switch (n) {
            case 0: {
                return "ISO-8859-1";
            }
            case 1: {
                return "UTF-16";
            }
            case 2: {
                return "UTF-16BE";
            }
            case 3: {
                return "UTF-8";
            }
        }
        return "ISO-8859-1";
    }
}

