/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.net.Uri;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.exoplayer.BehindLiveWindowException;
import com.google.android.exoplayer.chunk.BaseChunkSampleSourceEventListener;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.DataChunk;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer.extractor.ts.AdtsExtractor;
import com.google.android.exoplayer.extractor.ts.PtsTimestampAdjuster;
import com.google.android.exoplayer.extractor.ts.TsExtractor;
import com.google.android.exoplayer.hls.HlsExtractorWrapper;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsMediaPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylistParser;
import com.google.android.exoplayer.hls.HlsTrackSelector;
import com.google.android.exoplayer.hls.PtsTimestampAdjusterProvider;
import com.google.android.exoplayer.hls.TsChunk;
import com.google.android.exoplayer.hls.Variant;
import com.google.android.exoplayer.hls.WebvttExtractor;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.HttpDataSource;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.UriUtil;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

public class HlsChunkSource
implements HlsTrackSelector.Output {
    public static final int ADAPTIVE_MODE_NONE = 0;
    public static final int ADAPTIVE_MODE_SPLICE = 1;
    public static final int ADAPTIVE_MODE_ABRUPT = 3;
    public static final long DEFAULT_MIN_BUFFER_TO_SWITCH_UP_MS = 5000L;
    public static final long DEFAULT_MAX_BUFFER_TO_SWITCH_DOWN_MS = 20000L;
    public static final long DEFAULT_PLAYLIST_BLACKLIST_MS = 60000L;
    private static final String TAG = "HlsChunkSource";
    private static final String AAC_FILE_EXTENSION = ".aac";
    private static final String MP3_FILE_EXTENSION = ".mp3";
    private static final String VTT_FILE_EXTENSION = ".vtt";
    private static final String WEBVTT_FILE_EXTENSION = ".webvtt";
    private static final float BANDWIDTH_FRACTION = 0.8f;
    private final boolean isMaster;
    private final DataSource dataSource;
    private final HlsPlaylistParser playlistParser;
    private final HlsMasterPlaylist masterPlaylist;
    private final HlsTrackSelector trackSelector;
    private final BandwidthMeter bandwidthMeter;
    private final PtsTimestampAdjusterProvider timestampAdjusterProvider;
    private final int adaptiveMode;
    private final String baseUri;
    private final long minBufferDurationToSwitchUpUs;
    private final long maxBufferDurationToSwitchDownUs;
    private final ArrayList<ExposedTrack> tracks;
    private int selectedTrackIndex;
    private Variant[] variants;
    private HlsMediaPlaylist[] variantPlaylists;
    private long[] variantLastPlaylistLoadTimesMs;
    private long[] variantBlacklistTimes;
    private int selectedVariantIndex;
    private boolean prepareCalled;
    private byte[] scratchSpace;
    private boolean live;
    private long durationUs;
    private IOException fatalError;
    private Uri encryptionKeyUri;
    private byte[] encryptionKey;
    private String encryptionIvString;
    private byte[] encryptionIv;

    public HlsChunkSource(boolean bl, DataSource dataSource, String string, HlsPlaylist hlsPlaylist, HlsTrackSelector hlsTrackSelector, BandwidthMeter bandwidthMeter, PtsTimestampAdjusterProvider ptsTimestampAdjusterProvider, int n) {
        this(bl, dataSource, string, hlsPlaylist, hlsTrackSelector, bandwidthMeter, ptsTimestampAdjusterProvider, n, 5000L, 20000L);
    }

    public HlsChunkSource(boolean bl, DataSource dataSource, String string, HlsPlaylist hlsPlaylist, HlsTrackSelector hlsTrackSelector, BandwidthMeter bandwidthMeter, PtsTimestampAdjusterProvider ptsTimestampAdjusterProvider, int n, long l, long l2) {
        this.isMaster = bl;
        this.dataSource = dataSource;
        this.trackSelector = hlsTrackSelector;
        this.bandwidthMeter = bandwidthMeter;
        this.timestampAdjusterProvider = ptsTimestampAdjusterProvider;
        this.adaptiveMode = n;
        this.minBufferDurationToSwitchUpUs = l * 1000L;
        this.maxBufferDurationToSwitchDownUs = l2 * 1000L;
        this.baseUri = hlsPlaylist.baseUri;
        this.playlistParser = new HlsPlaylistParser();
        this.tracks = new ArrayList();
        if (hlsPlaylist.type == 0) {
            this.masterPlaylist = (HlsMasterPlaylist)hlsPlaylist;
        } else {
            Format format = new Format("0", "application/x-mpegURL", -1, -1, -1.0f, -1, -1, -1, null, null);
            ArrayList<Variant> arrayList = new ArrayList<Variant>();
            arrayList.add(new Variant(string, format));
            this.masterPlaylist = new HlsMasterPlaylist(string, arrayList, Collections.emptyList(), Collections.emptyList(), null, null);
        }
    }

    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
    }

    public boolean prepare() {
        if (!this.prepareCalled) {
            this.prepareCalled = true;
            try {
                this.trackSelector.selectTracks(this.masterPlaylist, this);
                this.selectTrack(0);
            }
            catch (IOException iOException) {
                this.fatalError = iOException;
            }
        }
        return this.fatalError == null;
    }

    public boolean isLive() {
        return this.live;
    }

    public long getDurationUs() {
        return this.durationUs;
    }

    public int getTrackCount() {
        return this.tracks.size();
    }

    public Variant getFixedTrackVariant(int n) {
        Variant[] variantArray = this.tracks.get(n).variants;
        return variantArray.length == 1 ? variantArray[0] : null;
    }

    public String getMuxedAudioLanguage() {
        return this.masterPlaylist.muxedAudioLanguage;
    }

    public String getMuxedCaptionLanguage() {
        return this.masterPlaylist.muxedCaptionLanguage;
    }

    public int getSelectedTrackIndex() {
        return this.selectedTrackIndex;
    }

    public void selectTrack(int n) {
        this.selectedTrackIndex = n;
        ExposedTrack exposedTrack = this.tracks.get(this.selectedTrackIndex);
        this.selectedVariantIndex = exposedTrack.defaultVariantIndex;
        this.variants = exposedTrack.variants;
        this.variantPlaylists = new HlsMediaPlaylist[this.variants.length];
        this.variantLastPlaylistLoadTimesMs = new long[this.variants.length];
        this.variantBlacklistTimes = new long[this.variants.length];
    }

    public void seek() {
        if (this.isMaster) {
            this.timestampAdjusterProvider.reset();
        }
    }

    public void reset() {
        this.fatalError = null;
    }

    public void getChunkOperation(TsChunk tsChunk, long l, ChunkOperationHolder chunkOperationHolder) {
        HlsExtractorWrapper hlsExtractorWrapper;
        Object object;
        boolean bl;
        int n;
        if (this.adaptiveMode == 0) {
            n = this.selectedVariantIndex;
            bl = false;
        } else {
            n = this.getNextVariantIndex(tsChunk, l);
            bl = tsChunk != null && !this.variants[n].format.equals(tsChunk.format) && this.adaptiveMode == 1;
        }
        HlsMediaPlaylist hlsMediaPlaylist = this.variantPlaylists[n];
        if (hlsMediaPlaylist == null) {
            chunkOperationHolder.chunk = this.newMediaPlaylistChunk(n);
            return;
        }
        this.selectedVariantIndex = n;
        int n2 = 0;
        if (this.live) {
            if (tsChunk == null) {
                n2 = this.getLiveStartChunkMediaSequence(n);
            } else {
                int n3 = n2 = bl ? tsChunk.chunkIndex : tsChunk.chunkIndex + 1;
                if (n2 < hlsMediaPlaylist.mediaSequence) {
                    this.fatalError = new BehindLiveWindowException();
                    return;
                }
            }
        } else {
            n2 = tsChunk == null ? Util.binarySearchFloor(hlsMediaPlaylist.segments, Long.valueOf(l), true, true) + hlsMediaPlaylist.mediaSequence : (bl ? tsChunk.chunkIndex : tsChunk.chunkIndex + 1);
        }
        int n4 = n2 - hlsMediaPlaylist.mediaSequence;
        if (n4 >= hlsMediaPlaylist.segments.size()) {
            if (!hlsMediaPlaylist.live) {
                chunkOperationHolder.endOfStream = true;
            } else if (this.shouldRerequestLiveMediaPlaylist(n)) {
                chunkOperationHolder.chunk = this.newMediaPlaylistChunk(n);
            }
            return;
        }
        HlsMediaPlaylist.Segment segment = hlsMediaPlaylist.segments.get(n4);
        Uri uri = UriUtil.resolveToUri(hlsMediaPlaylist.baseUri, segment.url);
        if (segment.isEncrypted) {
            object = UriUtil.resolveToUri(hlsMediaPlaylist.baseUri, segment.encryptionKeyUri);
            if (!object.equals((Object)this.encryptionKeyUri)) {
                chunkOperationHolder.chunk = this.newEncryptionKeyChunk((Uri)object, segment.encryptionIV, this.selectedVariantIndex);
                return;
            }
            if (!Util.areEqual(segment.encryptionIV, this.encryptionIvString)) {
                this.setEncryptionData((Uri)object, segment.encryptionIV, this.encryptionKey);
            }
        } else {
            this.clearEncryptionData();
        }
        object = new DataSpec(uri, segment.byterangeOffset, segment.byterangeLength, null);
        long l2 = this.live ? (tsChunk == null ? 0L : (bl ? tsChunk.startTimeUs : tsChunk.endTimeUs)) : segment.startTimeUs;
        long l3 = l2 + (long)(segment.durationSecs * 1000000.0);
        int n5 = 0;
        Format format = this.variants[this.selectedVariantIndex].format;
        String string = uri.getLastPathSegment();
        if (string.endsWith(AAC_FILE_EXTENSION)) {
            AdtsExtractor adtsExtractor = new AdtsExtractor(l2);
            hlsExtractorWrapper = new HlsExtractorWrapper(n5, format, l2, adtsExtractor, bl, -1, -1);
        } else if (string.endsWith(MP3_FILE_EXTENSION)) {
            Mp3Extractor mp3Extractor = new Mp3Extractor(l2);
            hlsExtractorWrapper = new HlsExtractorWrapper(n5, format, l2, mp3Extractor, bl, -1, -1);
        } else if (string.endsWith(WEBVTT_FILE_EXTENSION) || string.endsWith(VTT_FILE_EXTENSION)) {
            PtsTimestampAdjuster ptsTimestampAdjuster = this.timestampAdjusterProvider.getAdjuster(this.isMaster, segment.discontinuitySequenceNumber, l2);
            if (ptsTimestampAdjuster == null) {
                return;
            }
            WebvttExtractor webvttExtractor = new WebvttExtractor(ptsTimestampAdjuster);
            hlsExtractorWrapper = new HlsExtractorWrapper(n5, format, l2, webvttExtractor, bl, -1, -1);
        } else if (tsChunk == null || tsChunk.discontinuitySequenceNumber != segment.discontinuitySequenceNumber || !format.equals(tsChunk.format)) {
            PtsTimestampAdjuster ptsTimestampAdjuster = this.timestampAdjusterProvider.getAdjuster(this.isMaster, segment.discontinuitySequenceNumber, l2);
            if (ptsTimestampAdjuster == null) {
                return;
            }
            int n6 = 0;
            String string2 = format.codecs;
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                if (!MimeTypes.getAudioMediaMimeType(string2).equals("audio/mp4a-latm")) {
                    n6 |= 2;
                }
                if (!MimeTypes.getVideoMediaMimeType(string2).equals("video/avc")) {
                    n6 |= 4;
                }
            }
            TsExtractor tsExtractor = new TsExtractor(ptsTimestampAdjuster, n6);
            ExposedTrack exposedTrack = this.tracks.get(this.selectedTrackIndex);
            hlsExtractorWrapper = new HlsExtractorWrapper(n5, format, l2, tsExtractor, bl, exposedTrack.adaptiveMaxWidth, exposedTrack.adaptiveMaxHeight);
        } else {
            hlsExtractorWrapper = tsChunk.extractorWrapper;
        }
        chunkOperationHolder.chunk = new TsChunk(this.dataSource, (DataSpec)object, n5, format, l2, l3, n2, segment.discontinuitySequenceNumber, hlsExtractorWrapper, this.encryptionKey, this.encryptionIv);
    }

    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof MediaPlaylistChunk) {
            MediaPlaylistChunk mediaPlaylistChunk = (MediaPlaylistChunk)chunk;
            this.scratchSpace = mediaPlaylistChunk.getDataHolder();
            this.setMediaPlaylist(mediaPlaylistChunk.variantIndex, mediaPlaylistChunk.getResult());
        } else if (chunk instanceof EncryptionKeyChunk) {
            EncryptionKeyChunk encryptionKeyChunk = (EncryptionKeyChunk)chunk;
            this.scratchSpace = encryptionKeyChunk.getDataHolder();
            this.setEncryptionData(encryptionKeyChunk.dataSpec.uri, encryptionKeyChunk.iv, encryptionKeyChunk.getResult());
        }
    }

    public boolean onChunkLoadError(Chunk chunk, IOException iOException) {
        if (chunk.bytesLoaded() == 0L && (chunk instanceof TsChunk || chunk instanceof MediaPlaylistChunk || chunk instanceof EncryptionKeyChunk) && iOException instanceof HttpDataSource.InvalidResponseCodeException) {
            HttpDataSource.InvalidResponseCodeException invalidResponseCodeException = (HttpDataSource.InvalidResponseCodeException)iOException;
            int n = invalidResponseCodeException.responseCode;
            if (n == 404 || n == 410) {
                int n2;
                Chunk chunk2;
                if (chunk instanceof TsChunk) {
                    chunk2 = (TsChunk)chunk;
                    n2 = this.getVariantIndex(chunk2.format);
                } else if (chunk instanceof MediaPlaylistChunk) {
                    chunk2 = (MediaPlaylistChunk)chunk;
                    n2 = ((MediaPlaylistChunk)chunk2).variantIndex;
                } else {
                    chunk2 = (EncryptionKeyChunk)chunk;
                    n2 = ((EncryptionKeyChunk)chunk2).variantIndex;
                }
                boolean bl = this.variantBlacklistTimes[n2] != 0L;
                this.variantBlacklistTimes[n2] = SystemClock.elapsedRealtime();
                if (bl) {
                    a.c(TAG, "Already blacklisted variant (" + n + "): " + chunk.dataSpec.uri);
                    return false;
                }
                if (!this.allVariantsBlacklisted()) {
                    a.c(TAG, "Blacklisted variant (" + n + "): " + chunk.dataSpec.uri);
                    return true;
                }
                a.c(TAG, "Final variant not blacklisted (" + n + "): " + chunk.dataSpec.uri);
                this.variantBlacklistTimes[n2] = 0L;
                return false;
            }
        }
        return false;
    }

    @Override
    public void adaptiveTrack(HlsMasterPlaylist hlsMasterPlaylist, Variant[] variantArray) {
        Arrays.sort(variantArray, new Comparator<Variant>(){
            private final Comparator<Format> formatComparator = new Format.DecreasingBandwidthComparator();

            @Override
            public int compare(Variant variant, Variant variant2) {
                return this.formatComparator.compare(variant.format, variant2.format);
            }
        });
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < variantArray.length; ++i) {
            int n5 = hlsMasterPlaylist.variants.indexOf(variantArray[i]);
            if (n5 < n4) {
                n4 = n5;
                n = i;
            }
            Format format = variantArray[i].format;
            n2 = Math.max(format.width, n2);
            n3 = Math.max(format.height, n3);
        }
        n2 = n2 > 0 ? n2 : 1920;
        n3 = n3 > 0 ? n3 : 1080;
        this.tracks.add(new ExposedTrack(variantArray, n, n2, n3));
    }

    @Override
    public void fixedTrack(HlsMasterPlaylist hlsMasterPlaylist, Variant variant) {
        this.tracks.add(new ExposedTrack(variant));
    }

    private int getNextVariantIndex(TsChunk tsChunk, long l) {
        this.clearStaleBlacklistedVariants();
        long l2 = this.bandwidthMeter.getBitrateEstimate();
        if (this.variantBlacklistTimes[this.selectedVariantIndex] != 0L) {
            return this.getVariantIndexForBandwidth(l2);
        }
        if (tsChunk == null) {
            return this.selectedVariantIndex;
        }
        if (l2 == -1L) {
            return this.selectedVariantIndex;
        }
        int n = this.getVariantIndexForBandwidth(l2);
        if (n == this.selectedVariantIndex) {
            return this.selectedVariantIndex;
        }
        long l3 = this.adaptiveMode == 1 ? tsChunk.startTimeUs : tsChunk.endTimeUs;
        long l4 = l3 - l;
        if (this.variantBlacklistTimes[this.selectedVariantIndex] != 0L || n > this.selectedVariantIndex && l4 < this.maxBufferDurationToSwitchDownUs || n < this.selectedVariantIndex && l4 > this.minBufferDurationToSwitchUpUs) {
            return n;
        }
        return this.selectedVariantIndex;
    }

    private int getVariantIndexForBandwidth(long l) {
        if (l == -1L) {
            l = 0L;
        }
        int n = (int)((float)l * 0.8f);
        int n2 = -1;
        for (int i = 0; i < this.variants.length; ++i) {
            if (this.variantBlacklistTimes[i] != 0L) continue;
            if (this.variants[i].format.bitrate <= n) {
                return i;
            }
            n2 = i;
        }
        Assertions.checkState(n2 != -1);
        return n2;
    }

    private boolean shouldRerequestLiveMediaPlaylist(int n) {
        HlsMediaPlaylist hlsMediaPlaylist = this.variantPlaylists[n];
        long l = SystemClock.elapsedRealtime() - this.variantLastPlaylistLoadTimesMs[n];
        return l >= (long)(hlsMediaPlaylist.targetDurationSecs * 1000 / 2);
    }

    private int getLiveStartChunkMediaSequence(int n) {
        HlsMediaPlaylist hlsMediaPlaylist = this.variantPlaylists[n];
        int n2 = hlsMediaPlaylist.segments.size() > 3 ? hlsMediaPlaylist.segments.size() - 3 : 0;
        return n2 + hlsMediaPlaylist.mediaSequence;
    }

    private MediaPlaylistChunk newMediaPlaylistChunk(int n) {
        Uri uri = UriUtil.resolveToUri(this.baseUri, this.variants[n].url);
        DataSpec dataSpec = new DataSpec(uri, 0L, -1L, null, 0);
        return new MediaPlaylistChunk(this.dataSource, dataSpec, this.scratchSpace, this.playlistParser, n, uri.toString());
    }

    private EncryptionKeyChunk newEncryptionKeyChunk(Uri uri, String string, int n) {
        DataSpec dataSpec = new DataSpec(uri, 0L, -1L, null, 0);
        return new EncryptionKeyChunk(this.dataSource, dataSpec, this.scratchSpace, string, n);
    }

    private void setEncryptionData(Uri uri, String string, byte[] byArray) {
        String string2 = string.toLowerCase(Locale.getDefault()).startsWith("0x") ? string.substring(2) : string;
        byte[] byArray2 = new BigInteger(string2, 16).toByteArray();
        byte[] byArray3 = new byte[16];
        int n = byArray2.length > 16 ? byArray2.length - 16 : 0;
        System.arraycopy(byArray2, n, byArray3, byArray3.length - byArray2.length + n, byArray2.length - n);
        this.encryptionKeyUri = uri;
        this.encryptionKey = byArray;
        this.encryptionIvString = string;
        this.encryptionIv = byArray3;
    }

    private void clearEncryptionData() {
        this.encryptionKeyUri = null;
        this.encryptionKey = null;
        this.encryptionIvString = null;
        this.encryptionIv = null;
    }

    private void setMediaPlaylist(int n, HlsMediaPlaylist hlsMediaPlaylist) {
        this.variantLastPlaylistLoadTimesMs[n] = SystemClock.elapsedRealtime();
        this.variantPlaylists[n] = hlsMediaPlaylist;
        this.live |= hlsMediaPlaylist.live;
        this.durationUs = this.live ? -1L : hlsMediaPlaylist.durationUs;
    }

    private boolean allVariantsBlacklisted() {
        for (int i = 0; i < this.variantBlacklistTimes.length; ++i) {
            if (this.variantBlacklistTimes[i] != 0L) continue;
            return false;
        }
        return true;
    }

    private void clearStaleBlacklistedVariants() {
        long l = SystemClock.elapsedRealtime();
        for (int i = 0; i < this.variantBlacklistTimes.length; ++i) {
            if (this.variantBlacklistTimes[i] == 0L || l - this.variantBlacklistTimes[i] <= 60000L) continue;
            this.variantBlacklistTimes[i] = 0L;
        }
    }

    private int getVariantIndex(Format format) {
        for (int i = 0; i < this.variants.length; ++i) {
            if (!this.variants[i].format.equals(format)) continue;
            return i;
        }
        throw new IllegalStateException("Invalid format: " + format);
    }

    private static final class EncryptionKeyChunk
    extends DataChunk {
        public final String iv;
        public final int variantIndex;
        private byte[] result;

        public EncryptionKeyChunk(DataSource dataSource, DataSpec dataSpec, byte[] byArray, String string, int n) {
            super(dataSource, dataSpec, 3, 0, null, -1, byArray);
            this.iv = string;
            this.variantIndex = n;
        }

        @Override
        protected void consume(byte[] byArray, int n) throws IOException {
            this.result = Arrays.copyOf(byArray, n);
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    private static final class MediaPlaylistChunk
    extends DataChunk {
        public final int variantIndex;
        private final HlsPlaylistParser playlistParser;
        private final String playlistUrl;
        private HlsMediaPlaylist result;

        public MediaPlaylistChunk(DataSource dataSource, DataSpec dataSpec, byte[] byArray, HlsPlaylistParser hlsPlaylistParser, int n, String string) {
            super(dataSource, dataSpec, 4, 0, null, -1, byArray);
            this.variantIndex = n;
            this.playlistParser = hlsPlaylistParser;
            this.playlistUrl = string;
        }

        @Override
        protected void consume(byte[] byArray, int n) throws IOException {
            this.result = (HlsMediaPlaylist)this.playlistParser.parse(this.playlistUrl, new ByteArrayInputStream(byArray, 0, n));
        }

        public HlsMediaPlaylist getResult() {
            return this.result;
        }
    }

    private static final class ExposedTrack {
        private final Variant[] variants;
        private final int defaultVariantIndex;
        private final int adaptiveMaxWidth;
        private final int adaptiveMaxHeight;

        public ExposedTrack(Variant variant) {
            this.variants = new Variant[]{variant};
            this.defaultVariantIndex = 0;
            this.adaptiveMaxWidth = -1;
            this.adaptiveMaxHeight = -1;
        }

        public ExposedTrack(Variant[] variantArray, int n, int n2, int n3) {
            this.variants = variantArray;
            this.defaultVariantIndex = n;
            this.adaptiveMaxWidth = n2;
            this.adaptiveMaxHeight = n3;
        }
    }

    public static interface EventListener
    extends BaseChunkSampleSourceEventListener {
    }
}

