/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.wav;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.wav.WavHeader;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.io.IOException;

final class WavHeaderReader {
    private static final String TAG = "WavHeaderReader";
    private static final int TYPE_PCM = 1;
    private static final int TYPE_WAVE_FORMAT_EXTENSIBLE = 65534;

    WavHeaderReader() {
    }

    public static WavHeader peek(ExtractorInput extractorInput) throws IOException, InterruptedException, ParserException {
        Assertions.checkNotNull(extractorInput);
        ParsableByteArray parsableByteArray = new ParsableByteArray(16);
        ChunkHeader chunkHeader = ChunkHeader.peek(extractorInput, parsableByteArray);
        if (chunkHeader.id != Util.getIntegerCodeForString("RIFF")) {
            return null;
        }
        extractorInput.peekFully(parsableByteArray.data, 0, 4);
        parsableByteArray.setPosition(0);
        int n = parsableByteArray.readInt();
        if (n != Util.getIntegerCodeForString("WAVE")) {
            a.d(TAG, "Unsupported RIFF format: " + n);
            return null;
        }
        ChunkHeader chunkHeader2 = ChunkHeader.peek(extractorInput, parsableByteArray);
        if (chunkHeader2.id != Util.getIntegerCodeForString("fmt ")) {
            throw new ParserException("Second chunk in RIFF WAV should be format; got: " + chunkHeader2.id);
        }
        Assertions.checkState(chunkHeader2.size >= 16L);
        extractorInput.peekFully(parsableByteArray.data, 0, 16);
        parsableByteArray.setPosition(0);
        int n2 = parsableByteArray.readLittleEndianUnsignedShort();
        int n3 = parsableByteArray.readLittleEndianUnsignedShort();
        int n4 = parsableByteArray.readLittleEndianUnsignedIntToInt();
        int n5 = parsableByteArray.readLittleEndianUnsignedIntToInt();
        int n6 = parsableByteArray.readLittleEndianUnsignedShort();
        int n7 = parsableByteArray.readLittleEndianUnsignedShort();
        int n8 = n3 * n7 / 8;
        if (n6 != n8) {
            throw new ParserException("Expected WAV block alignment of: " + n8 + "; got: " + n6);
        }
        if (n7 != 16) {
            a.d(TAG, "Only 16-bit WAVs are supported; got: " + n7);
            return null;
        }
        if (n2 != 1 && n2 != 65534) {
            a.d(TAG, "Unsupported WAV format type: " + n2);
            return null;
        }
        extractorInput.advancePeekPosition((int)chunkHeader2.size - 16);
        return new WavHeader(n3, n4, n5, n6, n7);
    }

    public static void skipToData(ExtractorInput extractorInput, WavHeader wavHeader) throws IOException, InterruptedException, ParserException {
        Assertions.checkNotNull(extractorInput);
        Assertions.checkNotNull(wavHeader);
        ParsableByteArray parsableByteArray = new ParsableByteArray(8);
        ChunkHeader chunkHeader = ChunkHeader.peek(extractorInput, parsableByteArray);
        while (chunkHeader.id != Util.getIntegerCodeForString("data")) {
            a.c(TAG, "Ignoring unknown WAV chunk: " + chunkHeader.id);
            long l = 8L + chunkHeader.size;
            if (chunkHeader.id == Util.getIntegerCodeForString("RIFF")) {
                l = 12L;
            }
            if (l > Integer.MAX_VALUE) {
                throw new ParserException("Chunk is too large (~2GB+) to skip; id: " + chunkHeader.id);
            }
            extractorInput.skipFully((int)l);
            chunkHeader = ChunkHeader.peek(extractorInput, parsableByteArray);
        }
        extractorInput.skipFully(8);
        wavHeader.setDataBounds(extractorInput.getPosition(), chunkHeader.size);
    }

    private static final class ChunkHeader {
        public static final int SIZE_IN_BYTES = 8;
        public final int id;
        public final long size;

        private ChunkHeader(int n, long l) {
            this.id = n;
            this.size = l;
        }

        public static ChunkHeader peek(ExtractorInput extractorInput, ParsableByteArray parsableByteArray) throws IOException, InterruptedException {
            extractorInput.peekFully(parsableByteArray.data, 0, 8);
            parsableByteArray.setPosition(0);
            int n = parsableByteArray.readInt();
            long l = parsableByteArray.readLittleEndianUnsignedInt();
            return new ChunkHeader(n, l);
        }
    }
}

