/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ogg;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.EOFException;
import java.io.IOException;

final class OggUtil {
    private static final int TYPE_OGGS = Util.getIntegerCodeForString("OggS");

    OggUtil() {
    }

    public static int readBits(byte by, int n, int n2) {
        return by >> n2 & 255 >>> 8 - n;
    }

    public static void skipToNextPage(ExtractorInput extractorInput) throws IOException, InterruptedException {
        byte[] byArray = new byte[2048];
        int n = byArray.length;
        while (true) {
            if (extractorInput.getLength() != -1L && extractorInput.getPosition() + (long)n > extractorInput.getLength() && (n = (int)(extractorInput.getLength() - extractorInput.getPosition())) < 4) {
                throw new EOFException();
            }
            extractorInput.peekFully(byArray, 0, n, false);
            for (int i = 0; i < n - 3; ++i) {
                if (byArray[i] != 79 || byArray[i + 1] != 103 || byArray[i + 2] != 103 || byArray[i + 3] != 83) continue;
                extractorInput.skipFully(i);
                return;
            }
            extractorInput.skipFully(n - 3);
        }
    }

    public static boolean populatePageHeader(ExtractorInput extractorInput, PageHeader pageHeader, ParsableByteArray parsableByteArray, boolean bl) throws IOException, InterruptedException {
        boolean bl2;
        parsableByteArray.reset();
        pageHeader.reset();
        boolean bl3 = bl2 = extractorInput.getLength() == -1L || extractorInput.getLength() - extractorInput.getPeekPosition() >= 27L;
        if (!bl2 || !extractorInput.peekFully(parsableByteArray.data, 0, 27, true)) {
            if (bl) {
                return false;
            }
            throw new EOFException();
        }
        if (parsableByteArray.readUnsignedInt() != (long)TYPE_OGGS) {
            if (bl) {
                return false;
            }
            throw new ParserException("expected OggS capture pattern at begin of page");
        }
        pageHeader.revision = parsableByteArray.readUnsignedByte();
        if (pageHeader.revision != 0) {
            if (bl) {
                return false;
            }
            throw new ParserException("unsupported bit stream revision");
        }
        pageHeader.type = parsableByteArray.readUnsignedByte();
        pageHeader.granulePosition = parsableByteArray.readLittleEndianLong();
        pageHeader.streamSerialNumber = parsableByteArray.readLittleEndianUnsignedInt();
        pageHeader.pageSequenceNumber = parsableByteArray.readLittleEndianUnsignedInt();
        pageHeader.pageChecksum = parsableByteArray.readLittleEndianUnsignedInt();
        pageHeader.pageSegmentCount = parsableByteArray.readUnsignedByte();
        parsableByteArray.reset();
        pageHeader.headerSize = 27 + pageHeader.pageSegmentCount;
        extractorInput.peekFully(parsableByteArray.data, 0, pageHeader.pageSegmentCount);
        for (int i = 0; i < pageHeader.pageSegmentCount; ++i) {
            pageHeader.laces[i] = parsableByteArray.readUnsignedByte();
            pageHeader.bodySize += pageHeader.laces[i];
        }
        return true;
    }

    public static void calculatePacketSize(PageHeader pageHeader, int n, PacketInfoHolder packetInfoHolder) {
        packetInfoHolder.segmentCount = 0;
        packetInfoHolder.size = 0;
        while (n + packetInfoHolder.segmentCount < pageHeader.pageSegmentCount) {
            int n2 = pageHeader.laces[n + packetInfoHolder.segmentCount++];
            packetInfoHolder.size += n2;
            if (n2 == 255) continue;
            break;
        }
    }

    public static class PacketInfoHolder {
        public int size;
        public int segmentCount;
    }

    public static final class PageHeader {
        public int revision;
        public int type;
        public long granulePosition;
        public long streamSerialNumber;
        public long pageSequenceNumber;
        public long pageChecksum;
        public int pageSegmentCount;
        public int headerSize;
        public int bodySize;
        public final int[] laces = new int[255];

        public void reset() {
            this.revision = 0;
            this.type = 0;
            this.granulePosition = 0L;
            this.streamSerialNumber = 0L;
            this.pageSequenceNumber = 0L;
            this.pageChecksum = 0L;
            this.pageSegmentCount = 0;
            this.headerSize = 0;
            this.bodySize = 0;
        }
    }
}

