/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ogg;

import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ogg.OggUtil;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

final class OggReader {
    public static final int OGG_MAX_SEGMENT_SIZE = 255;
    private final OggUtil.PageHeader pageHeader = new OggUtil.PageHeader();
    private final ParsableByteArray headerArray = new ParsableByteArray(282);
    private final OggUtil.PacketInfoHolder holder = new OggUtil.PacketInfoHolder();
    private int currentSegmentIndex = -1;
    private long elapsedSamples;

    OggReader() {
    }

    public void reset() {
        this.pageHeader.reset();
        this.headerArray.reset();
        this.currentSegmentIndex = -1;
    }

    public boolean readPacket(ExtractorInput extractorInput, ParsableByteArray parsableByteArray) throws IOException, InterruptedException {
        Assertions.checkState(extractorInput != null && parsableByteArray != null);
        boolean bl = false;
        while (!bl) {
            int n;
            if (this.currentSegmentIndex < 0) {
                if (!OggUtil.populatePageHeader(extractorInput, this.pageHeader, this.headerArray, true)) {
                    return false;
                }
                n = 0;
                int n2 = this.pageHeader.headerSize;
                if ((this.pageHeader.type & 1) == 1 && parsableByteArray.limit() == 0) {
                    OggUtil.calculatePacketSize(this.pageHeader, n, this.holder);
                    n += this.holder.segmentCount;
                    n2 += this.holder.size;
                }
                extractorInput.skipFully(n2);
                this.currentSegmentIndex = n;
            }
            OggUtil.calculatePacketSize(this.pageHeader, this.currentSegmentIndex, this.holder);
            n = this.currentSegmentIndex + this.holder.segmentCount;
            if (this.holder.size > 0) {
                extractorInput.readFully(parsableByteArray.data, parsableByteArray.limit(), this.holder.size);
                parsableByteArray.setLimit(parsableByteArray.limit() + this.holder.size);
                bl = this.pageHeader.laces[n - 1] != 255;
            }
            this.currentSegmentIndex = n == this.pageHeader.pageSegmentCount ? -1 : n;
        }
        return true;
    }

    public long readGranuleOfLastPage(ExtractorInput extractorInput) throws IOException, InterruptedException {
        Assertions.checkArgument(extractorInput.getLength() != -1L);
        OggUtil.skipToNextPage(extractorInput);
        this.pageHeader.reset();
        while ((this.pageHeader.type & 4) != 4) {
            if (this.pageHeader.bodySize > 0) {
                extractorInput.skipFully(this.pageHeader.bodySize);
            }
            OggUtil.populatePageHeader(extractorInput, this.pageHeader, this.headerArray, false);
            extractorInput.skipFully(this.pageHeader.headerSize);
        }
        return this.pageHeader.granulePosition;
    }

    public long skipToPageOfGranule(ExtractorInput extractorInput, long l) throws IOException, InterruptedException {
        OggUtil.skipToNextPage(extractorInput);
        OggUtil.populatePageHeader(extractorInput, this.pageHeader, this.headerArray, false);
        while (this.pageHeader.granulePosition < l) {
            extractorInput.skipFully(this.pageHeader.headerSize + this.pageHeader.bodySize);
            this.elapsedSamples = this.pageHeader.granulePosition;
            OggUtil.populatePageHeader(extractorInput, this.pageHeader, this.headerArray, false);
        }
        if (this.elapsedSamples == 0L) {
            throw new ParserException();
        }
        extractorInput.resetPeekPosition();
        long l2 = this.elapsedSamples;
        this.elapsedSamples = 0L;
        this.currentSegmentIndex = -1;
        return l2;
    }

    public OggUtil.PageHeader getPageHeader() {
        return this.pageHeader;
    }
}

