/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.mp4;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.GaplessInfo;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.mp4.Atom;
import com.google.android.exoplayer.extractor.mp4.AtomParsers;
import com.google.android.exoplayer.extractor.mp4.Sniffer;
import com.google.android.exoplayer.extractor.mp4.Track;
import com.google.android.exoplayer.extractor.mp4.TrackSampleTable;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.NalUnitUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;

public final class Mp4Extractor
implements Extractor,
SeekMap {
    private static final int STATE_AFTER_SEEK = 0;
    private static final int STATE_READING_ATOM_HEADER = 1;
    private static final int STATE_READING_ATOM_PAYLOAD = 2;
    private static final int STATE_READING_SAMPLE = 3;
    private static final int BRAND_QUICKTIME = Util.getIntegerCodeForString("qt  ");
    private static final long RELOAD_MINIMUM_SEEK_DISTANCE = 262144L;
    private final ParsableByteArray nalStartCode;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray atomHeader = new ParsableByteArray(16);
    private final Stack<Atom.ContainerAtom> containerAtoms = new Stack();
    private int parserState;
    private int atomType;
    private long atomSize;
    private int atomHeaderBytesRead;
    private ParsableByteArray atomData;
    private int sampleSize;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private ExtractorOutput extractorOutput;
    private Mp4Track[] tracks;
    private boolean isQuickTime;

    public Mp4Extractor() {
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.enterReadingAtomHeaderState();
    }

    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        return Sniffer.sniffUnfragmented(extractorInput);
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
    }

    @Override
    public void seek() {
        this.containerAtoms.clear();
        this.atomHeaderBytesRead = 0;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        this.parserState = 0;
    }

    @Override
    public void release() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        block5: while (true) {
            switch (this.parserState) {
                case 0: {
                    if (extractorInput.getPosition() == 0L) {
                        this.enterReadingAtomHeaderState();
                        continue block5;
                    }
                    this.parserState = 3;
                    continue block5;
                }
                case 1: {
                    if (this.readAtomHeader(extractorInput)) continue block5;
                    return -1;
                }
                case 2: {
                    if (this.readAtomPayload(extractorInput, positionHolder)) return 1;
                    continue block5;
                }
            }
            break;
        }
        return this.readSample(extractorInput, positionHolder);
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getPosition(long l) {
        long l2 = Long.MAX_VALUE;
        for (int i = 0; i < this.tracks.length; ++i) {
            TrackSampleTable trackSampleTable = this.tracks[i].sampleTable;
            int n = trackSampleTable.getIndexOfEarlierOrEqualSynchronizationSample(l);
            if (n == -1) {
                n = trackSampleTable.getIndexOfLaterOrEqualSynchronizationSample(l);
            }
            this.tracks[i].sampleIndex = n;
            long l3 = trackSampleTable.offsets[n];
            if (l3 >= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    private void enterReadingAtomHeaderState() {
        this.parserState = 1;
        this.atomHeaderBytesRead = 0;
    }

    private boolean readAtomHeader(ExtractorInput extractorInput) throws IOException, InterruptedException {
        if (this.atomHeaderBytesRead == 0) {
            if (!extractorInput.readFully(this.atomHeader.data, 0, 8, true)) {
                return false;
            }
            this.atomHeaderBytesRead = 8;
            this.atomHeader.setPosition(0);
            this.atomSize = this.atomHeader.readUnsignedInt();
            this.atomType = this.atomHeader.readInt();
        }
        if (this.atomSize == 1L) {
            int n = 8;
            extractorInput.readFully(this.atomHeader.data, 8, n);
            this.atomHeaderBytesRead += n;
            this.atomSize = this.atomHeader.readUnsignedLongToLong();
        }
        if (Mp4Extractor.shouldParseContainerAtom(this.atomType)) {
            long l = extractorInput.getPosition() + this.atomSize - (long)this.atomHeaderBytesRead;
            this.containerAtoms.add(new Atom.ContainerAtom(this.atomType, l));
            if (this.atomSize == (long)this.atomHeaderBytesRead) {
                this.processAtomEnded(l);
            } else {
                this.enterReadingAtomHeaderState();
            }
        } else if (Mp4Extractor.shouldParseLeafAtom(this.atomType)) {
            Assertions.checkState(this.atomHeaderBytesRead == 8);
            Assertions.checkState(this.atomSize <= Integer.MAX_VALUE);
            this.atomData = new ParsableByteArray((int)this.atomSize);
            System.arraycopy(this.atomHeader.data, 0, this.atomData.data, 0, 8);
            this.parserState = 2;
        } else {
            this.atomData = null;
            this.parserState = 2;
        }
        return true;
    }

    private boolean readAtomPayload(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        long l = this.atomSize - (long)this.atomHeaderBytesRead;
        long l2 = extractorInput.getPosition() + l;
        boolean bl = false;
        if (this.atomData != null) {
            extractorInput.readFully(this.atomData.data, this.atomHeaderBytesRead, (int)l);
            if (this.atomType == Atom.TYPE_ftyp) {
                this.isQuickTime = Mp4Extractor.processFtypAtom(this.atomData);
            } else if (!this.containerAtoms.isEmpty()) {
                this.containerAtoms.peek().add(new Atom.LeafAtom(this.atomType, this.atomData));
            }
        } else if (l < 262144L) {
            extractorInput.skipFully((int)l);
        } else {
            positionHolder.position = extractorInput.getPosition() + l;
            bl = true;
        }
        this.processAtomEnded(l2);
        return bl && this.parserState != 3;
    }

    private void processAtomEnded(long l) throws ParserException {
        while (!this.containerAtoms.isEmpty() && this.containerAtoms.peek().endPosition == l) {
            Atom.ContainerAtom containerAtom = this.containerAtoms.pop();
            if (containerAtom.type == Atom.TYPE_moov) {
                this.processMoovAtom(containerAtom);
                this.containerAtoms.clear();
                this.parserState = 3;
                continue;
            }
            if (this.containerAtoms.isEmpty()) continue;
            this.containerAtoms.peek().add(containerAtom);
        }
        if (this.parserState != 3) {
            this.enterReadingAtomHeaderState();
        }
    }

    private static boolean processFtypAtom(ParsableByteArray parsableByteArray) {
        parsableByteArray.setPosition(8);
        int n = parsableByteArray.readInt();
        if (n == BRAND_QUICKTIME) {
            return true;
        }
        parsableByteArray.skipBytes(4);
        while (parsableByteArray.bytesLeft() > 0) {
            if (parsableByteArray.readInt() != BRAND_QUICKTIME) continue;
            return true;
        }
        return false;
    }

    private void processMoovAtom(Atom.ContainerAtom containerAtom) throws ParserException {
        ArrayList<Mp4Track> arrayList = new ArrayList<Mp4Track>();
        long l = Long.MAX_VALUE;
        GaplessInfo gaplessInfo = null;
        Atom.LeafAtom leafAtom = containerAtom.getLeafAtomOfType(Atom.TYPE_udta);
        if (leafAtom != null) {
            gaplessInfo = AtomParsers.parseUdta(leafAtom, this.isQuickTime);
        }
        for (int i = 0; i < containerAtom.containerChildren.size(); ++i) {
            Track track;
            Atom.ContainerAtom containerAtom2 = containerAtom.containerChildren.get(i);
            if (containerAtom2.type != Atom.TYPE_trak || (track = AtomParsers.parseTrak(containerAtom2, containerAtom.getLeafAtomOfType(Atom.TYPE_mvhd), this.isQuickTime)) == null) continue;
            Atom.ContainerAtom containerAtom3 = containerAtom2.getContainerAtomOfType(Atom.TYPE_mdia).getContainerAtomOfType(Atom.TYPE_minf).getContainerAtomOfType(Atom.TYPE_stbl);
            TrackSampleTable trackSampleTable = AtomParsers.parseStbl(track, containerAtom3);
            if (trackSampleTable.sampleCount == 0) continue;
            Mp4Track mp4Track = new Mp4Track(track, trackSampleTable, this.extractorOutput.track(i));
            int n = trackSampleTable.maximumSize + 30;
            MediaFormat mediaFormat = track.mediaFormat.copyWithMaxInputSize(n);
            if (gaplessInfo != null) {
                mediaFormat = mediaFormat.copyWithGaplessInfo(gaplessInfo.encoderDelay, gaplessInfo.encoderPadding);
            }
            mp4Track.trackOutput.format(mediaFormat);
            arrayList.add(mp4Track);
            long l2 = trackSampleTable.offsets[0];
            if (l2 >= l) continue;
            l = l2;
        }
        this.tracks = arrayList.toArray(new Mp4Track[0]);
        this.extractorOutput.endTracks();
        this.extractorOutput.seekMap(this);
    }

    private int readSample(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        int n = this.getTrackIndexOfEarliestCurrentSample();
        if (n == -1) {
            return -1;
        }
        Mp4Track mp4Track = this.tracks[n];
        TrackOutput trackOutput = mp4Track.trackOutput;
        int n2 = mp4Track.sampleIndex;
        long l = mp4Track.sampleTable.offsets[n2];
        long l2 = l - extractorInput.getPosition() + (long)this.sampleBytesWritten;
        if (l2 < 0L || l2 >= 262144L) {
            positionHolder.position = l;
            return 1;
        }
        extractorInput.skipFully((int)l2);
        this.sampleSize = mp4Track.sampleTable.sizes[n2];
        if (mp4Track.track.nalUnitLengthFieldLength != -1) {
            byte[] byArray = this.nalLength.data;
            byArray[0] = 0;
            byArray[1] = 0;
            byArray[2] = 0;
            int n3 = mp4Track.track.nalUnitLengthFieldLength;
            int n4 = 4 - mp4Track.track.nalUnitLengthFieldLength;
            while (this.sampleBytesWritten < this.sampleSize) {
                if (this.sampleCurrentNalBytesRemaining == 0) {
                    extractorInput.readFully(this.nalLength.data, n4, n3);
                    this.nalLength.setPosition(0);
                    this.sampleCurrentNalBytesRemaining = this.nalLength.readUnsignedIntToInt();
                    this.nalStartCode.setPosition(0);
                    trackOutput.sampleData(this.nalStartCode, 4);
                    this.sampleBytesWritten += 4;
                    this.sampleSize += n4;
                    continue;
                }
                int n5 = trackOutput.sampleData(extractorInput, this.sampleCurrentNalBytesRemaining, false);
                this.sampleBytesWritten += n5;
                this.sampleCurrentNalBytesRemaining -= n5;
            }
        } else {
            while (this.sampleBytesWritten < this.sampleSize) {
                int n6 = trackOutput.sampleData(extractorInput, this.sampleSize - this.sampleBytesWritten, false);
                this.sampleBytesWritten += n6;
                this.sampleCurrentNalBytesRemaining -= n6;
            }
        }
        trackOutput.sampleMetadata(mp4Track.sampleTable.timestampsUs[n2], mp4Track.sampleTable.flags[n2], this.sampleSize, 0, null);
        ++mp4Track.sampleIndex;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        return 0;
    }

    private int getTrackIndexOfEarliestCurrentSample() {
        int n = -1;
        long l = Long.MAX_VALUE;
        for (int i = 0; i < this.tracks.length; ++i) {
            long l2;
            Mp4Track mp4Track = this.tracks[i];
            int n2 = mp4Track.sampleIndex;
            if (n2 == mp4Track.sampleTable.sampleCount || (l2 = mp4Track.sampleTable.offsets[n2]) >= l) continue;
            l = l2;
            n = i;
        }
        return n;
    }

    private static boolean shouldParseLeafAtom(int n) {
        return n == Atom.TYPE_mdhd || n == Atom.TYPE_mvhd || n == Atom.TYPE_hdlr || n == Atom.TYPE_stsd || n == Atom.TYPE_stts || n == Atom.TYPE_stss || n == Atom.TYPE_ctts || n == Atom.TYPE_elst || n == Atom.TYPE_stsc || n == Atom.TYPE_stsz || n == Atom.TYPE_stco || n == Atom.TYPE_co64 || n == Atom.TYPE_tkhd || n == Atom.TYPE_ftyp || n == Atom.TYPE_udta;
    }

    private static boolean shouldParseContainerAtom(int n) {
        return n == Atom.TYPE_moov || n == Atom.TYPE_trak || n == Atom.TYPE_mdia || n == Atom.TYPE_minf || n == Atom.TYPE_stbl || n == Atom.TYPE_edts;
    }

    private static final class Mp4Track {
        public final Track track;
        public final TrackSampleTable sampleTable;
        public final TrackOutput trackOutput;
        public int sampleIndex;

        public Mp4Track(Track track, TrackSampleTable trackSampleTable, TrackOutput trackOutput) {
            this.track = track;
            this.sampleTable = trackSampleTable;
            this.trackOutput = trackOutput;
        }
    }
}

