/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.flv;

import android.util.Pair;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.flv.TagPayloadReader;
import com.google.android.exoplayer.util.CodecSpecificDataUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.util.Collections;

final class AudioTagPayloadReader
extends TagPayloadReader {
    private static final int AUDIO_FORMAT_AAC = 10;
    private static final int AAC_PACKET_TYPE_SEQUENCE_HEADER = 0;
    private static final int AAC_PACKET_TYPE_AAC_RAW = 1;
    private static final int[] AUDIO_SAMPLING_RATE_TABLE = new int[]{5500, 11000, 22000, 44000};
    private boolean hasParsedAudioDataHeader;
    private boolean hasOutputFormat;

    public AudioTagPayloadReader(TrackOutput trackOutput) {
        super(trackOutput);
    }

    @Override
    public void seek() {
    }

    @Override
    protected boolean parseHeader(ParsableByteArray parsableByteArray) throws TagPayloadReader.UnsupportedFormatException {
        if (!this.hasParsedAudioDataHeader) {
            int n = parsableByteArray.readUnsignedByte();
            int n2 = n >> 4 & 0xF;
            int n3 = n >> 2 & 3;
            if (n3 < 0 || n3 >= AUDIO_SAMPLING_RATE_TABLE.length) {
                throw new TagPayloadReader.UnsupportedFormatException("Invalid sample rate index: " + n3);
            }
            if (n2 != 10) {
                throw new TagPayloadReader.UnsupportedFormatException("Audio format not supported: " + n2);
            }
            this.hasParsedAudioDataHeader = true;
        } else {
            parsableByteArray.skipBytes(1);
        }
        return true;
    }

    @Override
    protected void parsePayload(ParsableByteArray parsableByteArray, long l) {
        int n = parsableByteArray.readUnsignedByte();
        if (n == 0 && !this.hasOutputFormat) {
            byte[] byArray = new byte[parsableByteArray.bytesLeft()];
            parsableByteArray.readBytes(byArray, 0, byArray.length);
            Pair<Integer, Integer> pair = CodecSpecificDataUtil.parseAacAudioSpecificConfig(byArray);
            MediaFormat mediaFormat = MediaFormat.createAudioFormat(null, "audio/mp4a-latm", -1, -1, this.getDurationUs(), (Integer)pair.second, (Integer)pair.first, Collections.singletonList(byArray), null);
            this.output.format(mediaFormat);
            this.hasOutputFormat = true;
        } else if (n == 1) {
            int n2 = parsableByteArray.bytesLeft();
            this.output.sampleData(parsableByteArray, n2);
            this.output.sampleMetadata(l, 1, n2, 0, null);
        }
    }
}

