/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.dash.mpd.UrlTemplate;
import com.google.android.exoplayer.util.Util;
import java.util.List;

public abstract class SegmentBase {
    final RangedUri initialization;
    final long timescale;
    final long presentationTimeOffset;

    public SegmentBase(RangedUri rangedUri, long l, long l2) {
        this.initialization = rangedUri;
        this.timescale = l;
        this.presentationTimeOffset = l2;
    }

    public RangedUri getInitialization(Representation representation) {
        return this.initialization;
    }

    public long getPresentationTimeOffsetUs() {
        return Util.scaleLargeTimestamp(this.presentationTimeOffset, 1000000L, this.timescale);
    }

    public static class SegmentTimelineElement {
        long startTime;
        long duration;

        public SegmentTimelineElement(long l, long l2) {
            this.startTime = l;
            this.duration = l2;
        }
    }

    public static class SegmentTemplate
    extends MultiSegmentBase {
        final UrlTemplate initializationTemplate;
        final UrlTemplate mediaTemplate;
        private final String baseUrl;

        public SegmentTemplate(RangedUri rangedUri, long l, long l2, int n, long l3, List<SegmentTimelineElement> list, UrlTemplate urlTemplate, UrlTemplate urlTemplate2, String string) {
            super(rangedUri, l, l2, n, l3, list);
            this.initializationTemplate = urlTemplate;
            this.mediaTemplate = urlTemplate2;
            this.baseUrl = string;
        }

        @Override
        public RangedUri getInitialization(Representation representation) {
            if (this.initializationTemplate != null) {
                String string = this.initializationTemplate.buildUri(representation.format.id, 0, representation.format.bitrate, 0L);
                return new RangedUri(this.baseUrl, string, 0L, -1L);
            }
            return super.getInitialization(representation);
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, int n) {
            long l = 0L;
            l = this.segmentTimeline != null ? ((SegmentTimelineElement)this.segmentTimeline.get((int)(n - this.startNumber))).startTime : (long)(n - this.startNumber) * this.duration;
            String string = this.mediaTemplate.buildUri(representation.format.id, n, representation.format.bitrate, l);
            return new RangedUri(this.baseUrl, string, 0L, -1L);
        }

        @Override
        public int getLastSegmentNum(long l) {
            if (this.segmentTimeline != null) {
                return this.segmentTimeline.size() + this.startNumber - 1;
            }
            if (l == -1L) {
                return -1;
            }
            long l2 = this.duration * 1000000L / this.timescale;
            return this.startNumber + (int)Util.ceilDivide(l, l2) - 1;
        }
    }

    public static class SegmentList
    extends MultiSegmentBase {
        final List<RangedUri> mediaSegments;

        public SegmentList(RangedUri rangedUri, long l, long l2, int n, long l3, List<SegmentTimelineElement> list, List<RangedUri> list2) {
            super(rangedUri, l, l2, n, l3, list);
            this.mediaSegments = list2;
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, int n) {
            return this.mediaSegments.get(n - this.startNumber);
        }

        @Override
        public int getLastSegmentNum(long l) {
            return this.startNumber + this.mediaSegments.size() - 1;
        }

        @Override
        public boolean isExplicit() {
            return true;
        }
    }

    public static abstract class MultiSegmentBase
    extends SegmentBase {
        final int startNumber;
        final long duration;
        final List<SegmentTimelineElement> segmentTimeline;

        public MultiSegmentBase(RangedUri rangedUri, long l, long l2, int n, long l3, List<SegmentTimelineElement> list) {
            super(rangedUri, l, l2);
            this.startNumber = n;
            this.duration = l3;
            this.segmentTimeline = list;
        }

        public int getSegmentNum(long l, long l2) {
            int n;
            int n2 = n = this.getFirstSegmentNum();
            int n3 = this.getLastSegmentNum(l2);
            if (this.segmentTimeline == null) {
                long l3 = this.duration * 1000000L / this.timescale;
                int n4 = this.startNumber + (int)(l / l3);
                return n4 < n2 ? n2 : (n3 != -1 && n4 > n3 ? n3 : n4);
            }
            while (n2 <= n3) {
                int n5 = (n2 + n3) / 2;
                long l4 = this.getSegmentTimeUs(n5);
                if (l4 < l) {
                    n2 = n5 + 1;
                    continue;
                }
                if (l4 > l) {
                    n3 = n5 - 1;
                    continue;
                }
                return n5;
            }
            return n2 == n ? n2 : n3;
        }

        public final long getSegmentDurationUs(int n, long l) {
            if (this.segmentTimeline != null) {
                long l2 = this.segmentTimeline.get((int)(n - this.startNumber)).duration;
                return l2 * 1000000L / this.timescale;
            }
            return n == this.getLastSegmentNum(l) ? l - this.getSegmentTimeUs(n) : this.duration * 1000000L / this.timescale;
        }

        public final long getSegmentTimeUs(int n) {
            long l = this.segmentTimeline != null ? this.segmentTimeline.get((int)(n - this.startNumber)).startTime - this.presentationTimeOffset : (long)(n - this.startNumber) * this.duration;
            return Util.scaleLargeTimestamp(l, 1000000L, this.timescale);
        }

        public abstract RangedUri getSegmentUrl(Representation var1, int var2);

        public int getFirstSegmentNum() {
            return this.startNumber;
        }

        public abstract int getLastSegmentNum(long var1);

        public boolean isExplicit() {
            return this.segmentTimeline != null;
        }
    }

    public static class SingleSegmentBase
    extends SegmentBase {
        public final String uri;
        final long indexStart;
        final long indexLength;

        public SingleSegmentBase(RangedUri rangedUri, long l, long l2, String string, long l3, long l4) {
            super(rangedUri, l, l2);
            this.uri = string;
            this.indexStart = l3;
            this.indexLength = l4;
        }

        public SingleSegmentBase(String string) {
            this(null, 1L, 0L, string, 0L, -1L);
        }

        public RangedUri getIndex() {
            return this.indexLength <= 0L ? null : new RangedUri(this.uri, null, this.indexStart, this.indexLength);
        }
    }
}

