/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.PlaybackParams;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.DecoderInfo;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaClock;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.audio.AudioTrack;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.util.MimeTypes;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecAudioTrackRenderer
extends MediaCodecTrackRenderer
implements MediaClock {
    private float currentVolume = 1.0f;
    public static final int MSG_SET_MUTE = 0;
    public static final int MSG_SET_VOLUME = 1;
    public static final int MSG_SET_PLAYBACK_PARAMS = 2;
    private final EventListener eventListener;
    private final AudioTrack audioTrack;
    private boolean passthroughEnabled;
    private android.media.MediaFormat passthroughMediaFormat;
    private int audioSessionId;
    private long currentPositionUs;
    private boolean allowPositionDiscontinuity;
    private boolean audioTrackHasData;
    private long lastFeedElapsedRealtimeMs;

    public MediaCodecAudioTrackRenderer(SampleSource sampleSource, MediaCodecSelector mediaCodecSelector) {
        this(sampleSource, mediaCodecSelector, null, true);
    }

    public MediaCodecAudioTrackRenderer(SampleSource sampleSource, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean bl) {
        this(sampleSource, mediaCodecSelector, drmSessionManager, bl, null, null);
    }

    public MediaCodecAudioTrackRenderer(SampleSource sampleSource, MediaCodecSelector mediaCodecSelector, Handler handler, EventListener eventListener) {
        this(sampleSource, mediaCodecSelector, null, true, handler, eventListener);
    }

    public MediaCodecAudioTrackRenderer(SampleSource sampleSource, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean bl, Handler handler, EventListener eventListener) {
        this(sampleSource, mediaCodecSelector, drmSessionManager, bl, handler, eventListener, null, 3);
    }

    public MediaCodecAudioTrackRenderer(SampleSource sampleSource, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean bl, Handler handler, EventListener eventListener, AudioCapabilities audioCapabilities, int n) {
        this(new SampleSource[]{sampleSource}, mediaCodecSelector, drmSessionManager, bl, handler, eventListener, audioCapabilities, n);
    }

    public MediaCodecAudioTrackRenderer(SampleSource[] sampleSourceArray, MediaCodecSelector mediaCodecSelector, DrmSessionManager drmSessionManager, boolean bl, Handler handler, EventListener eventListener, AudioCapabilities audioCapabilities, int n) {
        super(sampleSourceArray, mediaCodecSelector, drmSessionManager, bl, handler, (MediaCodecTrackRenderer.EventListener)eventListener);
        this.eventListener = eventListener;
        this.audioSessionId = 0;
        this.audioTrack = new AudioTrack(audioCapabilities, n);
    }

    @Override
    protected boolean handlesTrack(MediaCodecSelector mediaCodecSelector, MediaFormat mediaFormat) throws MediaCodecUtil.DecoderQueryException {
        String string = mediaFormat.mimeType;
        return MimeTypes.isAudio(string) && ("audio/x-unknown".equals(string) || this.allowPassthrough(string) && mediaCodecSelector.getPassthroughDecoderName() != null || mediaCodecSelector.getDecoderInfo(string, false) != null);
    }

    @Override
    protected DecoderInfo getDecoderInfo(MediaCodecSelector mediaCodecSelector, String string, boolean bl) throws MediaCodecUtil.DecoderQueryException {
        String string2;
        if (this.allowPassthrough(string) && (string2 = mediaCodecSelector.getPassthroughDecoderName()) != null) {
            this.passthroughEnabled = true;
            return new DecoderInfo(string2, false);
        }
        this.passthroughEnabled = false;
        return super.getDecoderInfo(mediaCodecSelector, string, bl);
    }

    protected boolean allowPassthrough(String string) {
        return this.audioTrack.isPassthroughSupported(string);
    }

    @Override
    protected void configureCodec(MediaCodec mediaCodec, boolean bl, android.media.MediaFormat mediaFormat, MediaCrypto mediaCrypto) {
        String string = mediaFormat.getString("mime");
        if (this.passthroughEnabled) {
            mediaFormat.setString("mime", "audio/raw");
            mediaCodec.configure(mediaFormat, null, mediaCrypto, 0);
            mediaFormat.setString("mime", string);
            this.passthroughMediaFormat = mediaFormat;
        } else {
            mediaCodec.configure(mediaFormat, null, mediaCrypto, 0);
            this.passthroughMediaFormat = null;
        }
    }

    @Override
    protected MediaClock getMediaClock() {
        return this;
    }

    @Override
    protected void onOutputFormatChanged(android.media.MediaFormat mediaFormat) {
        boolean bl = this.passthroughMediaFormat != null;
        this.audioTrack.configure(bl ? this.passthroughMediaFormat : mediaFormat, bl);
    }

    protected void onAudioSessionId(int n) {
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.audioTrack.play();
    }

    @Override
    protected void onStopped() {
        this.audioTrack.pause();
        super.onStopped();
    }

    @Override
    protected boolean isEnded() {
        return super.isEnded() && !this.audioTrack.hasPendingData();
    }

    @Override
    protected boolean isReady() {
        return this.audioTrack.hasPendingData() || super.isReady();
    }

    @Override
    public long getPositionUs() {
        long l = this.audioTrack.getCurrentPositionUs(this.isEnded());
        if (l != Long.MIN_VALUE) {
            this.currentPositionUs = this.allowPositionDiscontinuity ? l : Math.max(this.currentPositionUs, l);
            this.allowPositionDiscontinuity = false;
        }
        return this.currentPositionUs;
    }

    @Override
    protected void onDisabled() throws ExoPlaybackException {
        this.audioSessionId = 0;
        try {
            this.audioTrack.release();
        }
        finally {
            super.onDisabled();
        }
    }

    @Override
    protected void onDiscontinuity(long l) throws ExoPlaybackException {
        super.onDiscontinuity(l);
        this.audioTrack.reset();
        this.currentPositionUs = l;
        this.allowPositionDiscontinuity = true;
    }

    @Override
    protected boolean processOutputBuffer(long l, long l2, MediaCodec mediaCodec, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo, int n, boolean bl) throws ExoPlaybackException {
        int n2;
        if (this.passthroughEnabled && (bufferInfo.flags & 2) != 0) {
            mediaCodec.releaseOutputBuffer(n, false);
            return true;
        }
        if (bl) {
            mediaCodec.releaseOutputBuffer(n, false);
            ++this.codecCounters.skippedOutputBufferCount;
            this.audioTrack.handleDiscontinuity();
            return true;
        }
        if (!this.audioTrack.isInitialized()) {
            try {
                if (this.audioSessionId != 0) {
                    this.audioTrack.initialize(this.audioSessionId);
                } else {
                    this.audioSessionId = this.audioTrack.initialize();
                    this.onAudioSessionId(this.audioSessionId);
                }
                this.audioTrackHasData = false;
            }
            catch (AudioTrack.InitializationException initializationException) {
                this.notifyAudioTrackInitializationError(initializationException);
                throw new ExoPlaybackException(initializationException);
            }
            if (this.getState() == 3) {
                this.audioTrack.play();
            }
        } else {
            n2 = this.audioTrackHasData;
            this.audioTrackHasData = this.audioTrack.hasPendingData();
            if (n2 != 0 && !this.audioTrackHasData && this.getState() == 3) {
                long l3 = SystemClock.elapsedRealtime() - this.lastFeedElapsedRealtimeMs;
                long l4 = this.audioTrack.getBufferSizeUs();
                long l5 = l4 == -1L ? -1L : l4 / 1000L;
                this.notifyAudioTrackUnderrun(this.audioTrack.getBufferSize(), l5, l3);
            }
        }
        try {
            n2 = this.audioTrack.handleBuffer(byteBuffer, bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs);
            this.lastFeedElapsedRealtimeMs = SystemClock.elapsedRealtime();
        }
        catch (AudioTrack.WriteException writeException) {
            this.notifyAudioTrackWriteError(writeException);
            throw new ExoPlaybackException(writeException);
        }
        if ((n2 & 1) != 0) {
            this.handleAudioTrackDiscontinuity();
            this.allowPositionDiscontinuity = true;
        }
        if ((n2 & 2) != 0) {
            mediaCodec.releaseOutputBuffer(n, false);
            ++this.codecCounters.renderedOutputBufferCount;
            return true;
        }
        return false;
    }

    @Override
    protected void onOutputStreamEnded() {
        this.audioTrack.handleEndOfStream();
    }

    protected void handleAudioTrackDiscontinuity() {
    }

    @Override
    public void handleMessage(int n, Object object) throws ExoPlaybackException {
        switch (n) {
            case 0: {
                boolean bl = (Boolean)object;
                if (bl) {
                    this.currentVolume = this.audioTrack.getCurrentVolume();
                }
                this.audioTrack.setVolume(bl ? 0.0f : this.currentVolume);
                break;
            }
            case 1: {
                this.audioTrack.setVolume(((Float)object).floatValue());
                break;
            }
            case 2: {
                if (Build.VERSION.SDK_INT < 23) break;
                this.audioTrack.setPlaybackParams((PlaybackParams)object);
                break;
            }
            default: {
                super.handleMessage(n, object);
            }
        }
    }

    public float getCurrentVolume() {
        return this.audioTrack.getCurrentVolume();
    }

    private void notifyAudioTrackInitializationError(final AudioTrack.InitializationException initializationException) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecAudioTrackRenderer.this.eventListener.onAudioTrackInitializationError(initializationException);
                }
            });
        }
    }

    private void notifyAudioTrackWriteError(final AudioTrack.WriteException writeException) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecAudioTrackRenderer.this.eventListener.onAudioTrackWriteError(writeException);
                }
            });
        }
    }

    private void notifyAudioTrackUnderrun(final int n, final long l, final long l2) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecAudioTrackRenderer.this.eventListener.onAudioTrackUnderrun(n, l, l2);
                }
            });
        }
    }

    public static interface EventListener
    extends MediaCodecTrackRenderer.EventListener {
        public void onAudioTrackInitializationError(AudioTrack.InitializationException var1);

        public void onAudioTrackWriteError(AudioTrack.WriteException var1);

        public void onAudioTrackUnderrun(int var1, long var2, long var4);
    }
}

