/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;

public final class AspectRatioFrameLayout
extends FrameLayout {
    private static final float MAX_ASPECT_RATIO_DEFORMATION_FRACTION = 0.01f;
    private float videoAspectRatio;

    public AspectRatioFrameLayout(Context context) {
        super(context);
    }

    public AspectRatioFrameLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void setAspectRatio(float f2) {
        if (this.videoAspectRatio != f2) {
            this.videoAspectRatio = f2;
            this.requestLayout();
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        super.onMeasure(n, n2);
        if (this.videoAspectRatio == 0.0f) {
            return;
        }
        int n4 = this.getMeasuredWidth();
        float f2 = (float)n4 / (float)(n3 = this.getMeasuredHeight());
        float f3 = this.videoAspectRatio / f2 - 1.0f;
        if (Math.abs(f3) <= 0.01f) {
            return;
        }
        if (f3 > 0.0f) {
            n3 = (int)((float)n4 / this.videoAspectRatio);
        } else {
            n4 = (int)((float)n3 * this.videoAspectRatio);
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000));
    }
}

