/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream.cache;

import com.google.android.exoplayer.upstream.cache.Cache;
import com.google.android.exoplayer.upstream.cache.CacheEvictor;
import com.google.android.exoplayer.upstream.cache.CacheSpan;
import java.util.Comparator;
import java.util.TreeSet;

public final class LeastRecentlyUsedCacheEvictor
implements CacheEvictor,
Comparator<CacheSpan> {
    private final long maxBytes;
    private final TreeSet<CacheSpan> leastRecentlyUsed;
    private long currentSize;

    public LeastRecentlyUsedCacheEvictor(long l) {
        this.maxBytes = l;
        this.leastRecentlyUsed = new TreeSet<CacheSpan>(this);
    }

    @Override
    public void onStartFile(Cache cache, String string, long l, long l2) {
        this.evictCache(cache, l2);
    }

    @Override
    public void onSpanAdded(Cache cache, CacheSpan cacheSpan) {
        this.leastRecentlyUsed.add(cacheSpan);
        this.currentSize += cacheSpan.length;
        this.evictCache(cache, 0L);
    }

    @Override
    public void onSpanRemoved(Cache cache, CacheSpan cacheSpan) {
        this.leastRecentlyUsed.remove(cacheSpan);
        this.currentSize -= cacheSpan.length;
    }

    @Override
    public void onSpanTouched(Cache cache, CacheSpan cacheSpan, CacheSpan cacheSpan2) {
        this.onSpanRemoved(cache, cacheSpan);
        this.onSpanAdded(cache, cacheSpan2);
    }

    @Override
    public int compare(CacheSpan cacheSpan, CacheSpan cacheSpan2) {
        long l = cacheSpan.lastAccessTimestamp - cacheSpan2.lastAccessTimestamp;
        if (l == 0L) {
            return cacheSpan.compareTo(cacheSpan2);
        }
        return cacheSpan.lastAccessTimestamp < cacheSpan2.lastAccessTimestamp ? -1 : 1;
    }

    private void evictCache(Cache cache, long l) {
        while (this.currentSize + l > this.maxBytes) {
            cache.removeSpan(this.leastRecentlyUsed.first());
        }
    }
}

