/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.hls;

import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.chunk.BaseChunkSampleSourceEventListener;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.hls.HlsChunkSource;
import com.google.android.exoplayer.hls.HlsExtractorWrapper;
import com.google.android.exoplayer.hls.TsChunk;
import com.google.android.exoplayer.hls.Variant;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public final class HlsSampleSource
implements SampleSource,
SampleSource.SampleSourceReader,
Loader.Callback {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    private static final long NO_RESET_PENDING = Long.MIN_VALUE;
    private static final int PRIMARY_TYPE_NONE = 0;
    private static final int PRIMARY_TYPE_TEXT = 1;
    private static final int PRIMARY_TYPE_AUDIO = 2;
    private static final int PRIMARY_TYPE_VIDEO = 3;
    private final HlsChunkSource chunkSource;
    private final LinkedList<HlsExtractorWrapper> extractors;
    private final int minLoadableRetryCount;
    private final int bufferSizeContribution;
    private final ChunkOperationHolder chunkOperationHolder;
    private final int eventSourceId;
    private final LoadControl loadControl;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private int remainingReleaseCount;
    private boolean prepared;
    private boolean loadControlRegistered;
    private int trackCount;
    private int enabledTrackCount;
    private Format downstreamFormat;
    private MediaFormat[] trackFormats;
    private boolean[] trackEnabledStates;
    private boolean[] pendingDiscontinuities;
    private MediaFormat[] downstreamMediaFormats;
    private int[] chunkSourceTrackIndices;
    private int[] extractorTrackIndices;
    private boolean[] extractorTrackEnabledStates;
    private long downstreamPositionUs;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean loadingFinished;
    private Chunk currentLoadable;
    private TsChunk currentTsLoadable;
    private TsChunk previousTsLoadable;
    private Loader loader;
    private IOException currentLoadableException;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;
    private long currentLoadStartTimeMs;

    public HlsSampleSource(HlsChunkSource hlsChunkSource, LoadControl loadControl, int n) {
        this(hlsChunkSource, loadControl, n, null, null, 0);
    }

    public HlsSampleSource(HlsChunkSource hlsChunkSource, LoadControl loadControl, int n, Handler handler, EventListener eventListener, int n2) {
        this(hlsChunkSource, loadControl, n, handler, eventListener, n2, 3);
    }

    public HlsSampleSource(HlsChunkSource hlsChunkSource, LoadControl loadControl, int n, Handler handler, EventListener eventListener, int n2, int n3) {
        this.chunkSource = hlsChunkSource;
        this.loadControl = loadControl;
        this.bufferSizeContribution = n;
        this.minLoadableRetryCount = n3;
        this.eventHandler = handler;
        this.eventListener = eventListener;
        this.eventSourceId = n2;
        this.pendingResetPositionUs = Long.MIN_VALUE;
        this.extractors = new LinkedList();
        this.chunkOperationHolder = new ChunkOperationHolder();
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        ++this.remainingReleaseCount;
        return this;
    }

    @Override
    public boolean prepare(long l) {
        if (this.prepared) {
            return true;
        }
        if (!this.chunkSource.prepare()) {
            return false;
        }
        if (!this.extractors.isEmpty()) {
            while (true) {
                HlsExtractorWrapper hlsExtractorWrapper;
                if ((hlsExtractorWrapper = this.extractors.getFirst()).isPrepared()) {
                    this.buildTracks(hlsExtractorWrapper);
                    this.prepared = true;
                    this.maybeStartLoading();
                    return true;
                }
                if (this.extractors.size() <= 1) break;
                this.extractors.removeFirst().clear();
            }
        }
        if (this.loader == null) {
            this.loader = new Loader("Loader:HLS");
            this.loadControl.register(this, this.bufferSizeContribution);
            this.loadControlRegistered = true;
        }
        if (!this.loader.isLoading()) {
            this.pendingResetPositionUs = l;
            this.downstreamPositionUs = l;
        }
        this.maybeStartLoading();
        return false;
    }

    @Override
    public int getTrackCount() {
        Assertions.checkState(this.prepared);
        return this.trackCount;
    }

    @Override
    public MediaFormat getFormat(int n) {
        Assertions.checkState(this.prepared);
        return this.trackFormats[n];
    }

    @Override
    public void enable(int n, long l) {
        Assertions.checkState(this.prepared);
        this.setTrackEnabledState(n, true);
        this.downstreamMediaFormats[n] = null;
        this.pendingDiscontinuities[n] = false;
        this.downstreamFormat = null;
        boolean bl = this.loadControlRegistered;
        if (!this.loadControlRegistered) {
            this.loadControl.register(this, this.bufferSizeContribution);
            this.loadControlRegistered = true;
        }
        l = this.chunkSource.isLive() ? 0L : l;
        int n2 = this.chunkSourceTrackIndices[n];
        if (n2 != -1 && n2 != this.chunkSource.getSelectedTrackIndex()) {
            this.chunkSource.selectTrack(n2);
            this.seekToInternal(l);
            return;
        }
        if (this.enabledTrackCount == 1) {
            this.lastSeekPositionUs = l;
            if (bl && this.downstreamPositionUs == l) {
                this.maybeStartLoading();
            } else {
                this.downstreamPositionUs = l;
                this.restartFrom(l);
            }
        }
    }

    @Override
    public void disable(int n) {
        Assertions.checkState(this.prepared);
        this.setTrackEnabledState(n, false);
        if (this.enabledTrackCount == 0) {
            this.chunkSource.reset();
            this.downstreamPositionUs = Long.MIN_VALUE;
            if (this.loadControlRegistered) {
                this.loadControl.unregister(this);
                this.loadControlRegistered = false;
            }
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            } else {
                this.clearState();
                this.loadControl.trimAllocator();
            }
        }
    }

    @Override
    public boolean continueBuffering(int n, long l) {
        HlsExtractorWrapper hlsExtractorWrapper;
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackEnabledStates[n]);
        this.downstreamPositionUs = l;
        if (!this.extractors.isEmpty()) {
            this.discardSamplesForDisabledTracks(this.getCurrentExtractor(), this.downstreamPositionUs);
        }
        this.maybeStartLoading();
        if (this.loadingFinished) {
            return true;
        }
        if (this.isPendingReset() || this.extractors.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.extractors.size() && (hlsExtractorWrapper = this.extractors.get(i)).isPrepared(); ++i) {
            int n2 = this.extractorTrackIndices[n];
            if (!hlsExtractorWrapper.hasSamples(n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long readDiscontinuity(int n) {
        if (this.pendingDiscontinuities[n]) {
            this.pendingDiscontinuities[n] = false;
            return this.lastSeekPositionUs;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int readData(int n, long l, MediaFormatHolder mediaFormatHolder, SampleHolder sampleHolder) {
        Assertions.checkState(this.prepared);
        this.downstreamPositionUs = l;
        if (this.pendingDiscontinuities[n] || this.isPendingReset()) {
            return -2;
        }
        HlsExtractorWrapper hlsExtractorWrapper = this.getCurrentExtractor();
        if (!hlsExtractorWrapper.isPrepared()) {
            return -2;
        }
        if (this.downstreamFormat == null || !this.downstreamFormat.equals(hlsExtractorWrapper.format)) {
            this.notifyDownstreamFormatChanged(hlsExtractorWrapper.format, hlsExtractorWrapper.trigger, hlsExtractorWrapper.startTimeUs);
            this.downstreamFormat = hlsExtractorWrapper.format;
        }
        if (this.extractors.size() > 1) {
            hlsExtractorWrapper.configureSpliceTo(this.extractors.get(1));
        }
        int n2 = this.extractorTrackIndices[n];
        int n3 = 0;
        while (this.extractors.size() > n3 + 1 && !hlsExtractorWrapper.hasSamples(n2)) {
            if ((hlsExtractorWrapper = this.extractors.get(++n3)).isPrepared()) continue;
            return -2;
        }
        MediaFormat mediaFormat = hlsExtractorWrapper.getMediaFormat(n2);
        if (mediaFormat != null && !mediaFormat.equals(this.downstreamMediaFormats[n])) {
            mediaFormatHolder.format = mediaFormat;
            this.downstreamMediaFormats[n] = mediaFormat;
            return -4;
        }
        if (hlsExtractorWrapper.getSample(n2, sampleHolder)) {
            boolean bl = sampleHolder.timeUs < this.lastSeekPositionUs;
            sampleHolder.flags = sampleHolder.flags | (bl ? 0x8000000 : 0);
            return -3;
        }
        if (this.loadingFinished) {
            return -1;
        }
        return -2;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.currentLoadableException != null && this.currentLoadableExceptionCount > this.minLoadableRetryCount) {
            throw this.currentLoadableException;
        }
        if (this.currentLoadable == null) {
            this.chunkSource.maybeThrowError();
        }
    }

    @Override
    public void seekToUs(long l) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.enabledTrackCount > 0);
        l = this.chunkSource.isLive() ? 0L : l;
        long l2 = this.isPendingReset() ? this.pendingResetPositionUs : this.downstreamPositionUs;
        this.downstreamPositionUs = l;
        this.lastSeekPositionUs = l;
        if (l2 == l) {
            return;
        }
        this.seekToInternal(l);
    }

    @Override
    public long getBufferedPositionUs() {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.enabledTrackCount > 0);
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        if (this.loadingFinished) {
            return -3L;
        }
        long l = this.extractors.getLast().getLargestParsedTimestampUs();
        if (this.extractors.size() > 1) {
            l = Math.max(l, this.extractors.get(this.extractors.size() - 2).getLargestParsedTimestampUs());
        }
        return l == Long.MIN_VALUE ? this.downstreamPositionUs : l;
    }

    @Override
    public void release() {
        Assertions.checkState(this.remainingReleaseCount > 0);
        if (--this.remainingReleaseCount == 0 && this.loader != null) {
            if (this.loadControlRegistered) {
                this.loadControl.unregister(this);
                this.loadControlRegistered = false;
            }
            this.loader.release();
            this.loader = null;
        }
    }

    @Override
    public void onLoadCompleted(Loader.Loadable loadable) {
        Assertions.checkState(loadable == this.currentLoadable);
        long l = SystemClock.elapsedRealtime();
        long l2 = l - this.currentLoadStartTimeMs;
        this.chunkSource.onChunkLoadCompleted(this.currentLoadable);
        if (this.isTsChunk(this.currentLoadable)) {
            Assertions.checkState(this.currentLoadable == this.currentTsLoadable);
            this.previousTsLoadable = this.currentTsLoadable;
            this.notifyLoadCompleted(this.currentLoadable.bytesLoaded(), this.currentTsLoadable.type, this.currentTsLoadable.trigger, this.currentTsLoadable.format, this.currentTsLoadable.startTimeUs, this.currentTsLoadable.endTimeUs, l, l2);
        } else {
            this.notifyLoadCompleted(this.currentLoadable.bytesLoaded(), this.currentLoadable.type, this.currentLoadable.trigger, this.currentLoadable.format, -1L, -1L, l, l2);
        }
        this.clearCurrentLoadable();
        this.maybeStartLoading();
    }

    @Override
    public void onLoadCanceled(Loader.Loadable loadable) {
        this.notifyLoadCanceled(this.currentLoadable.bytesLoaded());
        if (this.enabledTrackCount > 0) {
            this.restartFrom(this.pendingResetPositionUs);
        } else {
            this.clearState();
            this.loadControl.trimAllocator();
        }
    }

    @Override
    public void onLoadError(Loader.Loadable loadable, IOException iOException) {
        if (this.chunkSource.onChunkLoadError(this.currentLoadable, iOException)) {
            if (this.previousTsLoadable == null && !this.isPendingReset()) {
                this.pendingResetPositionUs = this.lastSeekPositionUs;
            }
            this.clearCurrentLoadable();
        } else {
            this.currentLoadableException = iOException;
            ++this.currentLoadableExceptionCount;
            this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        }
        this.notifyLoadError(iOException);
        this.maybeStartLoading();
    }

    private void buildTracks(HlsExtractorWrapper hlsExtractorWrapper) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = hlsExtractorWrapper.getTrackCount();
        for (n = 0; n < n4; ++n) {
            String string = hlsExtractorWrapper.getMediaFormat((int)n).mimeType;
            int n5 = MimeTypes.isVideo(string) ? 3 : (MimeTypes.isAudio(string) ? 2 : (MimeTypes.isText(string) ? 1 : 0));
            if (n5 > n2) {
                n2 = n5;
                n3 = n;
                continue;
            }
            if (n5 != n2 || n3 == -1) continue;
            n3 = -1;
        }
        n = this.chunkSource.getTrackCount();
        boolean bl = n3 != -1;
        this.trackCount = n4;
        if (bl) {
            this.trackCount += n - 1;
        }
        this.trackFormats = new MediaFormat[this.trackCount];
        this.trackEnabledStates = new boolean[this.trackCount];
        this.pendingDiscontinuities = new boolean[this.trackCount];
        this.downstreamMediaFormats = new MediaFormat[this.trackCount];
        this.chunkSourceTrackIndices = new int[this.trackCount];
        this.extractorTrackIndices = new int[this.trackCount];
        this.extractorTrackEnabledStates = new boolean[n4];
        long l = this.chunkSource.getDurationUs();
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            MediaFormat mediaFormat = hlsExtractorWrapper.getMediaFormat(i).copyWithDurationUs(l);
            String string = null;
            if (MimeTypes.isAudio(mediaFormat.mimeType)) {
                string = this.chunkSource.getMuxedAudioLanguage();
            } else if ("application/eia-608".equals(mediaFormat.mimeType)) {
                string = this.chunkSource.getMuxedCaptionLanguage();
            }
            if (i == n3) {
                for (int j = 0; j < n; ++j) {
                    this.extractorTrackIndices[n6] = i;
                    this.chunkSourceTrackIndices[n6] = j;
                    Variant variant = this.chunkSource.getFixedTrackVariant(j);
                    this.trackFormats[n6++] = variant == null ? mediaFormat.copyAsAdaptive(null) : HlsSampleSource.copyWithFixedTrackInfo(mediaFormat, variant.format, string);
                }
                continue;
            }
            this.extractorTrackIndices[n6] = i;
            this.chunkSourceTrackIndices[n6] = -1;
            this.trackFormats[n6++] = mediaFormat.copyWithLanguage(string);
        }
    }

    private void setTrackEnabledState(int n, boolean bl) {
        Assertions.checkState(this.trackEnabledStates[n] != bl);
        int n2 = this.extractorTrackIndices[n];
        Assertions.checkState(this.extractorTrackEnabledStates[n2] != bl);
        this.trackEnabledStates[n] = bl;
        this.extractorTrackEnabledStates[n2] = bl;
        this.enabledTrackCount += bl ? 1 : -1;
    }

    private static MediaFormat copyWithFixedTrackInfo(MediaFormat mediaFormat, Format format, String string) {
        int n = format.width == -1 ? -1 : format.width;
        int n2 = format.height == -1 ? -1 : format.height;
        return mediaFormat.copyWithFixedTrackInfo(format.id, format.bitrate, n, n2, string);
    }

    private void seekToInternal(long l) {
        this.lastSeekPositionUs = l;
        this.downstreamPositionUs = l;
        Arrays.fill(this.pendingDiscontinuities, true);
        this.chunkSource.seek();
        this.restartFrom(l);
    }

    private HlsExtractorWrapper getCurrentExtractor() {
        HlsExtractorWrapper hlsExtractorWrapper = this.extractors.getFirst();
        while (this.extractors.size() > 1 && !this.haveSamplesForEnabledTracks(hlsExtractorWrapper)) {
            this.extractors.removeFirst().clear();
            hlsExtractorWrapper = this.extractors.getFirst();
        }
        return hlsExtractorWrapper;
    }

    private void discardSamplesForDisabledTracks(HlsExtractorWrapper hlsExtractorWrapper, long l) {
        if (!hlsExtractorWrapper.isPrepared()) {
            return;
        }
        for (int i = 0; i < this.extractorTrackEnabledStates.length; ++i) {
            if (this.extractorTrackEnabledStates[i]) continue;
            hlsExtractorWrapper.discardUntil(i, l);
        }
    }

    private boolean haveSamplesForEnabledTracks(HlsExtractorWrapper hlsExtractorWrapper) {
        if (!hlsExtractorWrapper.isPrepared()) {
            return false;
        }
        for (int i = 0; i < this.extractorTrackEnabledStates.length; ++i) {
            if (!this.extractorTrackEnabledStates[i] || !hlsExtractorWrapper.hasSamples(i)) continue;
            return true;
        }
        return false;
    }

    private void restartFrom(long l) {
        this.pendingResetPositionUs = l;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.clearState();
            this.maybeStartLoading();
        }
    }

    private void clearState() {
        for (int i = 0; i < this.extractors.size(); ++i) {
            this.extractors.get(i).clear();
        }
        this.extractors.clear();
        this.clearCurrentLoadable();
        this.previousTsLoadable = null;
    }

    private void clearCurrentLoadable() {
        this.currentTsLoadable = null;
        this.currentLoadable = null;
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
    }

    private void maybeStartLoading() {
        long l = SystemClock.elapsedRealtime();
        long l2 = this.getNextLoadPositionUs();
        boolean bl = this.currentLoadableException != null;
        boolean bl2 = this.loader.isLoading() || bl;
        boolean bl3 = this.loadControl.update(this, this.downstreamPositionUs, l2, bl2);
        if (bl) {
            long l3 = l - this.currentLoadableExceptionTimestamp;
            if (l3 >= this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                this.currentLoadableException = null;
                this.loader.startLoading(this.currentLoadable, this);
            }
            return;
        }
        if (this.loader.isLoading() || !bl3 || this.prepared && this.enabledTrackCount == 0) {
            return;
        }
        this.chunkSource.getChunkOperation(this.previousTsLoadable, this.pendingResetPositionUs != Long.MIN_VALUE ? this.pendingResetPositionUs : this.downstreamPositionUs, this.chunkOperationHolder);
        boolean bl4 = this.chunkOperationHolder.endOfStream;
        Chunk chunk = this.chunkOperationHolder.chunk;
        this.chunkOperationHolder.clear();
        if (bl4) {
            this.loadingFinished = true;
            this.loadControl.update(this, this.downstreamPositionUs, -1L, false);
            return;
        }
        if (chunk == null) {
            return;
        }
        this.currentLoadStartTimeMs = l;
        this.currentLoadable = chunk;
        if (this.isTsChunk(this.currentLoadable)) {
            TsChunk tsChunk = (TsChunk)this.currentLoadable;
            if (this.isPendingReset()) {
                this.pendingResetPositionUs = Long.MIN_VALUE;
            }
            HlsExtractorWrapper hlsExtractorWrapper = tsChunk.extractorWrapper;
            if (this.extractors.isEmpty() || this.extractors.getLast() != hlsExtractorWrapper) {
                hlsExtractorWrapper.init(this.loadControl.getAllocator());
                this.extractors.addLast(hlsExtractorWrapper);
            }
            this.notifyLoadStarted(tsChunk.dataSpec.length, tsChunk.type, tsChunk.trigger, tsChunk.format, tsChunk.startTimeUs, tsChunk.endTimeUs);
            this.currentTsLoadable = tsChunk;
        } else {
            this.notifyLoadStarted(this.currentLoadable.dataSpec.length, this.currentLoadable.type, this.currentLoadable.trigger, this.currentLoadable.format, -1L, -1L);
        }
        this.loader.startLoading(this.currentLoadable, this);
    }

    private long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished || this.prepared && this.enabledTrackCount == 0 ? -1L : (this.currentTsLoadable != null ? this.currentTsLoadable.endTimeUs : this.previousTsLoadable.endTimeUs);
    }

    private boolean isTsChunk(Chunk chunk) {
        return chunk instanceof TsChunk;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != Long.MIN_VALUE;
    }

    private long getRetryDelayMillis(long l) {
        return Math.min((l - 1L) * 1000L, 5000L);
    }

    long usToMs(long l) {
        return l / 1000L;
    }

    private void notifyLoadStarted(final long l, final int n, final int n2, final Format format, final long l2, final long l3) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onLoadStarted(HlsSampleSource.this.eventSourceId, l, n, n2, format, HlsSampleSource.this.usToMs(l2), HlsSampleSource.this.usToMs(l3));
                }
            });
        }
    }

    private void notifyLoadCompleted(final long l, final int n, final int n2, final Format format, final long l2, final long l3, final long l4, final long l5) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onLoadCompleted(HlsSampleSource.this.eventSourceId, l, n, n2, format, HlsSampleSource.this.usToMs(l2), HlsSampleSource.this.usToMs(l3), l4, l5);
                }
            });
        }
    }

    private void notifyLoadCanceled(final long l) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onLoadCanceled(HlsSampleSource.this.eventSourceId, l);
                }
            });
        }
    }

    private void notifyLoadError(final IOException iOException) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onLoadError(HlsSampleSource.this.eventSourceId, iOException);
                }
            });
        }
    }

    private void notifyDownstreamFormatChanged(final Format format, final int n, final long l) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    HlsSampleSource.this.eventListener.onDownstreamFormatChanged(HlsSampleSource.this.eventSourceId, format, n, HlsSampleSource.this.usToMs(l));
                }
            });
        }
    }

    public static interface EventListener
    extends BaseChunkSampleSourceEventListener {
    }
}

