/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.extractor.ogg;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.PositionHolder;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.extractor.ogg.OggReader;
import com.google.android.exoplayer.extractor.ogg.OggSeeker;
import com.google.android.exoplayer.extractor.ogg.OggUtil;
import com.google.android.exoplayer.extractor.ogg.VorbisUtil;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;
import java.util.ArrayList;

public final class OggVorbisExtractor
implements Extractor,
SeekMap {
    private final ParsableByteArray scratch = new ParsableByteArray(new byte[65025], 0);
    private final OggReader oggReader = new OggReader();
    private TrackOutput trackOutput;
    private VorbisSetup vorbisSetup;
    private int previousPacketBlockSize;
    private long elapsedSamples;
    private boolean seenFirstAudioPacket;
    private final OggSeeker oggSeeker = new OggSeeker();
    private long targetGranule = -1L;
    private ExtractorOutput extractorOutput;
    private VorbisUtil.VorbisIdHeader vorbisIdHeader;
    private VorbisUtil.CommentHeader commentHeader;
    private long inputLength;
    private long audioStartPosition;
    private long totalSamples;
    private long duration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sniff(ExtractorInput extractorInput) throws IOException, InterruptedException {
        try {
            OggUtil.PageHeader pageHeader = new OggUtil.PageHeader();
            if (!OggUtil.populatePageHeader(extractorInput, pageHeader, this.scratch, true) || (pageHeader.type & 2) != 2 || pageHeader.bodySize < 7) {
                boolean bl = false;
                return bl;
            }
            this.scratch.reset();
            extractorInput.peekFully(this.scratch.data, 0, 7);
            boolean bl = VorbisUtil.verifyVorbisHeaderCapturePattern(1, this.scratch, true);
            return bl;
        }
        catch (ParserException parserException) {
        }
        finally {
            this.scratch.reset();
        }
        return false;
    }

    @Override
    public void init(ExtractorOutput extractorOutput) {
        this.trackOutput = extractorOutput.track(0);
        extractorOutput.endTracks();
        this.extractorOutput = extractorOutput;
    }

    @Override
    public void seek() {
        this.oggReader.reset();
        this.previousPacketBlockSize = 0;
        this.elapsedSamples = 0L;
        this.seenFirstAudioPacket = false;
        this.scratch.reset();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput extractorInput, PositionHolder positionHolder) throws IOException, InterruptedException {
        if (this.totalSamples == 0L) {
            if (this.vorbisSetup == null) {
                this.inputLength = extractorInput.getLength();
                this.vorbisSetup = this.readSetupHeaders(extractorInput, this.scratch);
                this.audioStartPosition = extractorInput.getPosition();
                this.extractorOutput.seekMap(this);
                if (this.inputLength != -1L) {
                    positionHolder.position = extractorInput.getLength() - 8000L;
                    return 1;
                }
            }
            this.totalSamples = this.inputLength == -1L ? -1L : this.oggReader.readGranuleOfLastPage(extractorInput);
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            arrayList.add(this.vorbisSetup.idHeader.data);
            arrayList.add(this.vorbisSetup.setupHeaderData);
            this.duration = this.inputLength == -1L ? -1L : this.totalSamples * 1000000L / this.vorbisSetup.idHeader.sampleRate;
            this.trackOutput.format(MediaFormat.createAudioFormat(null, "audio/vorbis", this.vorbisSetup.idHeader.bitrateNominal, 65025, this.duration, this.vorbisSetup.idHeader.channels, (int)this.vorbisSetup.idHeader.sampleRate, arrayList, null));
            if (this.inputLength != -1L) {
                this.oggSeeker.setup(this.inputLength - this.audioStartPosition, this.totalSamples);
                positionHolder.position = this.audioStartPosition;
                return 1;
            }
        }
        if (!this.seenFirstAudioPacket && this.targetGranule > -1L) {
            OggUtil.skipToNextPage(extractorInput);
            long l = this.oggSeeker.getNextSeekPosition(this.targetGranule, extractorInput);
            if (l != -1L) {
                positionHolder.position = l;
                return 1;
            }
            this.elapsedSamples = this.oggReader.skipToPageOfGranule(extractorInput, this.targetGranule);
            this.previousPacketBlockSize = this.vorbisIdHeader.blockSize0;
            this.seenFirstAudioPacket = true;
            this.oggSeeker.reset();
        }
        if (this.oggReader.readPacket(extractorInput, this.scratch)) {
            if ((this.scratch.data[0] & 1) != 1) {
                int n;
                int n2 = OggVorbisExtractor.decodeBlockSize(this.scratch.data[0], this.vorbisSetup);
                int n3 = n = this.seenFirstAudioPacket ? (n2 + this.previousPacketBlockSize) / 4 : 0;
                if (this.elapsedSamples + (long)n >= this.targetGranule) {
                    OggVorbisExtractor.appendNumberOfSamples(this.scratch, n);
                    long l = this.elapsedSamples * 1000000L / this.vorbisSetup.idHeader.sampleRate;
                    this.trackOutput.sampleData(this.scratch, this.scratch.limit());
                    this.trackOutput.sampleMetadata(l, 1, this.scratch.limit(), 0, null);
                    this.targetGranule = -1L;
                }
                this.seenFirstAudioPacket = true;
                this.elapsedSamples += (long)n;
                this.previousPacketBlockSize = n2;
            }
            this.scratch.reset();
            return 0;
        }
        return -1;
    }

    VorbisSetup readSetupHeaders(ExtractorInput extractorInput, ParsableByteArray parsableByteArray) throws IOException, InterruptedException {
        if (this.vorbisIdHeader == null) {
            this.oggReader.readPacket(extractorInput, parsableByteArray);
            this.vorbisIdHeader = VorbisUtil.readVorbisIdentificationHeader(parsableByteArray);
            parsableByteArray.reset();
        }
        if (this.commentHeader == null) {
            this.oggReader.readPacket(extractorInput, parsableByteArray);
            this.commentHeader = VorbisUtil.readVorbisCommentHeader(parsableByteArray);
            parsableByteArray.reset();
        }
        this.oggReader.readPacket(extractorInput, parsableByteArray);
        byte[] byArray = new byte[parsableByteArray.limit()];
        System.arraycopy(parsableByteArray.data, 0, byArray, 0, parsableByteArray.limit());
        VorbisUtil.Mode[] modeArray = VorbisUtil.readVorbisModes(parsableByteArray, this.vorbisIdHeader.channels);
        int n = VorbisUtil.iLog(modeArray.length - 1);
        parsableByteArray.reset();
        return new VorbisSetup(this.vorbisIdHeader, this.commentHeader, byArray, modeArray, n);
    }

    static void appendNumberOfSamples(ParsableByteArray parsableByteArray, long l) {
        parsableByteArray.setLimit(parsableByteArray.limit() + 4);
        parsableByteArray.data[parsableByteArray.limit() - 4] = (byte)(l & 0xFFL);
        parsableByteArray.data[parsableByteArray.limit() - 3] = (byte)(l >>> 8 & 0xFFL);
        parsableByteArray.data[parsableByteArray.limit() - 2] = (byte)(l >>> 16 & 0xFFL);
        parsableByteArray.data[parsableByteArray.limit() - 1] = (byte)(l >>> 24 & 0xFFL);
    }

    private static int decodeBlockSize(byte by, VorbisSetup vorbisSetup) {
        int n = OggUtil.readBits(by, vorbisSetup.iLogModes, 1);
        int n2 = !vorbisSetup.modes[n].blockFlag ? vorbisSetup.idHeader.blockSize0 : vorbisSetup.idHeader.blockSize1;
        return n2;
    }

    @Override
    public boolean isSeekable() {
        return this.vorbisSetup != null && this.inputLength != -1L;
    }

    @Override
    public long getPosition(long l) {
        if (l == 0L) {
            this.targetGranule = -1L;
            return this.audioStartPosition;
        }
        this.targetGranule = this.vorbisSetup.idHeader.sampleRate * l / 1000000L;
        return Math.max(this.audioStartPosition, (this.inputLength - this.audioStartPosition) * l / this.duration - 4000L);
    }

    static final class VorbisSetup {
        public final VorbisUtil.VorbisIdHeader idHeader;
        public final VorbisUtil.CommentHeader commentHeader;
        public final byte[] setupHeaderData;
        public final VorbisUtil.Mode[] modes;
        public final int iLogModes;

        public VorbisSetup(VorbisUtil.VorbisIdHeader vorbisIdHeader, VorbisUtil.CommentHeader commentHeader, byte[] byArray, VorbisUtil.Mode[] modeArray, int n) {
            this.idHeader = vorbisIdHeader;
            this.commentHeader = commentHeader;
            this.setupHeaderData = byArray;
            this.modes = modeArray;
            this.iLogModes = n;
        }
    }
}

