/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.Extractor;
import com.google.android.exoplayer.extractor.ExtractorInput;
import com.google.android.exoplayer.extractor.ExtractorOutput;
import com.google.android.exoplayer.extractor.SeekMap;
import com.google.android.exoplayer.extractor.TrackOutput;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.ParsableByteArray;
import java.io.IOException;

public final class ChunkExtractorWrapper
implements ExtractorOutput,
TrackOutput {
    private final Extractor extractor;
    private boolean extractorInitialized;
    private SingleTrackOutput output;
    private boolean seenTrack;

    public ChunkExtractorWrapper(Extractor extractor) {
        this.extractor = extractor;
    }

    public void init(SingleTrackOutput singleTrackOutput) {
        this.output = singleTrackOutput;
        if (!this.extractorInitialized) {
            this.extractor.init(this);
            this.extractorInitialized = true;
        } else {
            this.extractor.seek();
        }
    }

    public int read(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int n = this.extractor.read(extractorInput, null);
        Assertions.checkState(n != 1);
        return n;
    }

    @Override
    public TrackOutput track(int n) {
        Assertions.checkState(!this.seenTrack);
        this.seenTrack = true;
        return this;
    }

    @Override
    public void endTracks() {
        Assertions.checkState(this.seenTrack);
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.output.seekMap(seekMap);
    }

    @Override
    public void drmInitData(DrmInitData drmInitData) {
        this.output.drmInitData(drmInitData);
    }

    @Override
    public void format(MediaFormat mediaFormat) {
        this.output.format(mediaFormat);
    }

    @Override
    public int sampleData(ExtractorInput extractorInput, int n, boolean bl) throws IOException, InterruptedException {
        return this.output.sampleData(extractorInput, n, bl);
    }

    @Override
    public void sampleData(ParsableByteArray parsableByteArray, int n) {
        this.output.sampleData(parsableByteArray, n);
    }

    @Override
    public void sampleMetadata(long l, int n, int n2, int n3, byte[] byArray) {
        this.output.sampleMetadata(l, n, n2, n3, byArray);
    }

    public static interface SingleTrackOutput
    extends TrackOutput {
        public void seekMap(SeekMap var1);

        public void drmInitData(DrmInitData var1);
    }
}

